/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ValueReadQuery;

public class SQLServerPlatform
extends DatabasePlatform {
    private boolean supportsSequenceObjects;
    private boolean isConnectionDataInitialized;

    public SQLServerPlatform() {
        this.pingSQL = "SELECT 1";
        this.storedProcedureTerminationToken = " go";
    }

    @Override
    public void initializeConnectionData(Connection connection) throws SQLException {
        if (this.isConnectionDataInitialized) {
            return;
        }
        DatabaseMetaData dmd = connection.getMetaData();
        int databaseVersion = dmd.getDatabaseMajorVersion();
        this.supportsSequenceObjects = databaseVersion >= 11;
        this.isConnectionDataInitialized = true;
        this.driverSupportsNationalCharacterVarying = Helper.compareVersions(dmd.getDriverVersion(), "4.0.0") >= 0;
    }

    @Override
    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        if (this.usesNativeSQL() && !this.usesByteArrayBinding()) {
            writer.write("0x");
            Helper.writeHexString(bytes, writer);
        } else {
            super.appendByteArray(bytes, writer);
        }
    }

    @Override
    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendSybaseTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printTimestampWithoutNanos(timestamp));
        writer.write(58);
        String nanoString = Integer.toString(timestamp.getNanos());
        int numberOfZeros = 0;
        int num = Math.min(9 - nanoString.length(), 3);
        while (num > 0) {
            writer.write(48);
            ++numberOfZeros;
            --num;
        }
        if (nanoString.length() + numberOfZeros > 3) {
            nanoString = nanoString.substring(0, 3 - numberOfZeros);
        }
        writer.write(nanoString);
        writer.write("'");
    }

    protected void appendSybaseCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'");
    }

    @Override
    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    @Override
    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseTimestamp(timestamp, writer);
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    @Override
    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseCalendar(calendar, writer);
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    @Override
    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("BIT default 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMERIC", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT(16)", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("FLOAT(32)", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMERIC", 28));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMERIC", 28).setLimits(28, -19, 19));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMERIC", 28).setLimits(28, -19, 19));
        if (this.getUseNationalCharacterVaryingTypeForString()) {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("NVARCHAR", 255));
        } else {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        }
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("IMAGE", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("IMAGE", false));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("IMAGE", false));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATETIME", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("DATETIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("DATETIME2", false));
        return fieldTypeMapping;
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        StringWriter writer = new StringWriter();
        writer.write("SELECT @@IDENTITY");
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    @Override
    public ValueReadQuery buildSelectQueryForSequenceObject(String qualifiedSeqName, Integer size2) {
        return new ValueReadQuery("SELECT NEXT VALUE FOR " + qualifiedSeqName);
    }

    @Override
    public boolean dontBindUpdateAllQueryUsingTempTables() {
        return true;
    }

    @Override
    public String getBatchDelimiterString() {
        return "";
    }

    @Override
    public String getCreationInOutputProcedureToken() {
        return this.getInOutputProcedureToken();
    }

    @Override
    public String getCreationOutputProcedureToken() {
        return "OUTPUT";
    }

    @Override
    public String getInOutputProcedureToken() {
        return "OUT";
    }

    @Override
    public int getMaxFieldNameSize() {
        return 22;
    }

    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        String query = "SELECT * FROM sysobjects WHERE table_type <> 'SYSTEM_TABLE'";
        if (table != null) {
            query = table.indexOf(37) != -1 ? String.valueOf(query) + " AND table_name LIKE " + table : String.valueOf(query) + " AND table_name = " + table;
        }
        if (creator != null) {
            query = creator.indexOf(37) != -1 ? String.valueOf(query) + " AND table_owner LIKE " + creator : String.valueOf(query) + " AND table_owner = " + creator;
        }
        return session.executeSelectingCall(new SQLCall(query));
    }

    @Override
    public String getOutputProcedureToken() {
        return "";
    }

    @Override
    public String getProcedureArgumentString() {
        return "@";
    }

    @Override
    public String getProcedureCallHeader() {
        return "EXECUTE ";
    }

    @Override
    public String getStoredProcedureParameterPrefix() {
        return "@";
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT GETDATE()");
            this.timestampQuery.setAllowNativeSQLQuery(true);
        }
        return this.timestampQuery;
    }

    @Override
    public String getSelectForUpdateString() {
        return " WITH (UPDLOCK)";
    }

    @Override
    public String getSelectForUpdateNoWaitString() {
        return " WITH (UPDLOCK, NOWAIT)";
    }

    @Override
    public boolean shouldPrintLockingClauseAfterWhereClause() {
        return false;
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(ExpressionOperator.simpleFunction(54, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(123, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(128, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunction(46, "CHAR_LENGTH"));
        this.addOperator(ExpressionOperator.simpleThreeArgumentFunction(41, "SUBSTRING"));
        this.addOperator(this.singleArgumentSubstringOperator());
        this.addOperator(ExpressionOperator.addDate());
        this.addOperator(ExpressionOperator.dateName());
        this.addOperator(ExpressionOperator.datePart());
        this.addOperator(ExpressionOperator.dateDifference());
        this.addOperator(ExpressionOperator.difference());
        this.addOperator(ExpressionOperator.charIndex());
        this.addOperator(ExpressionOperator.charLength());
        this.addOperator(ExpressionOperator.reverse());
        this.addOperator(ExpressionOperator.replicate());
        this.addOperator(ExpressionOperator.right());
        this.addOperator(ExpressionOperator.cot());
        this.addOperator(ExpressionOperator.sybaseAtan2Operator());
        this.addOperator(ExpressionOperator.sybaseAddMonthsOperator());
        this.addOperator(ExpressionOperator.sybaseInStringOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(104, "ISNULL"));
        this.addOperator(ExpressionOperator.sybaseToNumberOperator());
        this.addOperator(ExpressionOperator.sybaseToDateToStringOperator());
        this.addOperator(ExpressionOperator.sybaseToDateOperator());
        this.addOperator(ExpressionOperator.sybaseToCharOperator());
        this.addOperator(ExpressionOperator.sybaseLocateOperator());
        this.addOperator(SQLServerPlatform.locate2Operator());
        this.addOperator(ExpressionOperator.simpleFunction(55, "CEILING"));
        this.addOperator(ExpressionOperator.simpleFunction(46, "LEN"));
        this.addOperator(this.modOperator());
        this.addOperator(ExpressionOperator.simpleAggregate(24, "STDEV", "standardDeviation"));
        this.addOperator(SQLServerPlatform.trimOperator());
        this.addOperator(SQLServerPlatform.trim2Operator());
        this.addOperator(SQLServerPlatform.extractOperator());
    }

    public static ExpressionOperator extractOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(138);
        exOperator.setName("EXTRACT");
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("DATEPART(");
        ((Vector)v).add(",");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator trimOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(44);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("RTRIM(LTRIM(");
        ((Vector)v).add("))");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator trim2Operator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(121);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("RTRIM(");
        ((Vector)v).add(" FROM LTRIM(");
        ((Vector)v).add(" FROM ");
        ((Vector)v).add("))");
        exOperator.printsAs(v);
        int[] argumentIndices = new int[]{1, 1, 0};
        exOperator.setArgumentIndices(argumentIndices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    @Override
    public boolean isOutputAllowWithResultSet() {
        return false;
    }

    @Override
    public boolean isSQLServer() {
        return true;
    }

    @Override
    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Long.MAX_VALUE);
        values.put(Double.class, 0.0);
        values.put(Short.class, (short)Short.MAX_VALUE);
        values.put(Byte.class, (byte)127);
        values.put(Float.class, Float.valueOf(0.0f));
        values.put(BigInteger.class, new BigInteger("9999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("999999999.9999999999999999999"));
        return values;
    }

    @Override
    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Long.MIN_VALUE);
        values.put(Double.class, -9.0);
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf(-9.0f));
        values.put(BigInteger.class, new BigInteger("-9999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-999999999.9999999999999999999"));
        return values;
    }

    public ExpressionOperator modOperator() {
        ExpressionOperator result2 = new ExpressionOperator();
        result2.setSelector(67);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement(" % ");
        result2.printsAs(v);
        result2.bePostfix();
        result2.setNodeClass(FunctionExpression.class);
        return result2;
    }

    public ExpressionOperator singleArgumentSubstringOperator() {
        ExpressionOperator result2 = new ExpressionOperator();
        result2.setSelector(133);
        result2.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement("SUBSTRING(");
        ((Vector)v).addElement(",");
        ((Vector)v).addElement(", LEN(");
        ((Vector)v).addElement("))");
        result2.printsAs(v);
        int[] indices = new int[]{0, 1, 0};
        result2.setArgumentIndices(indices);
        result2.setNodeClass(ClassConstants.FunctionExpression_Class);
        result2.bePrefix();
        return result2;
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator result2 = new ExpressionOperator();
        result2.setSelector(6);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).addElement(" =* ");
        result2.printsAs(v);
        result2.bePostfix();
        result2.setNodeClass(RelationExpression.class);
        return result2;
    }

    public static ExpressionOperator locate2Operator() {
        ExpressionOperator result2 = ExpressionOperator.simpleThreeArgumentFunction(113, "CHARINDEX");
        int[] argumentIndices = new int[]{1, 0, 2};
        result2.setArgumentIndices(argumentIndices);
        return result2;
    }

    @Override
    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" IDENTITY");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public boolean requiresProcedureCallBrackets() {
        return false;
    }

    @Override
    public boolean requiresProcedureCallOuputToken() {
        return true;
    }

    @Override
    public boolean shouldPrintInOutputTokenBeforeType() {
        return false;
    }

    @Override
    public boolean shouldPrintOutputTokenBeforeType() {
        return false;
    }

    @Override
    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsSequenceObjects() {
        return this.supportsSequenceObjects;
    }

    @Override
    public boolean supportsLocalTempTables() {
        return true;
    }

    @Override
    protected String getCreateTempTableSqlPrefix() {
        return "CREATE TABLE ";
    }

    @Override
    public DatabaseTable getTempTableForTable(DatabaseTable table) {
        return new DatabaseTable("#" + table.getName(), table.getTableQualifier(), table.shouldUseDelimiters(), this.getStartDelimiter(), this.getEndDelimiter());
    }

    @Override
    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable table, Collection pkFields, Collection assignedFields) throws IOException {
        writer.write("UPDATE ");
        String tableName = table.getQualifiedNameDelimited(this);
        writer.write(tableName);
        String tempTableName = this.getTempTableForTable(table).getQualifiedNameDelimited(this);
        SQLServerPlatform.writeAutoAssignmentSetClause(writer, null, tempTableName, assignedFields, this);
        writer.write(" FROM ");
        writer.write(tableName);
        writer.write(", ");
        writer.write(tempTableName);
        SQLServerPlatform.writeAutoJoinWhereClause(writer, tableName, tempTableName, pkFields, this);
    }
}

