/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.MarshalRecordContentHandler;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class NodeRecord
extends MarshalRecord {
    private Document document;
    private Node node;

    public NodeRecord() {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.document = xmlPlatform.createDocument();
        this.node = this.document;
    }

    public NodeRecord(String rootElementName) {
        this(rootElementName, (NamespaceResolver)null);
    }

    public NodeRecord(String rootElementName, NamespaceResolver namespaceResolver) {
        this();
        String rootElementNamespaceURI = this.resolveNamespace(namespaceResolver, rootElementName);
        Element rootElement = this.document.createElementNS(rootElementNamespaceURI, rootElementName);
        this.document.appendChild(rootElement);
        this.setDOM(rootElement);
    }

    public NodeRecord(String localRootElementName, Node parent) {
        this(localRootElementName, null, parent);
    }

    public NodeRecord(String localRootElementName, NamespaceResolver namespaceResolver, Node parent) {
        this();
        Document document2 = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        String localRootElementNamespaceURI = this.resolveNamespace(namespaceResolver, localRootElementName);
        Element child = document2.createElementNS(localRootElementNamespaceURI, localRootElementName);
        parent.appendChild(child);
        this.setDOM(child);
    }

    public NodeRecord(Node node) {
        this.setDOM(node);
        ((NamespaceResolver)this.getNamespaceResolver()).setDOM(node);
    }

    @Override
    public String getLocalName() {
        return this.node.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    @Override
    public void clear() {
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public Node getDOM() {
        return this.node;
    }

    public void setDOM(Node dom) {
        short nodeType = dom.getNodeType();
        if (9 == nodeType) {
            this.document = (Document)dom;
            this.node = dom;
        } else if (1 == nodeType || 11 == nodeType) {
            this.document = dom.getOwnerDocument();
            this.node = dom;
            ((NamespaceResolver)this.getNamespaceResolver()).setDOM(dom);
        } else {
            throw XMLMarshalException.marshalException(null);
        }
    }

    @Override
    public String transformToXML() {
        return null;
    }

    @Override
    public void startDocument(String encoding, String version) {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver, String uri, String name) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (namespaceResolver != null) {
                resolverPfx = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            NodeRecordContentHandler mrcHdlr = new NodeRecordContentHandler(this, namespaceResolver);
            XMLFragmentReader xfRdr = new XMLFragmentReader(namespaceResolver);
            xfRdr.setContentHandler(mrcHdlr);
            xfRdr.setLexicalHandler(mrcHdlr);
            try {
                xfRdr.parse(node, uri, name);
            }
            catch (SAXException sAXException) {}
        }
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            super.openStartElement(xPathFragment, namespaceResolver);
            Element element = this.document.createElementNS(xPathFragment.getNamespaceURI(), this.getNameForFragment(xPathFragment));
            this.node = this.node.appendChild(element);
            if (xPathFragment.isGeneratedPrefix()) {
                this.namespaceDeclaration(xPathFragment.getPrefix(), xPathFragment.getNamespaceURI());
            }
        }
        catch (DOMException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void element(XPathFragment frag) {
        Element element = this.document.createElementNS(frag.getNamespaceURI(), this.getNameForFragment(frag));
        this.node.appendChild(element);
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value2) {
        if (this.node.getNodeType() == 1) {
            ((Element)this.getDOM()).setAttributeNS(xPathFragment.getNamespaceURI(), this.getNameForFragment(xPathFragment), value2);
        }
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value2) {
        if (this.node.getNodeType() == 1) {
            ((Element)this.getDOM()).setAttributeNS(namespaceURI, qName, value2);
        }
    }

    @Override
    public void closeStartElement() {
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.node = this.node.getParentNode();
    }

    @Override
    public void characters(String value2) {
        if (value2.length() > 0) {
            this.node.appendChild(this.document.createTextNode(value2));
        }
    }

    @Override
    public void cdata(String value2) {
        CDATASection cdata = this.document.createCDATASection(value2);
        this.node.appendChild(cdata);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String localName) {
        int colonIndex = localName.indexOf(58);
        if (colonIndex < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.resolveNamespacePrefix("");
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(localName);
        }
        String prefix = localName.substring(0, colonIndex);
        String uri = namespaceResolver.resolveNamespacePrefix(prefix);
        if (uri == null) {
            throw XMLMarshalException.namespaceNotFound(prefix);
        }
        return uri;
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    protected class NodeRecordContentHandler
    extends MarshalRecordContentHandler
    implements LexicalHandler {
        Map<String, String> prefixMappings;

        public NodeRecordContentHandler(NodeRecord nRec, NamespaceResolver resolver) {
            super(nRec, resolver);
            this.prefixMappings = new HashMap<String, String>();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            Element element = namespaceURI == null ? NodeRecord.this.document.createElement(qName) : NodeRecord.this.document.createElementNS(namespaceURI, qName);
            NodeRecord.this.node = NodeRecord.this.node.appendChild(element);
            int i = 0;
            while (i < atts.getLength()) {
                this.marshalRecord.attribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getValue(i));
                ++i;
            }
            if (!this.prefixMappings.isEmpty()) {
                for (Map.Entry<String, String> entry2 : this.prefixMappings.entrySet()) {
                    String namespaceDeclarationPrefix = entry2.getKey();
                    if (namespaceDeclarationPrefix == null || namespaceDeclarationPrefix.length() == 0) {
                        String namespaceDeclarationURI = entry2.getValue();
                        if (namespaceDeclarationURI == null) {
                            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
                            continue;
                        }
                        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceDeclarationURI);
                        continue;
                    }
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + entry2.getKey(), entry2.getValue());
                }
                this.prefixMappings.clear();
            }
            this.marshalRecord.closeStartElement();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = ((NamespaceResolver)NodeRecord.this.getNamespaceResolver()).resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
            EntityReference entityReference = NodeRecord.this.document.createEntityReference(name);
            NodeRecord.this.node = NodeRecord.this.node.appendChild(entityReference);
        }

        @Override
        public void endEntity(String name) throws SAXException {
            NodeRecord.this.node = NodeRecord.this.node.getParentNode();
        }

        @Override
        public void startCDATA() throws SAXException {
            CDATASection cdata = NodeRecord.this.document.createCDATASection(null);
            NodeRecord.this.node = NodeRecord.this.node.appendChild(cdata);
        }

        @Override
        public void endCDATA() throws SAXException {
            NodeRecord.this.node = NodeRecord.this.node.getParentNode();
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            Comment comment2 = NodeRecord.this.document.createComment(new String(ch, start, length));
            NodeRecord.this.node.appendChild(comment2);
        }
    }
}

