/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import java.sql.Array;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ObjectRelationalDataTypeDescriptor
extends RelationalDescriptor {
    protected String structureName;
    protected Vector orderedFields = NonSynchronizedVector.newInstance();
    protected Vector allOrderedFields;

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.orderedFields == null || this.orderedFields.size() == 0) {
            this.orderedFields = this.getAllFields();
        }
        this.setAllOrderedFields();
    }

    public void addFieldOrdering(String fieldName) {
        this.getOrderedFields().addElement(new DatabaseField(fieldName));
    }

    @Override
    public Vector buildDirectValuesFromFieldValue(Object fieldValue) throws DatabaseException {
        if (fieldValue == null) {
            return null;
        }
        return Helper.vectorFromArray((Object[])fieldValue);
    }

    @Override
    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) throws DatabaseException {
        Object[] fields = Helper.arrayFromVector(directValues);
        try {
            ((DatabaseAccessor)session.getAccessor()).incrementCallCount(session);
            Connection connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
            Array array = session.getPlatform().createArray(elementDataTypeName, fields, session, connection);
            return array;
        }
        catch (SQLException ex) {
            throw DatabaseException.sqlException(ex, session, false);
        }
        finally {
            ((DatabaseAccessor)session.getAccessor()).decrementCallCount();
        }
    }

    @Override
    public Object buildFieldValueFromNestedRow(AbstractRecord nestedRow, AbstractSession session) throws DatabaseException {
        Connection connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
        return this.buildStructureFromRow(nestedRow, session, connection);
    }

    @Override
    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        Object[] fields = new Object[nestedRows.size()];
        Connection connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
        boolean reconnected = false;
        try {
            if (connection == null) {
                ((DatabaseAccessor)session.getAccessor()).incrementCallCount(session);
                reconnected = true;
                connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
            }
            int i = 0;
            Enumeration stream = nestedRows.elements();
            while (stream.hasMoreElements()) {
                AbstractRecord nestedRow = (AbstractRecord)stream.nextElement();
                fields[i++] = this.buildStructureFromRow(nestedRow, session, connection);
            }
            Array array = session.getPlatform().createArray(structureName, fields, session, connection);
            return array;
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, session, false);
        }
        finally {
            if (reconnected) {
                ((DatabaseAccessor)session.getAccessor()).decrementCallCount();
            }
        }
    }

    public static Object buildContainerFromArray(Array fieldValue, ObjectRelationalDatabaseField arrayField, AbstractSession session) throws DatabaseException {
        if (arrayField.getType() == null) {
            return fieldValue;
        }
        Object[] objects = null;
        try {
            objects = (Object[])fieldValue.getArray();
        }
        catch (SQLException ex) {
            throw DatabaseException.sqlException(ex, session, false);
        }
        if (objects == null) {
            return null;
        }
        boolean isNestedStructure = false;
        ObjectRelationalDataTypeDescriptor ord = null;
        DatabaseField nestedType = null;
        if (arrayField != null) {
            nestedType = arrayField.getNestedTypeField();
            if (nestedType != null && nestedType.getSqlType() == 2002) {
                ClassDescriptor descriptor = session.getDescriptor(nestedType.getType());
                if (descriptor != null && descriptor.isObjectRelationalDataTypeDescriptor()) {
                    ord = (ObjectRelationalDataTypeDescriptor)descriptor;
                }
            } else if (nestedType != null && nestedType instanceof ObjectRelationalDatabaseField) {
                isNestedStructure = true;
            }
        }
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSession(session);
        ContainerPolicy cp = ContainerPolicy.buildPolicyFor(arrayField.getType());
        Object container = cp.containerInstance(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object arrayValue = objects[i];
            if (arrayValue == null) {
                return null;
            }
            if (ord != null) {
                AbstractRecord nestedRow = ord.buildRowFromStructure((Struct)arrayValue);
                ClassDescriptor descriptor = ord;
                if (descriptor.hasInheritance()) {
                    Class newElementClass = descriptor.getInheritancePolicy().classFromRow(nestedRow, session);
                    if (!descriptor.getJavaClass().equals(newElementClass) && (descriptor = session.getDescriptor(newElementClass)) == null) {
                        descriptor = ord;
                    }
                }
                arrayValue = descriptor.getObjectBuilder().buildNewInstance();
                descriptor.getObjectBuilder().buildAttributesIntoObject(arrayValue, null, nestedRow, query, null, null, false, session);
            } else if (isNestedStructure && arrayValue instanceof Array) {
                arrayValue = ObjectRelationalDataTypeDescriptor.buildContainerFromArray((Array)arrayValue, (ObjectRelationalDatabaseField)nestedType, session);
            }
            cp.addInto(arrayValue, container, session);
            ++i;
        }
        return container;
    }

    @Override
    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) throws DatabaseException {
        DatabaseRecord row = new DatabaseRecord();
        Object[] attributes = (Object[])fieldValue;
        int index2 = 0;
        while (index2 < this.getAllOrderedFields().size()) {
            DatabaseField field2 = (DatabaseField)this.getAllOrderedFields().get(index2);
            row.put(field2, attributes[index2]);
            ++index2;
        }
        return row;
    }

    private void setAllOrderedFields() {
        this.allOrderedFields = new Vector(this.orderedFields.size());
        Vector<DatabaseField> allFieldsCopy = new Vector<DatabaseField>(this.getAllFields());
        for (DatabaseField orderedField : this.getOrderedFields()) {
            Iterator<DatabaseField> iterator2 = allFieldsCopy.iterator();
            while (iterator2.hasNext()) {
                DatabaseField field2 = iterator2.next();
                if (!orderedField.getName().equalsIgnoreCase(field2.getName())) continue;
                this.allOrderedFields.add(field2);
                iterator2.remove();
            }
        }
    }

    @Override
    public Vector buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) throws DatabaseException {
        if (fieldValue == null) {
            return null;
        }
        Object[] structs = (Object[])fieldValue;
        Vector<AbstractRecord> nestedRows = new Vector<AbstractRecord>(structs.length);
        int i = 0;
        while (i < structs.length) {
            Object[] struct = (Object[])structs[i];
            if (struct == null) {
                return null;
            }
            nestedRows.addElement(this.buildNestedRowFromFieldValue(struct));
            ++i;
        }
        return nestedRows;
    }

    public AbstractRecord buildRowFromStructure(Struct structure) throws DatabaseException {
        Object[] attributes;
        try {
            attributes = structure.getAttributes();
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception);
        }
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                if (attributes[i] instanceof Array) {
                    attributes[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromArray(attributes[i]);
                } else if (attributes[i] instanceof Struct) {
                    attributes[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromStruct(attributes[i]);
                }
                ++i;
            }
        }
        return this.buildNestedRowFromFieldValue(attributes);
    }

    public Struct buildStructureFromRow(AbstractRecord row, AbstractSession session, Connection connection) throws DatabaseException {
        Struct structure;
        boolean reconnected = false;
        try {
            try {
                if (connection == null) {
                    ((DatabaseAccessor)session.getAccessor()).incrementCallCount(session);
                    reconnected = true;
                    connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
                }
                Object[] fields = new Object[this.getOrderedFields().size()];
                int index2 = 0;
                while (index2 < this.getOrderedFields().size()) {
                    DatabaseField field2 = (DatabaseField)this.getOrderedFields().elementAt(index2);
                    fields[index2] = row.get(field2);
                    ++index2;
                }
                structure = session.getPlatform().createStruct(this.getStructureName(), fields, session, connection);
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception, session, false);
            }
        }
        finally {
            if (reconnected) {
                ((DatabaseAccessor)session.getAccessor()).decrementCallCount();
            }
        }
        return structure;
    }

    public static Object buildArrayObjectFromArray(Object array) throws DatabaseException {
        Object[] objects = null;
        if (array == null) {
            return array;
        }
        try {
            objects = (Object[])((Array)array).getArray();
        }
        catch (SQLException ex) {
            throw DatabaseException.sqlException(ex);
        }
        if (objects == null) {
            return null;
        }
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof Array) {
                objects[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromArray(objects[i]);
            }
            if (objects[i] instanceof Struct) {
                objects[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromStruct(objects[i]);
            }
            ++i;
        }
        return objects;
    }

    public static Object buildArrayObjectFromStruct(Object structure) throws DatabaseException {
        Object[] attributes = null;
        if (structure == null) {
            return structure;
        }
        try {
            attributes = ((Struct)structure).getAttributes();
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception);
        }
        if (attributes == null) {
            return null;
        }
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i] instanceof Array) {
                attributes[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromArray(attributes[i]);
            }
            if (attributes[i] instanceof Struct) {
                attributes[i] = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromStruct(attributes[i]);
            }
            ++i;
        }
        return attributes;
    }

    @Override
    protected DatabaseTable extractDefaultTable() {
        if (this.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return super.extractDefaultTable();
    }

    public Vector getOrderedFields() {
        return this.orderedFields;
    }

    private Vector getAllOrderedFields() {
        return this.allOrderedFields;
    }

    public Ref getRef(Object object, AbstractSession session) {
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.getTables().firstElement());
        statement.getFields().addElement(new ExpressionBuilder().ref());
        statement.setWhereClause(this.getObjectBuilder().buildPrimaryKeyExpressionFromObject(object, session));
        statement.setRequiresAliases(true);
        statement.normalize(session, this);
        ValueReadQuery valueQuery = new ValueReadQuery();
        valueQuery.setSQLStatement(statement);
        valueQuery.checkPrepare(session, new DatabaseRecord(), true);
        valueQuery.getCall().setIsNativeConnectionRequired(true);
        Ref ref = (Ref)session.executeQuery(valueQuery);
        return ref;
    }

    public String getStructureName() {
        return this.structureName;
    }

    @Override
    public boolean isObjectRelationalDataTypeDescriptor() {
        return true;
    }

    @Override
    public boolean requiresInitialization(AbstractSession session) {
        return true;
    }

    @Override
    protected void validateMappingType(DatabaseMapping mapping) {
    }

    public void setOrderedFields(Vector orderedFields) {
        this.orderedFields = orderedFields;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }
}

