/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.eclipse.persistence.core.sessions.CoreProject;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.MappingsGenerator;
import org.eclipse.persistence.jaxb.compiler.SchemaGenerator;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelInputImpl;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLMarshaller;

public class Generator {
    private AnnotationsProcessor annotationsProcessor;
    private SchemaGenerator schemaGenerator;
    private MappingsGenerator mappingsGenerator;
    private Helper helper;
    private Map<Type, TypeMappingInfo> typeToTypeMappingInfo;

    public Generator(JavaModelInput jModelInput) {
        this.helper = new Helper(jModelInput.getJavaModel());
        if (jModelInput instanceof JavaModelInputImpl) {
            this.helper.setFacets(((JavaModelInputImpl)jModelInput).isFacets());
        }
        this.annotationsProcessor = new AnnotationsProcessor(this.helper);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        this.annotationsProcessor.processClassesAndProperties(jModelInput.getJavaClasses(), null);
    }

    public Generator(JavaModelInput jModelInput, Map<String, XmlBindings> xmlBindings, ClassLoader cLoader, String defaultTargetNamespace, boolean enableXmlAccessorFactory) {
        this.helper = new Helper(jModelInput.getJavaModel());
        this.annotationsProcessor = new AnnotationsProcessor(this.helper);
        this.annotationsProcessor.setXmlAccessorFactorySupport(enableXmlAccessorFactory);
        this.annotationsProcessor.setDefaultTargetNamespace(defaultTargetNamespace);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        if (xmlBindings != null && !xmlBindings.isEmpty()) {
            new XMLProcessor(xmlBindings).processXML(this.annotationsProcessor, jModelInput, null, null);
        } else {
            this.annotationsProcessor.processClassesAndProperties(jModelInput.getJavaClasses(), null);
        }
    }

    public Generator(JavaModelInput jModelInput, TypeMappingInfo[] typeMappingInfos, JavaClass[] javaClasses, Map<Type, TypeMappingInfo> typeToTypeMappingInfo, String defaultTargetNamespace) {
        this.helper = new Helper(jModelInput.getJavaModel());
        this.annotationsProcessor = new AnnotationsProcessor(this.helper);
        this.annotationsProcessor.setDefaultTargetNamespace(defaultTargetNamespace);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        this.typeToTypeMappingInfo = typeToTypeMappingInfo;
        this.annotationsProcessor.processClassesAndProperties(javaClasses, typeMappingInfos);
    }

    public Generator(JavaModelInput jModelInput, TypeMappingInfo[] typeMappingInfos, JavaClass[] javaClasses, Map<Type, TypeMappingInfo> typeToTypeMappingInfo, Map<String, XmlBindings> xmlBindings, ClassLoader cLoader, String defaultTargetNamespace, boolean enableXmlAccessorFactory) {
        this.helper = new Helper(jModelInput.getJavaModel());
        this.annotationsProcessor = new AnnotationsProcessor(this.helper);
        this.annotationsProcessor.setXmlAccessorFactorySupport(enableXmlAccessorFactory);
        this.annotationsProcessor.setDefaultTargetNamespace(defaultTargetNamespace);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        this.typeToTypeMappingInfo = typeToTypeMappingInfo;
        if (xmlBindings != null && !xmlBindings.isEmpty()) {
            new XMLProcessor(xmlBindings).processXML(this.annotationsProcessor, jModelInput, typeMappingInfos, javaClasses);
        } else {
            this.annotationsProcessor.processClassesAndProperties(javaClasses, typeMappingInfos);
        }
    }

    public void postInitialize() {
        this.mappingsGenerator = null;
        this.annotationsProcessor.postInitialize();
        this.schemaGenerator = null;
    }

    public boolean hasMarshalCallbacks() {
        return this.getMarshalCallbacks() != null && !this.getMarshalCallbacks().isEmpty();
    }

    public boolean hasUnmarshalCallbacks() {
        return this.getUnmarshalCallbacks() != null && !this.getUnmarshalCallbacks().isEmpty();
    }

    public CoreProject generateProject() throws Exception {
        this.mappingsGenerator.getClassToGeneratedClasses().putAll(this.annotationsProcessor.getArrayClassesToGeneratedClasses());
        CoreProject p = this.mappingsGenerator.generateProject(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfos(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToPackageInfoMappings(), this.annotationsProcessor.getGlobalElements(), this.annotationsProcessor.getLocalElements(), this.annotationsProcessor.getTypeMappingInfosToGeneratedClasses(), this.annotationsProcessor.getTypeMappingInfoToAdapterClasses(), this.annotationsProcessor.isDefaultNamespaceAllowed());
        this.annotationsProcessor.getArrayClassesToGeneratedClasses().putAll(this.mappingsGenerator.getClassToGeneratedClasses());
        return p;
    }

    public Collection<Schema> generateSchema() {
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfos(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToPackageInfoMappings(), null, this.annotationsProcessor.getArrayClassesToGeneratedClasses());
        return this.schemaGenerator.getAllSchemas();
    }

    public Map<String, SchemaTypeInfo> generateSchemaFiles(String schemaPath, Map<QName, Type> additionalGlobalElements) throws FileNotFoundException {
        this.processAdditionalElements(additionalGlobalElements, this.annotationsProcessor);
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfos(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToPackageInfoMappings(), this.annotationsProcessor.getGlobalElements(), this.annotationsProcessor.getArrayClassesToGeneratedClasses());
        SchemaModelProject proj = new SchemaModelProject();
        XMLContext context = new XMLContext(proj);
        XMLMarshaller marshaller = context.createMarshaller();
        Descriptor schemaDescriptor = (Descriptor)proj.getDescriptor(Schema.class);
        Collection<Schema> schemas = this.schemaGenerator.getAllSchemas();
        for (Schema schema : schemas) {
            File file = new File(String.valueOf(schemaPath) + "/" + schema.getName());
            NamespaceResolver schemaNamespaces = schema.getNamespaceResolver();
            schemaNamespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
            schemaDescriptor.setNamespaceResolver(schemaNamespaces);
            marshaller.marshal((Object)schema, new FileOutputStream(file));
        }
        return this.schemaGenerator.getSchemaTypeInfo();
    }

    public Map<String, SchemaTypeInfo> generateSchemaFiles(SchemaOutputResolver outputResolver, Map<QName, Type> additionalGlobalElements) {
        this.processAdditionalElements(additionalGlobalElements, this.annotationsProcessor);
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfos(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToPackageInfoMappings(), this.annotationsProcessor.getGlobalElements(), this.annotationsProcessor.getArrayClassesToGeneratedClasses(), outputResolver);
        SchemaModelProject proj = new SchemaModelProject();
        XMLContext context = new XMLContext(proj);
        XMLMarshaller marshaller = context.createMarshaller();
        Descriptor schemaDescriptor = (Descriptor)proj.getDescriptor(Schema.class);
        Collection<Schema> schemas = this.schemaGenerator.getAllSchemas();
        for (Schema schema : schemas) {
            try {
                NamespaceResolver schemaNamespaces = schema.getNamespaceResolver();
                schemaNamespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
                schemaDescriptor.setNamespaceResolver(schemaNamespaces);
                Result target = schema.hasResult() ? schema.getResult() : outputResolver.createOutput(schema.getTargetNamespace(), schema.getName());
                marshaller.marshal((Object)schema, target);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.schemaGenerator.getSchemaTypeInfo();
    }

    private void processAdditionalElements(Map<QName, Type> additionalGlobalElements, AnnotationsProcessor annotationsProcessor) {
        if (additionalGlobalElements != null) {
            for (Map.Entry<QName, Type> entry2 : additionalGlobalElements.entrySet()) {
                QName key = entry2.getKey();
                Type type = entry2.getValue();
                TypeMappingInfo tmi = null;
                if (this.typeToTypeMappingInfo != null) {
                    tmi = this.typeToTypeMappingInfo.get(type);
                }
                if (tmi != null && annotationsProcessor.getTypeMappingInfosToGeneratedClasses().get(tmi) != null) {
                    type = annotationsProcessor.getTypeMappingInfosToGeneratedClasses().get(tmi);
                }
                JavaClass jClass = null;
                if (type instanceof Class) {
                    Class tClass = (Class)type;
                    jClass = this.helper.getJavaClass(tClass);
                }
                if (jClass == null) continue;
                ElementDeclaration declaration = new ElementDeclaration(key, jClass, jClass.getQualifiedName(), false);
                annotationsProcessor.getGlobalElements().put(key, declaration);
            }
        }
    }

    public Map getUnmarshalCallbacks() {
        return this.annotationsProcessor.getUnmarshalCallbacks();
    }

    public Map getMarshalCallbacks() {
        return this.annotationsProcessor.getMarshalCallbacks();
    }

    public MappingsGenerator getMappingsGenerator() {
        return this.mappingsGenerator;
    }

    public AnnotationsProcessor getAnnotationsProcessor() {
        return this.annotationsProcessor;
    }

    public void setTypeToTypeMappingInfo(Map<Type, TypeMappingInfo> typesToTypeMapping) {
        this.typeToTypeMappingInfo = typesToTypeMapping;
    }

    public Map<Type, TypeMappingInfo> getTypeToTypeMappingInfo() {
        return this.typeToTypeMappingInfo;
    }
}

