/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLFragmentReader
extends DOMReader {
    protected NamespaceResolver nsresolver;
    protected List<NamespaceResolver> nsresolverList = new ArrayList<NamespaceResolver>();
    protected Map<Element, NamespaceResolver> tmpresolverMap;

    public XMLFragmentReader(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null) {
            this.nsresolverList.add(namespaceResolver);
        }
        this.tmpresolverMap = new HashMap<Element, NamespaceResolver>();
    }

    @Override
    public void parse(Node node, String uri, String name) throws SAXException {
        if (node.getNodeType() == 11) {
            this.handleChildNodes(node.getChildNodes());
        } else {
            super.parse(node, uri, name);
        }
    }

    @Override
    protected void reportElementEvents(Element elem2) throws SAXException {
        super.reportElementEvents(elem2);
        this.cleanupNamespaceResolvers(elem2);
    }

    @Override
    protected void endDocument() throws SAXException {
    }

    @Override
    protected void startDocument() throws SAXException {
    }

    @Override
    protected void handleNewNamespaceDeclaration(Element elem2, String prefix, String namespaceURI) {
        String uri = this.resolveNamespacePrefix(prefix);
        if (uri == null || !uri.equals(namespaceURI)) {
            NamespaceResolver tmpresolver = this.getTempResolver(elem2);
            tmpresolver.put(prefix, namespaceURI);
            if (!this.nsresolverList.contains(tmpresolver)) {
                this.nsresolverList.add(tmpresolver);
            }
        }
    }

    @Override
    protected void handlePrefixedAttribute(Element elem2) throws SAXException {
        NamedNodeMap attributes;
        String uri;
        String prefix = elem2.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        if ((uri = this.resolveNamespacePrefix(prefix)) == null && elem2.getNamespaceURI() != null || uri != null && !uri.equals(elem2.getNamespaceURI())) {
            String namespaceURI;
            NamespaceResolver tmpresolver = this.getTempResolver(elem2);
            tmpresolver.put(prefix, elem2.getNamespaceURI());
            if (!this.nsresolverList.contains(tmpresolver)) {
                this.nsresolverList.add(tmpresolver);
            }
            if ((namespaceURI = elem2.getNamespaceURI()) == null) {
                namespaceURI = "";
            }
            this.getContentHandler().startPrefixMapping(prefix, namespaceURI);
        }
        if ((attributes = elem2.getAttributes()) != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                NamespaceResolver tmpresolver;
                Node attribute = attributes.item(x);
                if ("xmlns".equals(attribute.getPrefix())) {
                    tmpresolver = this.getTempResolver(elem2);
                    tmpresolver.put(attribute.getLocalName(), attribute.getNodeValue());
                    if (!this.nsresolverList.contains(tmpresolver)) {
                        this.nsresolverList.add(tmpresolver);
                    }
                } else if ("xmlns".equals(attribute.getNodeName())) {
                    tmpresolver = this.getTempResolver(elem2);
                    String namespace = attribute.getNodeValue();
                    if (namespace == null) {
                        namespace = "";
                    }
                    tmpresolver.put("", namespace);
                    if (!this.nsresolverList.contains(tmpresolver)) {
                        this.nsresolverList.add(tmpresolver);
                    }
                }
                ++x;
            }
        }
    }

    @Override
    protected void endPrefixMappings(Element elem2) throws SAXException {
        NamespaceResolver tmpresolver = this.getTempResolver(elem2);
        if (tmpresolver != null) {
            ExtendedContentHandler contentHandler = this.getContentHandler();
            String defaultNamespace = tmpresolver.getDefaultNamespaceURI();
            if (defaultNamespace != null) {
                contentHandler.endPrefixMapping("");
            }
            if (tmpresolver.hasPrefixesToNamespaces()) {
                for (Map.Entry<String, String> entry2 : tmpresolver.getPrefixesToNamespaces().entrySet()) {
                    contentHandler.endPrefixMapping(entry2.getKey());
                }
            }
        }
    }

    protected NamespaceResolver getTempResolver(Element elem2) {
        NamespaceResolver tmpresolver = this.tmpresolverMap.get(elem2);
        if (tmpresolver == null) {
            tmpresolver = new NamespaceResolver();
            this.tmpresolverMap.put(elem2, tmpresolver);
        }
        return tmpresolver;
    }

    protected void cleanupNamespaceResolvers(Element elem2) {
        NamespaceResolver tmpresolver = this.tmpresolverMap.get(elem2);
        if (tmpresolver != null) {
            this.tmpresolverMap.remove(elem2);
            this.nsresolverList.remove(tmpresolver);
        }
    }

    protected String resolveNamespacePrefix(String prefix) {
        String uri = null;
        if (prefix == null || prefix.length() == 0) {
            int i = this.nsresolverList.size() - 1;
            while (i >= 0) {
                NamespaceResolver next2 = this.nsresolverList.get(i);
                uri = next2.getDefaultNamespaceURI();
                if (uri == null || uri.length() <= 0) {
                    --i;
                    continue;
                }
                break;
            }
        } else {
            int i = this.nsresolverList.size() - 1;
            while (i >= 0) {
                NamespaceResolver next3 = this.nsresolverList.get(i);
                uri = next3.resolveNamespacePrefix(prefix);
                if (uri == null || uri.length() <= 0) {
                    --i;
                    continue;
                }
                break;
            }
        }
        return uri;
    }

    @Override
    protected void processParentNamespaces(Element element) throws SAXException {
    }

    @Override
    protected void handleXsiTypeAttribute(Attr attr) throws SAXException {
        String prefix;
        String uri;
        String value2 = attr.getValue();
        int colon2 = value2.indexOf(58);
        if (colon2 != -1 && (uri = this.resolveNamespacePrefix(prefix = value2.substring(0, colon2))) == null && (uri = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(attr.getOwnerElement(), prefix)) != null) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }
}

