/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.persistence.internal.cache.ComputableTask;
import org.eclipse.persistence.internal.cache.LowLevelProcessor;

public class Memoizer<A, V>
implements LowLevelProcessor<A, V> {
    private final ConcurrentMap<CacheKey, Future<V>> cache = new ConcurrentHashMap<CacheKey, Future<V>>();

    /*
     * Loose catch block
     */
    @Override
    public V compute(final ComputableTask<A, V> c, final A taskArg) throws InterruptedException {
        CacheKey key = new CacheKey(c, taskArg);
        while (true) {
            Callable evaluation;
            FutureTask ft;
            FutureTask f;
            if ((f = (FutureTask)this.cache.get(key)) == null && (f = (Future)this.cache.putIfAbsent(key, ft = new FutureTask(evaluation = new Callable<V>(){

                @Override
                public V call() throws InterruptedException {
                    return c.compute(taskArg);
                }
            }))) == null) {
                f = ft;
                ft.run();
            }
            try {
                return f.get();
            }
            catch (CancellationException cancellationException) {
                this.cache.remove(key, f);
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void forget(ComputableTask<A, V> task, A key) {
        Memoizer memoizer = this;
        memoizer.getClass();
        this.cache.remove(memoizer.new CacheKey(task, key));
    }

    public void forgetAll() {
        this.cache.clear();
    }

    private class CacheKey {
        private final ComputableTask<A, V> task;
        private final A key;

        private CacheKey(ComputableTask<A, V> task, A key) {
            this.task = task;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.key != null ? !this.key.equals(cacheKey.key) : cacheKey.key != null) {
                return false;
            }
            return !(this.task != null ? !this.task.equals(cacheKey.task) : cacheKey.task != null);
        }

        public int hashCode() {
            int result2 = this.task != null ? this.task.hashCode() : 0;
            result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
            return result2;
        }
    }
}

