/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.version.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerGen {
    private static final String PACKAGE_NAME = "org.apache.zookeeper.version";
    private static final String TYPE_NAME = "Info";

    static void printUsage() {
        System.out.print("Usage:\tjava  -cp <classpath> org.apache.zookeeper.version.util.VerGen maj.min.micro[-qualifier] rev buildDate");
        System.exit(1);
    }

    public static void generateFile(File outputDir, Version version, String rev, String buildDate) {
        String path = PACKAGE_NAME.replaceAll("\\.", "/");
        File pkgdir = new File(outputDir, path);
        if (!pkgdir.exists()) {
            boolean ret = pkgdir.mkdirs();
            if (!ret) {
                System.out.println("Cannnot create directory: " + path);
                System.exit(1);
            }
        } else if (!pkgdir.isDirectory()) {
            System.out.println(path + " is not a directory.");
            System.exit(1);
        }
        try (FileWriter w = new FileWriter(new File(pkgdir, "Info.java"));){
            w.write("// Do not edit!\n// File generated by org.apache.zookeeper.version.util.VerGen.\n");
            w.write("/**\n");
            w.write("* Licensed to the Apache Software Foundation (ASF) under one\n");
            w.write("* or more contributor license agreements.  See the NOTICE file\n");
            w.write("* distributed with this work for additional information\n");
            w.write("* regarding copyright ownership.  The ASF licenses this file\n");
            w.write("* to you under the Apache License, Version 2.0 (the\n");
            w.write("* \"License\"); you may not use this file except in compliance\n");
            w.write("* with the License.  You may obtain a copy of the License at\n");
            w.write("*\n");
            w.write("*     http://www.apache.org/licenses/LICENSE-2.0\n");
            w.write("*\n");
            w.write("* Unless required by applicable law or agreed to in writing, software\n");
            w.write("* distributed under the License is distributed on an \"AS IS\" BASIS,\n");
            w.write("* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n");
            w.write("* See the License for the specific language governing permissions and\n");
            w.write("* limitations under the License.\n");
            w.write("*/\n");
            w.write("\n");
            w.write("package org.apache.zookeeper.version;\n\n");
            w.write("public interface Info {\n");
            w.write("    int MAJOR=" + version.maj + ";\n");
            w.write("    int MINOR=" + version.min + ";\n");
            w.write("    int MICRO=" + version.micro + ";\n");
            w.write("    String QUALIFIER=" + (version.qualifier == null ? null : "\"" + version.qualifier + "\"") + ";\n");
            if (rev.equals("-1")) {
                System.out.println("Unknown REVISION number, using " + rev);
            }
            w.write("    int REVISION=-1; //TODO: remove as related to SVN VCS\n");
            w.write("    String REVISION_HASH=\"" + rev + "\";\n");
            w.write("    String BUILD_DATE=\"" + buildDate + "\";\n");
            w.write("}\n");
        }
        catch (IOException e) {
            System.out.println("Unable to generate version.Info file: " + e.getMessage());
            System.exit(1);
        }
    }

    public static Version parseVersionString(String input2) {
        Version result2 = new Version();
        Pattern p = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)((\\.\\d+)*)(-(.+))?$");
        Matcher m = p.matcher(input2);
        if (!m.matches()) {
            return null;
        }
        result2.maj = Integer.parseInt(m.group(1));
        result2.min = Integer.parseInt(m.group(2));
        result2.micro = Integer.parseInt(m.group(3));
        result2.qualifier = m.groupCount() == 7 ? m.group(7) : null;
        return result2;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            VerGen.printUsage();
        }
        try {
            String rev;
            Version version = VerGen.parseVersionString(args[0]);
            if (version == null) {
                System.err.println("Invalid version number format, must be \"x.y.z(-.*)?\"");
                System.exit(1);
            }
            rev = (rev = args[1]) == null || rev.trim().isEmpty() ? "-1" : rev.trim();
            VerGen.generateFile(new File("."), version, rev, args[2]);
        }
        catch (NumberFormatException e) {
            System.err.println("All version-related parameters must be valid integers!");
            throw e;
        }
    }

    public static class Version {
        public int maj;
        public int min;
        public int micro;
        public String qualifier;
    }
}

