/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.zookeeper.common.Time;

public class ExpiryQueue<E> {
    private final ConcurrentHashMap<E, Long> elemMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Set<E>> expiryMap = new ConcurrentHashMap();
    private final AtomicLong nextExpirationTime = new AtomicLong();
    private final int expirationInterval;

    public ExpiryQueue(int expirationInterval) {
        this.expirationInterval = expirationInterval;
        this.nextExpirationTime.set(this.roundToNextInterval(Time.currentElapsedTime()));
    }

    private long roundToNextInterval(long time) {
        return (time / (long)this.expirationInterval + 1L) * (long)this.expirationInterval;
    }

    public Long remove(E elem2) {
        Set<E> set;
        Long expiryTime = this.elemMap.remove(elem2);
        if (expiryTime != null && (set = this.expiryMap.get(expiryTime)) != null) {
            set.remove(elem2);
        }
        return expiryTime;
    }

    public Long update(E elem2, int timeout) {
        Set<E> prevSet;
        Set<E> existingSet;
        Long prevExpiryTime = this.elemMap.get(elem2);
        long now = Time.currentElapsedTime();
        Long newExpiryTime = this.roundToNextInterval(now + (long)timeout);
        if (newExpiryTime.equals(prevExpiryTime)) {
            return null;
        }
        Set<Object> set = this.expiryMap.get(newExpiryTime);
        if (set == null && (existingSet = this.expiryMap.putIfAbsent(newExpiryTime, set = Collections.newSetFromMap(new ConcurrentHashMap()))) != null) {
            set = existingSet;
        }
        set.add(elem2);
        prevExpiryTime = this.elemMap.put(elem2, newExpiryTime);
        if (prevExpiryTime != null && !newExpiryTime.equals(prevExpiryTime) && (prevSet = this.expiryMap.get(prevExpiryTime)) != null) {
            prevSet.remove(elem2);
        }
        return newExpiryTime;
    }

    public long getWaitTime() {
        long expirationTime;
        long now = Time.currentElapsedTime();
        return now < (expirationTime = this.nextExpirationTime.get()) ? expirationTime - now : 0L;
    }

    public Set<E> poll() {
        long expirationTime;
        long now = Time.currentElapsedTime();
        if (now < (expirationTime = this.nextExpirationTime.get())) {
            return Collections.emptySet();
        }
        Set<E> set = null;
        long newExpirationTime = expirationTime + (long)this.expirationInterval;
        if (this.nextExpirationTime.compareAndSet(expirationTime, newExpirationTime)) {
            set = this.expiryMap.remove(expirationTime);
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public void dump(PrintWriter pwriter) {
        pwriter.print("Sets (");
        pwriter.print(this.expiryMap.size());
        pwriter.print(")/(");
        pwriter.print(this.elemMap.size());
        pwriter.println("):");
        ArrayList keys = new ArrayList(this.expiryMap.keySet());
        Collections.sort(keys);
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            long time = (Long)i$.next();
            Set<E> set = this.expiryMap.get(time);
            if (set == null) continue;
            pwriter.print(set.size());
            pwriter.print(" expire at ");
            pwriter.print(Time.elapsedTimeToDate(time));
            pwriter.println(":");
            for (E elem2 : set) {
                pwriter.print("\t");
                pwriter.println(elem2.toString());
            }
        }
    }

    public Map<Long, Set<E>> getExpiryMap() {
        return Collections.unmodifiableMap(this.expiryMap);
    }
}

