/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.GetSASLRequest;
import org.apache.zookeeper.proto.SetSASLResponse;
import org.apache.zookeeper.server.auth.KerberosName;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperSaslClient {
    @Deprecated
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";
    @Deprecated
    public static final String ENABLE_CLIENT_SASL_KEY = "zookeeper.sasl.client";
    @Deprecated
    public static final String ENABLE_CLIENT_SASL_DEFAULT = "true";
    private volatile boolean initializedLogin = false;
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperSaslClient.class);
    private Login login = null;
    private SaslClient saslClient;
    private boolean isSASLConfigured = true;
    private final ZKClientConfig clientConfig;
    private byte[] saslToken = new byte[0];
    private SaslState saslState = SaslState.INITIAL;
    private boolean gotLastPacket = false;
    private final String configStatus;

    @Deprecated
    public static boolean isEnabled() {
        return Boolean.valueOf(System.getProperty(ENABLE_CLIENT_SASL_KEY, ENABLE_CLIENT_SASL_DEFAULT));
    }

    public SaslState getSaslState() {
        return this.saslState;
    }

    public String getLoginContext() {
        if (this.login != null) {
            return this.login.getLoginContextName();
        }
        return null;
    }

    public ZooKeeperSaslClient(String serverPrincipal, ZKClientConfig clientConfig) throws LoginException {
        String clientSection = clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client");
        this.clientConfig = clientConfig;
        AppConfigurationEntry[] entries = null;
        RuntimeException runtimeException = null;
        try {
            entries = Configuration.getConfiguration().getAppConfigurationEntry(clientSection);
        }
        catch (SecurityException e) {
            runtimeException = e;
        }
        catch (IllegalArgumentException e) {
            runtimeException = e;
        }
        if (entries != null) {
            this.configStatus = "Will attempt to SASL-authenticate using Login Context section '" + clientSection + "'";
            this.saslClient = this.createSaslClient(serverPrincipal, clientSection);
        } else {
            this.saslState = SaslState.FAILED;
            String explicitClientSection = clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY);
            if (explicitClientSection != null) {
                if (runtimeException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the " + explicitClientSection + " section of the supplied JAAS configuration: '" + clientConfig.getJaasConfKey() + "' because of a " + "RuntimeException: " + runtimeException);
                }
                throw new LoginException("Client cannot SASL-authenticate because the specified JAAS configuration section '" + explicitClientSection + "' could not be found.");
            }
            String msg = "Will not attempt to authenticate using SASL ";
            msg = runtimeException != null ? msg + "(" + runtimeException + ")" : msg + "(unknown error)";
            this.configStatus = msg;
            this.isSASLConfigured = false;
            if (clientConfig.getJaasConfKey() != null) {
                if (runtimeException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the '" + clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' section of the supplied JAAS configuration: '" + clientConfig.getJaasConfKey() + "' because of a " + "RuntimeException: " + runtimeException);
                }
                throw new LoginException("No JAAS configuration section named '" + clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' was found in specified JAAS configuration file: '" + clientConfig.getJaasConfKey() + "'.");
            }
        }
    }

    public String getConfigStatus() {
        return this.configStatus;
    }

    public boolean isComplete() {
        return this.saslState == SaslState.COMPLETE;
    }

    public boolean isFailed() {
        return this.saslState == SaslState.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaslClient createSaslClient(String servicePrincipal, String loginContext) throws LoginException {
        try {
            Subject subject;
            if (!this.initializedLogin) {
                ZooKeeperSaslClient zooKeeperSaslClient = this;
                synchronized (zooKeeperSaslClient) {
                    if (this.login == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("JAAS loginContext is: " + loginContext);
                        }
                        this.login = new Login(loginContext, new ClientCallbackHandler(null), this.clientConfig);
                        this.login.startThreadIfNeeded();
                        this.initializedLogin = true;
                    }
                }
            }
            if ((subject = this.login.getSubject()).getPrincipals().isEmpty()) {
                LOG.info("Client will use DIGEST-MD5 as SASL mechanism.");
                String[] mechs = new String[]{"DIGEST-MD5"};
                String username = (String)subject.getPublicCredentials().toArray()[0];
                String password = (String)subject.getPrivateCredentials().toArray()[0];
                SaslClient saslClient = Sasl.createSaslClient(mechs, username, "zookeeper", "zk-sasl-md5", null, new ClientCallbackHandler(password));
                return saslClient;
            }
            boolean usingNativeJgss = this.clientConfig.getBoolean("sun.security.jgss.native");
            if (usingNativeJgss) {
                try {
                    GSSManager manager = GSSManager.getInstance();
                    Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                    GSSCredential cred = manager.createCredential(null, 0, krb5Mechanism, 1);
                    subject.getPrivateCredentials().add(cred);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Added private credential to subject: " + cred);
                    }
                }
                catch (GSSException ex) {
                    LOG.warn("Cannot add private credential to subject; authentication at the server may fail", ex);
                }
            }
            Object[] principals = subject.getPrincipals().toArray();
            Principal clientPrincipal = (Principal)principals[0];
            KerberosName clientKerberosName = new KerberosName(clientPrincipal.getName());
            String serverRealm = this.clientConfig.getProperty("zookeeper.server.realm", clientKerberosName.getRealm());
            KerberosName serviceKerberosName = new KerberosName(servicePrincipal + "@" + serverRealm);
            final String serviceName = serviceKerberosName.getServiceName();
            final String serviceHostname = serviceKerberosName.getHostName();
            final String clientPrincipalName = clientKerberosName.toString();
            try {
                SaslClient saslClient = Subject.doAs(subject, new PrivilegedExceptionAction<SaslClient>(){

                    @Override
                    public SaslClient run() throws SaslException {
                        LOG.info("Client will use GSSAPI as SASL mechanism.");
                        String[] mechs = new String[]{"GSSAPI"};
                        LOG.debug("creating sasl client: client=" + clientPrincipalName + ";service=" + serviceName + ";serviceHostname=" + serviceHostname);
                        SaslClient saslClient = Sasl.createSaslClient(mechs, clientPrincipalName, serviceName, serviceHostname, null, new ClientCallbackHandler(null));
                        return saslClient;
                    }
                });
                return saslClient;
            }
            catch (Exception e) {
                LOG.error("Exception while trying to create SASL client", e);
                e.printStackTrace();
                return null;
            }
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception while trying to create SASL client: " + e);
            return null;
        }
    }

    public void respondToServer(byte[] serverToken, ClientCnxn cnxn) {
        if (this.saslClient == null) {
            LOG.error("saslClient is unexpectedly null. Cannot respond to server's SASL message; ignoring.");
            return;
        }
        if (!this.saslClient.isComplete()) {
            try {
                this.saslToken = this.createSaslToken(serverToken);
                if (this.saslToken != null) {
                    this.sendSaslPacket(this.saslToken, cnxn);
                }
            }
            catch (SaslException e) {
                LOG.error("SASL authentication failed using login context '" + this.getLoginContext() + "'.");
                this.saslState = SaslState.FAILED;
                this.gotLastPacket = true;
            }
        }
        if (this.saslClient.isComplete()) {
            if (serverToken == null && this.saslClient.getMechanismName().equals("GSSAPI")) {
                this.gotLastPacket = true;
            }
            if (!this.saslClient.getMechanismName().equals("GSSAPI")) {
                this.gotLastPacket = true;
            }
            cnxn.saslCompleted();
        }
    }

    private byte[] createSaslToken() throws SaslException {
        this.saslState = SaslState.INTERMEDIATE;
        return this.createSaslToken(this.saslToken);
    }

    private byte[] createSaslToken(final byte[] saslToken) throws SaslException {
        if (saslToken == null) {
            this.saslState = SaslState.FAILED;
            throw new SaslException("Error in authenticating with a Zookeeper Quorum member: the quorum member's saslToken is null.");
        }
        Subject subject = this.login.getSubject();
        if (subject != null) {
            Login login = this.login;
            synchronized (login) {
                try {
                    byte[] retval = Subject.doAs(subject, new PrivilegedExceptionAction<byte[]>(){

                        @Override
                        public byte[] run() throws SaslException {
                            LOG.debug("saslClient.evaluateChallenge(len=" + saslToken.length + ")");
                            return ZooKeeperSaslClient.this.saslClient.evaluateChallenge(saslToken);
                        }
                    });
                    return retval;
                }
                catch (PrivilegedActionException e) {
                    String error = "An error: (" + e + ") occurred when evaluating Zookeeper Quorum Member's " + " received SASL token.";
                    String UNKNOWN_SERVER_ERROR_TEXT = "(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)";
                    if (e.toString().indexOf("(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)") > -1) {
                        error = error + " This may be caused by Java's being unable to resolve the Zookeeper Quorum Member's hostname correctly. You may want to try to adding '-Dsun.net.spi.nameservice.provider.1=dns,sun' to your client's JVMFLAGS environment.";
                    }
                    error = error + " Zookeeper Client will go to AUTH_FAILED state.";
                    LOG.error(error);
                    this.saslState = SaslState.FAILED;
                    throw new SaslException(error);
                }
            }
        }
        throw new SaslException("Cannot make SASL token without subject defined. For diagnosis, please look for WARNs and ERRORs in your log related to the Login class.");
    }

    private void sendSaslPacket(byte[] saslToken, ClientCnxn cnxn) throws SaslException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ClientCnxn:sendSaslPacket:length=" + saslToken.length);
        }
        GetSASLRequest request = new GetSASLRequest();
        request.setToken(saslToken);
        SetSASLResponse response = new SetSASLResponse();
        ServerSaslResponseCallback cb = new ServerSaslResponseCallback();
        try {
            cnxn.sendPacket(request, response, cb, 102);
        }
        catch (IOException e) {
            throw new SaslException("Failed to send SASL packet to server.", e);
        }
    }

    private void sendSaslPacket(ClientCnxn cnxn) throws SaslException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ClientCnxn:sendSaslPacket:length=" + this.saslToken.length);
        }
        GetSASLRequest request = new GetSASLRequest();
        request.setToken(this.createSaslToken());
        SetSASLResponse response = new SetSASLResponse();
        ServerSaslResponseCallback cb = new ServerSaslResponseCallback();
        try {
            cnxn.sendPacket(request, response, cb, 102);
        }
        catch (IOException e) {
            throw new SaslException("Failed to send SASL packet to server due to IOException:", e);
        }
    }

    public Watcher.Event.KeeperState getKeeperState() {
        if (this.saslClient != null) {
            if (this.saslState == SaslState.FAILED) {
                return Watcher.Event.KeeperState.AuthFailed;
            }
            if (this.saslClient.isComplete() && this.saslState == SaslState.INTERMEDIATE) {
                this.saslState = SaslState.COMPLETE;
                return Watcher.Event.KeeperState.SaslAuthenticated;
            }
        }
        return null;
    }

    public void initialize(ClientCnxn cnxn) throws SaslException {
        if (this.saslClient == null) {
            this.saslState = SaslState.FAILED;
            throw new SaslException("saslClient failed to initialize properly: it's null.");
        }
        if (this.saslState == SaslState.INITIAL) {
            if (this.saslClient.hasInitialResponse()) {
                this.sendSaslPacket(cnxn);
            } else {
                byte[] emptyToken = new byte[]{};
                this.sendSaslPacket(emptyToken, cnxn);
            }
            this.saslState = SaslState.INTERMEDIATE;
        }
    }

    public boolean clientTunneledAuthenticationInProgress() {
        if (!this.isSASLConfigured) {
            return false;
        }
        try {
            if (this.clientConfig.getJaasConfKey() != null || Configuration.getConfiguration() != null && Configuration.getConfiguration().getAppConfigurationEntry(this.clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client")) != null) {
                if (!this.isComplete() && !this.isFailed()) {
                    return true;
                }
                if ((this.isComplete() || this.isFailed()) && !this.gotLastPacket) {
                    return true;
                }
            }
            return false;
        }
        catch (SecurityException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not retrieve login configuration: " + e);
            }
            return false;
        }
    }

    public void shutdown() {
        if (null != this.login) {
            this.login.shutdown();
        }
    }

    public static class ClientCallbackHandler
    implements CallbackHandler {
        private String password = null;

        public ClientCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    if (this.password != null) {
                        pc.setPassword(this.password.toCharArray());
                        continue;
                    }
                    LOG.warn("Could not login: the client is being asked for a password, but the Zookeeper client code does not currently support obtaining a password from the user. Make sure that the client is configured to use a ticket cache (using the JAAS configuration setting 'useTicketCache=true)' and restart the client. If you still get this message after that, the TGT in the ticket cache has expired and must be manually refreshed. To do so, first determine if you are using a password or a keytab. If the former, run kinit in a Unix shell in the environment of the user who is running this Zookeeper client using the command 'kinit <princ>' (where <princ> is the name of the client's Kerberos principal). If the latter, do 'kinit -k -t <keytab> <princ>' (where <princ> is the name of the Kerberos principal, and <keytab> is the location of the keytab file). After manually refreshing your cache, restart this client. If you continue to see this message after manually refreshing your cache, ensure that your KDC host's clock is in sync with this host's clock.");
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    String authzid;
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (!ac.isAuthorized()) continue;
                    ac.setAuthorizedID(authzid);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
            }
        }
    }

    public static class ServerSaslResponseCallback
    implements AsyncCallback.DataCallback {
        @Override
        public void processResult(int rc, String path, Object ctx, byte[] data2, Stat stat) {
            ZooKeeperSaslClient client = ((ClientCnxn)ctx).zooKeeperSaslClient;
            if (client == null) {
                LOG.warn("sasl client was unexpectedly null: cannot respond to Zookeeper server.");
                return;
            }
            byte[] usedata = data2;
            if (data2 != null) {
                LOG.debug("ServerSaslResponseCallback(): saslToken server response: (length=" + usedata.length + ")");
            } else {
                usedata = new byte[]{};
                LOG.debug("ServerSaslResponseCallback(): using empty data[] as server response (length=" + usedata.length + ")");
            }
            client.respondToServer(usedata, (ClientCnxn)ctx);
        }
    }

    public static enum SaslState {
        INITIAL,
        INTERMEDIATE,
        COMPLETE,
        FAILED;

    }
}

