/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.map.AbstractInputCheckedMapDecorator;

public class PredicatedMap<K, V>
extends AbstractInputCheckedMapDecorator<K, V>
implements Serializable {
    private static final long serialVersionUID = 7412622456128415156L;
    protected final Predicate<? super K> keyPredicate;
    protected final Predicate<? super V> valuePredicate;

    public static <K, V> PredicatedMap<K, V> predicatedMap(Map<K, V> map2, Predicate<? super K> keyPredicate, Predicate<? super V> valuePredicate) {
        return new PredicatedMap<K, V>(map2, keyPredicate, valuePredicate);
    }

    protected PredicatedMap(Map<K, V> map2, Predicate<? super K> keyPredicate, Predicate<? super V> valuePredicate) {
        super(map2);
        this.keyPredicate = keyPredicate;
        this.valuePredicate = valuePredicate;
        for (Map.Entry<K, V> entry2 : map2.entrySet()) {
            this.validate(entry2.getKey(), entry2.getValue());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    protected void validate(K key, V value2) {
        if (this.keyPredicate != null && !this.keyPredicate.evaluate(key)) {
            throw new IllegalArgumentException("Cannot add key - Predicate rejected it");
        }
        if (this.valuePredicate != null && !this.valuePredicate.evaluate(value2)) {
            throw new IllegalArgumentException("Cannot add value - Predicate rejected it");
        }
    }

    @Override
    protected V checkSetValue(V value2) {
        if (!this.valuePredicate.evaluate(value2)) {
            throw new IllegalArgumentException("Cannot set value - Predicate rejected it");
        }
        return value2;
    }

    @Override
    protected boolean isSetValueChecking() {
        return this.valuePredicate != null;
    }

    @Override
    public V put(K key, V value2) {
        this.validate(key, value2);
        return this.map.put(key, value2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> mapToCopy) {
        for (Map.Entry<K, V> entry2 : mapToCopy.entrySet()) {
            this.validate(entry2.getKey(), entry2.getValue());
        }
        super.putAll(mapToCopy);
    }
}

