/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

final class IntStringHashMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 15;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient Entry[] entries;
    private transient int size;
    private int threshold;
    private float loadFactor;
    private int bitmask;

    public IntStringHashMap(int n, float f) {
        int n2;
        this.loadFactor = f;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.threshold = (int)((float)n2 * f);
        this.entries = new Entry[n2];
        this.bitmask = n2 - 1;
    }

    public IntStringHashMap(int n) {
        this(n, 0.75f);
    }

    public IntStringHashMap() {
        this(15, 0.75f);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private int getIndex(int n) {
        return n & this.bitmask;
    }

    public String get(int n) {
        Entry entry2 = this.entries[this.getIndex(n)];
        while (entry2 != null) {
            if (n == entry2.key) {
                return entry2.value;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    private Entry getEntry(int n) {
        Entry entry2 = this.entries[this.getIndex(n)];
        while (entry2 != null && n != entry2.key) {
            entry2 = entry2.next;
        }
        return entry2;
    }

    public boolean containsKey(int n) {
        return this.getEntry(n) != null;
    }

    public String put(int n, String string2) {
        int n2 = this.getIndex(n);
        Entry entry2 = this.entries[n2];
        while (entry2 != null) {
            if (n == entry2.key) {
                String string3 = entry2.value;
                entry2.value = string2;
                return string3;
            }
            entry2 = entry2.next;
        }
        this.entries[n2] = new Entry(n, string2, this.entries[n2]);
        if (this.size++ >= this.threshold) {
            this.increaseCapacity();
        }
        return null;
    }

    private void increaseCapacity() {
        int n = this.entries.length;
        Entry[] entryArray = this.entries;
        this.entries = new Entry[n << 1];
        this.bitmask = this.entries.length - 1;
        for (Entry entry2 : entryArray) {
            while (entry2 != null) {
                Entry entry3 = entry2.next;
                int n2 = this.getIndex(entry2.key);
                entry2.next = this.entries[n2];
                this.entries[n2] = entry2;
                entry2 = entry3;
            }
        }
        this.threshold = (int)((float)this.entries.length * this.loadFactor);
    }

    public String remove(int n) {
        int n2 = this.getIndex(n);
        Entry entry2 = null;
        Entry entry3 = this.entries[n2];
        while (entry3 != null) {
            if (n == entry3.key) {
                if (entry2 == null) {
                    this.entries[n2] = entry3.next;
                } else {
                    entry2.next = entry3.next;
                }
                --this.size;
                return entry3.value;
            }
            entry2 = entry3;
            entry3 = entry2.next;
        }
        return null;
    }

    public void clear() {
        for (int i = this.bitmask; i >= 0; --i) {
            this.entries[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(String string2) {
        if (string2 == null) {
            for (int i = this.bitmask; i >= 0; --i) {
                Entry entry2 = this.entries[i];
                while (entry2 != null) {
                    if (entry2.value == null) {
                        return true;
                    }
                    entry2 = entry2.next;
                }
            }
        } else {
            for (int i = this.bitmask; i >= 0; --i) {
                Entry entry3 = this.entries[i];
                while (entry3 != null) {
                    if (string2.equals(entry3.value)) {
                        return true;
                    }
                    entry3 = entry3.next;
                }
            }
        }
        return false;
    }

    private static final class Entry {
        final int key;
        String value;
        Entry next;

        public Entry(int n, String string2, Entry entry2) {
            this.key = n;
            this.value = string2;
            this.next = entry2;
        }
    }
}

