/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormControlType;

public final class FormField {
    private final String name;
    private int userValueCount = 0;
    private boolean allowsMultipleValues = false;
    private LinkedHashSet<String> predefinedValues = null;
    private final LinkedHashSet<FormControl> formControls = new LinkedHashSet();
    private transient FormControl firstFormControl = null;
    int columnIndex;

    FormField(String string2) {
        this.name = string2;
    }

    public String getName() {
        return this.name;
    }

    public Collection<FormControl> getFormControls() {
        return this.formControls;
    }

    public FormControl getFormControl(String string2) {
        if (string2 == null) {
            for (FormControl formControl : this.formControls) {
                if (!formControl.getFormControlType().hasPredefinedValue()) {
                    return formControl;
                }
                if (formControl.getFormControlType().getElementName() == "select" || formControl.getPredefinedValue() != null) continue;
                return formControl;
            }
        } else {
            for (FormControl formControl : this.formControls) {
                if (!(formControl.getFormControlType().getElementName() == "select" ? formControl.getPredefinedValues().contains(string2) : string2.equals(formControl.getPredefinedValue()))) continue;
                return formControl;
            }
        }
        return null;
    }

    public FormControl getFormControl() {
        return (FormControl)this.formControls.iterator().next();
    }

    public boolean allowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public int getUserValueCount() {
        return this.userValueCount;
    }

    public Collection<String> getPredefinedValues() {
        if (this.predefinedValues == null) {
            return Collections.emptySet();
        }
        return this.predefinedValues;
    }

    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FormControl formControl : this.formControls) {
            formControl.addValuesTo(arrayList);
        }
        return arrayList;
    }

    public void clearValues() {
        for (FormControl formControl : this.formControls) {
            formControl.clearValues();
        }
    }

    public void setValues(Collection<String> collection) {
        this.clearValues();
        this.addValues(collection);
    }

    public boolean setValue(String string2) {
        this.clearValues();
        return string2 != null ? this.addValue(string2) : true;
    }

    public boolean addValue(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("value argument must not be null");
        }
        if (this.formControls.size() == 1) {
            return this.getFirstFormControl().addValue(string2);
        }
        LinkedList<FormControl> linkedList = null;
        for (FormControl formControl : this.formControls) {
            if (!formControl.getFormControlType().hasPredefinedValue()) {
                if (linkedList == null) {
                    linkedList = new LinkedList<FormControl>();
                }
                linkedList.add(formControl);
                continue;
            }
            if (!formControl.addValue(string2)) continue;
            return true;
        }
        if (linkedList == null) {
            return false;
        }
        for (FormControl formControl : linkedList) {
            if (!formControl.addValue(string2)) continue;
            return true;
        }
        return false;
    }

    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Field: ").append(this.name).append(", UserValueCount=").append(this.userValueCount).append(", AllowsMultipleValues=").append(this.allowsMultipleValues);
        if (this.predefinedValues != null) {
            for (String charSequence : this.predefinedValues) {
                stringBuilder.append(Config.NewLine).append("PredefinedValue: ").append(charSequence);
            }
        }
        for (FormControl formControl : this.formControls) {
            stringBuilder.append(Config.NewLine).append("FormControl: ").append(formControl.getDebugInfo());
        }
        stringBuilder.append(Config.NewLine).append(Config.NewLine);
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getDebugInfo();
    }

    void addValues(Collection<String> collection) {
        if (collection != null) {
            for (String string2 : collection) {
                this.addValue(string2);
            }
        }
    }

    void addValues(String[] stringArray) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                this.addValue(string2);
            }
        }
    }

    void addFormControl(FormControl formControl, String string2) {
        if (string2 == null) {
            ++this.userValueCount;
        } else {
            if (this.predefinedValues == null) {
                this.predefinedValues = new LinkedHashSet();
            }
            this.predefinedValues.add(string2);
        }
        this.formControls.add(formControl);
        this.allowsMultipleValues = this.calculateAllowsMultipleValues(formControl);
    }

    private boolean calculateAllowsMultipleValues(FormControl formControl) {
        if (this.allowsMultipleValues || this.userValueCount > 1) {
            return true;
        }
        if (this.userValueCount == 1) {
            return this.predefinedValues != null;
        }
        if (this.predefinedValues.size() == 1) {
            return false;
        }
        FormControlType formControlType = formControl.getFormControlType();
        if (this.formControls.size() == 1) {
            return formControlType == FormControlType.SELECT_MULTIPLE;
        }
        FormControlType formControlType2 = this.getFirstFormControl().getFormControlType();
        if (formControlType == FormControlType.RADIO && formControlType2 == FormControlType.RADIO) {
            return false;
        }
        return !formControlType.isSubmit() || !formControlType2.isSubmit();
    }

    FormControl getFirstFormControl() {
        if (this.firstFormControl == null) {
            this.firstFormControl = (FormControl)this.formControls.iterator().next();
        }
        return this.firstFormControl;
    }

    void merge(FormField formField) {
        if (formField.userValueCount > this.userValueCount) {
            this.userValueCount = formField.userValueCount;
        }
        boolean bl = this.allowsMultipleValues = this.allowsMultipleValues || formField.allowsMultipleValues;
        if (this.predefinedValues == null) {
            this.predefinedValues = formField.predefinedValues;
        } else if (formField.predefinedValues != null) {
            for (String charSequence : this.predefinedValues) {
                this.predefinedValues.add(charSequence);
            }
        }
        for (FormControl formControl : formField.getFormControls()) {
            this.formControls.add(formControl);
        }
    }
}

