/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import net.htmlparser.jericho.LoggerQueue;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StreamEncodingDetector;

final class EncodingDetector {
    private final InputStream inputStream;
    private String encoding = null;
    private String encodingSpecificationInfo = null;
    private final String preliminaryEncoding;
    private final Integer preliminaryEncodingCodeUnitSize;
    private final String preliminaryEncodingSpecificationInfo;
    private final String alternativePreliminaryEncoding;
    private LoggerQueue logger = new LoggerQueue();
    private static final int PREVIEW_BYTE_COUNT = 2048;
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";

    public EncodingDetector(URLConnection uRLConnection) throws IOException {
        this(new StreamEncodingDetector(uRLConnection));
    }

    public EncodingDetector(InputStream inputStream) throws IOException {
        this(new StreamEncodingDetector(inputStream));
    }

    public EncodingDetector(InputStream inputStream, String string2) throws IOException {
        this(inputStream, string2, "preliminary encoding set explicitly", null);
        this.logger = new LoggerQueue();
        if (!EncodingDetector.isEncodingSupported(string2)) {
            throw new UnsupportedEncodingException(string2 + " specified as preliminaryEncoding constructor argument");
        }
        this.detectDocumentSpecifiedEncoding();
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector) throws IOException {
        this(streamEncodingDetector, ISO_8859_1);
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector, String string2) throws IOException {
        this(streamEncodingDetector.getInputStream(), streamEncodingDetector.getEncoding(), streamEncodingDetector.getEncodingSpecificationInfo(), string2);
        this.logger = streamEncodingDetector.getLoggerQueue();
        if (streamEncodingDetector.isDifinitive() || !streamEncodingDetector.isDocumentSpecifiedEncodingPossible()) {
            this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo);
        } else {
            this.detectDocumentSpecifiedEncoding();
        }
    }

    private EncodingDetector(InputStream inputStream, String string2, String string3, String string4) throws IOException {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.preliminaryEncoding = string2;
        this.preliminaryEncodingCodeUnitSize = StreamEncodingDetector.codeUnitSizeMap.get(string2 == null ? null : string2.toUpperCase());
        this.preliminaryEncodingSpecificationInfo = string3;
        this.alternativePreliminaryEncoding = string4;
        if (string4 != null && !EncodingDetector.isEncodingSupported(string4)) {
            throw new UnsupportedEncodingException(string4 + " specified as alternativePreliminaryEncoding constructor argument");
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        return this.encodingSpecificationInfo;
    }

    public String getPreliminaryEncoding() {
        return this.preliminaryEncoding;
    }

    public String getPreliminaryEncodingSpecificationInfo() {
        return this.preliminaryEncodingSpecificationInfo;
    }

    public LoggerQueue getLoggerQueue() {
        return this.logger;
    }

    public Reader openReader() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(this.inputStream, ISO_8859_1);
        }
        if (!EncodingDetector.isEncodingSupported(this.encoding)) {
            throw new UnsupportedEncodingException(this.encoding + ": " + this.encodingSpecificationInfo);
        }
        return new InputStreamReader(this.inputStream, this.encoding);
    }

    private boolean setEncoding(String string2, String string3) {
        this.encoding = string2;
        this.encodingSpecificationInfo = string3;
        return true;
    }

    private boolean detectDocumentSpecifiedEncoding() throws IOException {
        String string2;
        String string3;
        block12: {
            String string4;
            this.inputStream.mark(2048);
            if (EncodingDetector.isEncodingSupported(this.preliminaryEncoding)) {
                string3 = this.preliminaryEncoding;
            } else {
                if (this.alternativePreliminaryEncoding == null) {
                    throw new UnsupportedEncodingException(this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
                }
                string3 = this.alternativePreliminaryEncoding;
            }
            Source source = this.getPreviewSource(string3);
            this.inputStream.reset();
            source.setLogger(null);
            if (this.preliminaryEncoding != string3 && this.logger.isWarnEnabled()) {
                this.logger.warn("Alternative encoding " + string3 + " substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
            }
            if ((string4 = source.getDocumentSpecifiedEncoding(this)) == null) {
                if (source.isXML()) {
                    return this.setEncoding(UTF_8, "mandatory XML encoding when no BOM or encoding declaration is present");
                }
                string2 = "no encoding specified in document";
            } else {
                try {
                    if (EncodingDetector.isEncodingSupported(string4)) {
                        return this.setEncoding(string4, source.getEncodingSpecificationInfo());
                    }
                    string2 = "encoding " + string4 + " specified in document is not supported";
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Unsupported encoding " + string4 + " specified in document, using preliminary encoding " + string3 + " instead");
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    string2 = "illegal encoding " + string4 + " specified in document";
                    if (!this.logger.isWarnEnabled()) break block12;
                    this.logger.warn("Illegal encoding " + string4 + " specified in document, using preliminary encoding " + string3 + " instead");
                }
            }
        }
        if (this.preliminaryEncoding != string3) {
            return this.setEncoding(string3, "alternative encoding substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo + ", " + string2);
        }
        return this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo + ", " + string2);
    }

    boolean isIncompatibleWithPreliminaryEncoding(String string2) {
        if (this.preliminaryEncodingCodeUnitSize == null || string2 == null) {
            return false;
        }
        Integer n = StreamEncodingDetector.codeUnitSizeMap.get(string2.toUpperCase());
        if (n == null) {
            return false;
        }
        return !this.preliminaryEncodingCodeUnitSize.equals(n);
    }

    private Source getPreviewSource(String string2) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[2048];
        for (n2 = 0; n2 < 2048 && (n = this.inputStream.read()) != -1; ++n2) {
            byArray[n2] = (byte)n;
        }
        return new Source(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n2), string2), null);
    }

    static boolean isEncodingSupported(String string2) {
        try {
            return Charset.isSupported(string2);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }
}

