/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.model;

public enum ConfidenceLevel {
    CERTAIN(1.0f, null),
    VERY_HIGH(0.98f, CERTAIN),
    HIGH(0.95f, VERY_HIGH),
    GOOD(0.9f, HIGH),
    FAIR(0.8f, GOOD),
    POOR(0.5f, FAIR),
    GUESS(0.0f, POOR);

    private static final ConfidenceLevel LOWEST_LEVEL;
    private final float min;
    private final ConfidenceLevel higherLevel;

    private ConfidenceLevel(float min2, ConfidenceLevel higherLevel) {
        this.min = min2;
        this.higherLevel = higherLevel;
    }

    public static ConfidenceLevel getForConfidence(float confidence) {
        if (confidence < 0.0f || confidence > 1.0f) {
            throw new IllegalArgumentException("Confidence must be between 0 and 1 (not " + confidence + ").");
        }
        ConfidenceLevel acceptableLevel = LOWEST_LEVEL;
        while (acceptableLevel.higherLevel != null && !(acceptableLevel.higherLevel.min > confidence)) {
            acceptableLevel = acceptableLevel.higherLevel;
        }
        return acceptableLevel;
    }

    public Float getMax() {
        return this.higherLevel == null ? null : Float.valueOf(this.higherLevel.min);
    }

    public float getMin() {
        return this.min;
    }

    static {
        LOWEST_LEVEL = GUESS;
    }
}

