/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.DateRule;
import com.ibm.icu.util.Range;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RangeDateRule
implements DateRule {
    List<Range> ranges = new ArrayList<Range>(2);

    public void add(DateRule rule) {
        this.add(new Date(Long.MIN_VALUE), rule);
    }

    public void add(Date start, DateRule rule) {
        this.ranges.add(new Range(start, rule));
    }

    public Date firstAfter(Date start) {
        int index2 = this.startIndex(start);
        if (index2 == this.ranges.size()) {
            index2 = 0;
        }
        Date result2 = null;
        Range r = this.rangeAt(index2);
        Range e = this.rangeAt(index2 + 1);
        if (r != null && r.rule != null) {
            result2 = e != null ? r.rule.firstBetween(start, e.start) : r.rule.firstAfter(start);
        }
        return result2;
    }

    public Date firstBetween(Date start, Date end) {
        if (end == null) {
            return this.firstAfter(start);
        }
        int index2 = this.startIndex(start);
        Date result2 = null;
        Range next2 = this.rangeAt(index2);
        while (result2 == null && next2 != null && !next2.start.after(end)) {
            Range r = next2;
            next2 = this.rangeAt(index2 + 1);
            if (r.rule == null) continue;
            Date e = next2 != null && !next2.start.after(end) ? next2.start : end;
            result2 = r.rule.firstBetween(start, e);
        }
        return result2;
    }

    public boolean isOn(Date date) {
        Range r = this.rangeAt(this.startIndex(date));
        return r != null && r.rule != null && r.rule.isOn(date);
    }

    public boolean isBetween(Date start, Date end) {
        return this.firstBetween(start, end) == null;
    }

    private int startIndex(Date start) {
        int lastIndex = this.ranges.size();
        int i = 0;
        while (i < this.ranges.size()) {
            Range r = this.ranges.get(i);
            if (start.before(r.start)) break;
            lastIndex = i++;
        }
        return lastIndex;
    }

    private Range rangeAt(int index2) {
        return index2 < this.ranges.size() ? this.ranges.get(index2) : null;
    }
}

