/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUConfig;
import com.ibm.icu.impl.PatternProps;
import com.ibm.icu.util.Freezable;
import java.util.ArrayList;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessagePattern
implements Cloneable,
Freezable<MessagePattern> {
    public static final int ARG_NAME_NOT_NUMBER = -1;
    public static final int ARG_NAME_NOT_VALID = -2;
    public static final double NO_NUMERIC_VALUE = -1.23456789E8;
    private static final int MAX_PREFIX_LENGTH = 24;
    private ApostropheMode aposMode;
    private String msg;
    private ArrayList<Part> parts = new ArrayList();
    private ArrayList<Double> numericValues;
    private boolean hasArgNames;
    private boolean hasArgNumbers;
    private boolean needsAutoQuoting;
    private boolean frozen;
    private static final ApostropheMode defaultAposMode = ApostropheMode.valueOf(ICUConfig.get("com.ibm.icu.text.MessagePattern.ApostropheMode", "DOUBLE_OPTIONAL"));
    private static final ArgType[] argTypes = ArgType.values();

    public MessagePattern() {
        this.aposMode = defaultAposMode;
    }

    public MessagePattern(ApostropheMode mode) {
        this.aposMode = mode;
    }

    public MessagePattern(String pattern) {
        this.aposMode = defaultAposMode;
        this.parse(pattern);
    }

    public MessagePattern parse(String pattern) {
        this.preParse(pattern);
        this.parseMessage(0, 0, 0, ArgType.NONE);
        this.postParse();
        return this;
    }

    public MessagePattern parseChoiceStyle(String pattern) {
        this.preParse(pattern);
        this.parseChoiceStyle(0, 0);
        this.postParse();
        return this;
    }

    public MessagePattern parsePluralStyle(String pattern) {
        this.preParse(pattern);
        this.parsePluralOrSelectStyle(ArgType.PLURAL, 0, 0);
        this.postParse();
        return this;
    }

    public MessagePattern parseSelectStyle(String pattern) {
        this.preParse(pattern);
        this.parsePluralOrSelectStyle(ArgType.SELECT, 0, 0);
        this.postParse();
        return this;
    }

    public void clear() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to clear() a frozen MessagePattern instance.");
        }
        this.msg = null;
        this.hasArgNumbers = false;
        this.hasArgNames = false;
        this.needsAutoQuoting = false;
        this.parts.clear();
        if (this.numericValues != null) {
            this.numericValues.clear();
        }
    }

    public void clearPatternAndSetApostropheMode(ApostropheMode mode) {
        this.clear();
        this.aposMode = mode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MessagePattern o = (MessagePattern)other;
        return this.aposMode.equals((Object)o.aposMode) && (this.msg == null ? o.msg == null : this.msg.equals(o.msg)) && this.parts.equals(o.parts);
    }

    public int hashCode() {
        return (this.aposMode.hashCode() * 37 + (this.msg != null ? this.msg.hashCode() : 0)) * 37 + this.parts.hashCode();
    }

    public ApostropheMode getApostropheMode() {
        return this.aposMode;
    }

    boolean jdkAposMode() {
        return this.aposMode == ApostropheMode.DOUBLE_REQUIRED;
    }

    public String getPatternString() {
        return this.msg;
    }

    public boolean hasNamedArguments() {
        return this.hasArgNames;
    }

    public boolean hasNumberedArguments() {
        return this.hasArgNumbers;
    }

    public String toString() {
        return this.msg;
    }

    public static int validateArgumentName(String name) {
        if (!PatternProps.isIdentifier(name)) {
            return -2;
        }
        return MessagePattern.parseArgNumber(name, 0, name.length());
    }

    public String autoQuoteApostropheDeep() {
        int count2;
        if (!this.needsAutoQuoting) {
            return this.msg;
        }
        StringBuilder modified = null;
        int i = count2 = this.countParts();
        while (i > 0) {
            Part part;
            if ((part = this.getPart(--i)).getType() != Part.Type.INSERT_CHAR) continue;
            if (modified == null) {
                modified = new StringBuilder(this.msg.length() + 10).append(this.msg);
            }
            modified.insert(part.index, (char)part.value);
        }
        if (modified == null) {
            return this.msg;
        }
        return modified.toString();
    }

    public int countParts() {
        return this.parts.size();
    }

    public Part getPart(int i) {
        return this.parts.get(i);
    }

    public Part.Type getPartType(int i) {
        return this.parts.get(i).type;
    }

    public int getPatternIndex(int partIndex) {
        return this.parts.get(partIndex).index;
    }

    public String getSubstring(Part part) {
        int index2 = part.index;
        return this.msg.substring(index2, index2 + part.length);
    }

    public boolean partSubstringMatches(Part part, String s2) {
        return this.msg.regionMatches(part.index, s2, 0, part.length);
    }

    public double getNumericValue(Part part) {
        Part.Type type = part.type;
        if (type == Part.Type.ARG_INT) {
            return part.value;
        }
        if (type == Part.Type.ARG_DOUBLE) {
            return this.numericValues.get(part.value);
        }
        return -1.23456789E8;
    }

    public double getPluralOffset(int pluralStart) {
        Part part = this.parts.get(pluralStart);
        if (part.type.hasNumericValue()) {
            return this.getNumericValue(part);
        }
        return 0.0;
    }

    public int getLimitPartIndex(int start) {
        int limit = this.parts.get(start).limitPartIndex;
        if (limit < start) {
            return start;
        }
        return limit;
    }

    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    @Override
    public MessagePattern cloneAsThawed() {
        MessagePattern newMsg;
        try {
            newMsg = (MessagePattern)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        newMsg.parts = (ArrayList)this.parts.clone();
        if (this.numericValues != null) {
            newMsg.numericValues = (ArrayList)this.numericValues.clone();
        }
        newMsg.frozen = false;
        return newMsg;
    }

    @Override
    public MessagePattern freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    private void preParse(String pattern) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to parse(" + MessagePattern.prefix(pattern) + ") on frozen MessagePattern instance.");
        }
        this.msg = pattern;
        this.hasArgNumbers = false;
        this.hasArgNames = false;
        this.needsAutoQuoting = false;
        this.parts.clear();
        if (this.numericValues != null) {
            this.numericValues.clear();
        }
    }

    private void postParse() {
    }

    private int parseMessage(int index2, int msgStartLength, int nestingLevel, ArgType parentType) {
        if (nestingLevel > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        int msgStart = this.parts.size();
        this.addPart(Part.Type.MSG_START, index2, msgStartLength, nestingLevel);
        index2 += msgStartLength;
        block0: while (index2 < this.msg.length()) {
            char c;
            if ((c = this.msg.charAt(index2++)) == '\'') {
                if (index2 == this.msg.length()) {
                    this.addPart(Part.Type.INSERT_CHAR, index2, 0, 39);
                    this.needsAutoQuoting = true;
                    continue;
                }
                c = this.msg.charAt(index2);
                if (c == '\'') {
                    this.addPart(Part.Type.SKIP_SYNTAX, index2++, 1, 0);
                    continue;
                }
                if (this.aposMode == ApostropheMode.DOUBLE_REQUIRED || c == '{' || c == '}' || parentType == ArgType.CHOICE && c == '|' || parentType.hasPluralStyle() && c == '#') {
                    this.addPart(Part.Type.SKIP_SYNTAX, index2 - 1, 1, 0);
                    while ((index2 = this.msg.indexOf(39, index2 + 1)) >= 0) {
                        if (index2 + 1 < this.msg.length() && this.msg.charAt(index2 + 1) == '\'') {
                            this.addPart(Part.Type.SKIP_SYNTAX, ++index2, 1, 0);
                            continue;
                        }
                        this.addPart(Part.Type.SKIP_SYNTAX, index2++, 1, 0);
                        continue block0;
                    }
                    index2 = this.msg.length();
                    this.addPart(Part.Type.INSERT_CHAR, index2, 0, 39);
                    this.needsAutoQuoting = true;
                    continue;
                }
                this.addPart(Part.Type.INSERT_CHAR, index2, 0, 39);
                this.needsAutoQuoting = true;
                continue;
            }
            if (parentType.hasPluralStyle() && c == '#') {
                this.addPart(Part.Type.REPLACE_NUMBER, index2 - 1, 1, 0);
                continue;
            }
            if (c == '{') {
                index2 = this.parseArg(index2 - 1, 1, nestingLevel);
                continue;
            }
            if ((nestingLevel <= 0 || c != '}') && (parentType != ArgType.CHOICE || c != '|')) continue;
            int limitLength = parentType == ArgType.CHOICE && c == '}' ? 0 : 1;
            this.addLimitPart(msgStart, Part.Type.MSG_LIMIT, index2 - 1, limitLength, nestingLevel);
            if (parentType == ArgType.CHOICE) {
                return index2 - 1;
            }
            return index2;
        }
        if (nestingLevel > 0 && !this.inTopLevelChoiceMessage(nestingLevel, parentType)) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        this.addLimitPart(msgStart, Part.Type.MSG_LIMIT, index2, 0, nestingLevel);
        return index2;
    }

    private int parseArg(int index2, int argStartLength, int nestingLevel) {
        int length;
        int argStart = this.parts.size();
        ArgType argType = ArgType.NONE;
        this.addPart(Part.Type.ARG_START, index2, argStartLength, argType.ordinal());
        int nameIndex = index2 = this.skipWhiteSpace(index2 + argStartLength);
        if (index2 == this.msg.length()) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        int number2 = this.parseArgNumber(nameIndex, index2 = this.skipIdentifier(index2));
        if (number2 >= 0) {
            length = index2 - nameIndex;
            if (length > 65535 || number2 > Short.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Argument number too large: " + this.prefix(nameIndex));
            }
            this.hasArgNumbers = true;
            this.addPart(Part.Type.ARG_NUMBER, nameIndex, length, number2);
        } else if (number2 == -1) {
            length = index2 - nameIndex;
            if (length > 65535) {
                throw new IndexOutOfBoundsException("Argument name too long: " + this.prefix(nameIndex));
            }
            this.hasArgNames = true;
            this.addPart(Part.Type.ARG_NAME, nameIndex, length, 0);
        } else {
            throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(nameIndex));
        }
        index2 = this.skipWhiteSpace(index2);
        if (index2 == this.msg.length()) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        char c = this.msg.charAt(index2);
        if (c != '}') {
            if (c != ',') {
                throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(nameIndex));
            }
            int typeIndex = index2 = this.skipWhiteSpace(index2 + 1);
            while (index2 < this.msg.length() && MessagePattern.isArgTypeChar(this.msg.charAt(index2))) {
                ++index2;
            }
            int length2 = index2 - typeIndex;
            if ((index2 = this.skipWhiteSpace(index2)) == this.msg.length()) {
                throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
            }
            if (length2 == 0 || (c = this.msg.charAt(index2)) != ',' && c != '}') {
                throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(nameIndex));
            }
            if (length2 > 65535) {
                throw new IndexOutOfBoundsException("Argument type name too long: " + this.prefix(nameIndex));
            }
            argType = ArgType.SIMPLE;
            if (length2 == 6) {
                if (this.isChoice(typeIndex)) {
                    argType = ArgType.CHOICE;
                } else if (this.isPlural(typeIndex)) {
                    argType = ArgType.PLURAL;
                } else if (this.isSelect(typeIndex)) {
                    argType = ArgType.SELECT;
                }
            } else if (length2 == 13 && this.isSelect(typeIndex) && this.isOrdinal(typeIndex + 6)) {
                argType = ArgType.SELECTORDINAL;
            }
            this.parts.get(argStart).value = (short)argType.ordinal();
            if (argType == ArgType.SIMPLE) {
                this.addPart(Part.Type.ARG_TYPE, typeIndex, length2, 0);
            }
            if (c == '}') {
                if (argType != ArgType.SIMPLE) {
                    throw new IllegalArgumentException("No style field for complex argument: " + this.prefix(nameIndex));
                }
            } else {
                ++index2;
                index2 = argType == ArgType.SIMPLE ? this.parseSimpleStyle(index2) : (argType == ArgType.CHOICE ? this.parseChoiceStyle(index2, nestingLevel) : this.parsePluralOrSelectStyle(argType, index2, nestingLevel));
            }
        }
        this.addLimitPart(argStart, Part.Type.ARG_LIMIT, index2, 1, argType.ordinal());
        return index2 + 1;
    }

    private int parseSimpleStyle(int index2) {
        int start = index2;
        int nestedBraces = 0;
        while (index2 < this.msg.length()) {
            int length;
            char c;
            if ((c = this.msg.charAt(index2++)) == '\'') {
                if ((index2 = this.msg.indexOf(39, index2)) < 0) {
                    throw new IllegalArgumentException("Quoted literal argument style text reaches to the end of the message: " + this.prefix(start));
                }
                ++index2;
                continue;
            }
            if (c == '{') {
                ++nestedBraces;
                continue;
            }
            if (c != '}') continue;
            if (nestedBraces > 0) {
                --nestedBraces;
                continue;
            }
            if ((length = --index2 - start) > 65535) {
                throw new IndexOutOfBoundsException("Argument style text too long: " + this.prefix(start));
            }
            this.addPart(Part.Type.ARG_STYLE, start, length, 0);
            return index2;
        }
        throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
    }

    private int parseChoiceStyle(int index2, int nestingLevel) {
        int start = index2;
        if ((index2 = this.skipWhiteSpace(index2)) == this.msg.length() || this.msg.charAt(index2) == '}') {
            throw new IllegalArgumentException("Missing choice argument pattern in " + this.prefix());
        }
        while (true) {
            int numberIndex = index2;
            int length = (index2 = this.skipDouble(index2)) - numberIndex;
            if (length == 0) {
                throw new IllegalArgumentException("Bad choice pattern syntax: " + this.prefix(start));
            }
            if (length > 65535) {
                throw new IndexOutOfBoundsException("Choice number too long: " + this.prefix(numberIndex));
            }
            this.parseDouble(numberIndex, index2, true);
            index2 = this.skipWhiteSpace(index2);
            if (index2 == this.msg.length()) {
                throw new IllegalArgumentException("Bad choice pattern syntax: " + this.prefix(start));
            }
            char c = this.msg.charAt(index2);
            if (c != '#' && c != '<' && c != '\u2264') {
                throw new IllegalArgumentException("Expected choice separator (#<\u2264) instead of '" + c + "' in choice pattern " + this.prefix(start));
            }
            this.addPart(Part.Type.ARG_SELECTOR, index2, 1, 0);
            ++index2;
            index2 = this.parseMessage(index2, 0, nestingLevel + 1, ArgType.CHOICE);
            if (index2 == this.msg.length()) {
                return index2;
            }
            if (this.msg.charAt(index2) == '}') {
                if (!this.inMessageFormatPattern(nestingLevel)) {
                    throw new IllegalArgumentException("Bad choice pattern syntax: " + this.prefix(start));
                }
                return index2;
            }
            index2 = this.skipWhiteSpace(index2 + 1);
        }
    }

    private int parsePluralOrSelectStyle(ArgType argType, int index2, int nestingLevel) {
        int start = index2;
        boolean isEmpty2 = true;
        boolean hasOther = false;
        while (true) {
            int length;
            boolean eos;
            boolean bl = eos = (index2 = this.skipWhiteSpace(index2)) == this.msg.length();
            if (eos || this.msg.charAt(index2) == '}') {
                if (eos == this.inMessageFormatPattern(nestingLevel)) {
                    throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(start));
                }
                if (!hasOther) {
                    throw new IllegalArgumentException("Missing 'other' keyword in " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern in " + this.prefix());
                }
                return index2;
            }
            int selectorIndex = index2;
            if (argType.hasPluralStyle() && this.msg.charAt(selectorIndex) == '=') {
                length = (index2 = this.skipDouble(index2 + 1)) - selectorIndex;
                if (length == 1) {
                    throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(start));
                }
                if (length > 65535) {
                    throw new IndexOutOfBoundsException("Argument selector too long: " + this.prefix(selectorIndex));
                }
                this.addPart(Part.Type.ARG_SELECTOR, selectorIndex, length, 0);
                this.parseDouble(selectorIndex + 1, index2, false);
            } else {
                length = (index2 = this.skipIdentifier(index2)) - selectorIndex;
                if (length == 0) {
                    throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(start));
                }
                if (argType.hasPluralStyle() && length == 6 && index2 < this.msg.length() && this.msg.regionMatches(selectorIndex, "offset:", 0, 7)) {
                    if (!isEmpty2) {
                        throw new IllegalArgumentException("Plural argument 'offset:' (if present) must precede key-message pairs: " + this.prefix(start));
                    }
                    int valueIndex = this.skipWhiteSpace(index2 + 1);
                    if ((index2 = this.skipDouble(valueIndex)) == valueIndex) {
                        throw new IllegalArgumentException("Missing value for plural 'offset:' " + this.prefix(start));
                    }
                    if (index2 - valueIndex > 65535) {
                        throw new IndexOutOfBoundsException("Plural offset value too long: " + this.prefix(valueIndex));
                    }
                    this.parseDouble(valueIndex, index2, false);
                    isEmpty2 = false;
                    continue;
                }
                if (length > 65535) {
                    throw new IndexOutOfBoundsException("Argument selector too long: " + this.prefix(selectorIndex));
                }
                this.addPart(Part.Type.ARG_SELECTOR, selectorIndex, length, 0);
                if (this.msg.regionMatches(selectorIndex, "other", 0, length)) {
                    hasOther = true;
                }
            }
            index2 = this.skipWhiteSpace(index2);
            if (index2 == this.msg.length() || this.msg.charAt(index2) != '{') {
                throw new IllegalArgumentException("No message fragment after " + argType.toString().toLowerCase(Locale.ENGLISH) + " selector: " + this.prefix(selectorIndex));
            }
            index2 = this.parseMessage(index2, 1, nestingLevel + 1, argType);
            isEmpty2 = false;
        }
    }

    private static int parseArgNumber(CharSequence s2, int start, int limit) {
        boolean badNumber;
        int number2;
        char c;
        if (start >= limit) {
            return -2;
        }
        if ((c = s2.charAt(start++)) == '0') {
            if (start == limit) {
                return 0;
            }
            number2 = 0;
            badNumber = true;
        } else if ('1' <= c && c <= '9') {
            number2 = c - 48;
            badNumber = false;
        } else {
            return -1;
        }
        while (start < limit) {
            if ('0' <= (c = s2.charAt(start++)) && c <= '9') {
                if (number2 >= 0xCCCCCCC) {
                    badNumber = true;
                }
                number2 = number2 * 10 + (c - 48);
                continue;
            }
            return -1;
        }
        if (badNumber) {
            return -2;
        }
        return number2;
    }

    private int parseArgNumber(int start, int limit) {
        return MessagePattern.parseArgNumber(this.msg, start, limit);
    }

    private void parseDouble(int start, int limit, boolean allowInfinity) {
        block10: {
            char c;
            int index2;
            int isNegative;
            int value2;
            block11: {
                block9: {
                    assert (start < limit);
                    value2 = 0;
                    isNegative = 0;
                    index2 = start;
                    if ((c = this.msg.charAt(index2++)) != '-') break block9;
                    isNegative = 1;
                    if (index2 == limit) break block10;
                    c = this.msg.charAt(index2++);
                    break block11;
                }
                if (c != '+') break block11;
                if (index2 == limit) break block10;
                c = this.msg.charAt(index2++);
            }
            if (c == '\u221e') {
                if (allowInfinity && index2 == limit) {
                    this.addArgDoublePart(isNegative != 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY, start, limit - start);
                    return;
                }
            } else {
                while ('0' <= c && c <= '9' && (value2 = value2 * 10 + (c - 48)) <= Short.MAX_VALUE + isNegative) {
                    if (index2 == limit) {
                        this.addPart(Part.Type.ARG_INT, start, limit - start, isNegative != 0 ? -value2 : value2);
                        return;
                    }
                    c = this.msg.charAt(index2++);
                }
                double numericValue = Double.parseDouble(this.msg.substring(start, limit));
                this.addArgDoublePart(numericValue, start, limit - start);
                return;
            }
        }
        throw new NumberFormatException("Bad syntax for numeric value: " + this.msg.substring(start, limit));
    }

    static void appendReducedApostrophes(String s2, int start, int limit, StringBuilder sb) {
        int doubleApos = -1;
        while (true) {
            int i;
            if ((i = s2.indexOf(39, start)) < 0 || i >= limit) break;
            if (i == doubleApos) {
                sb.append('\'');
                ++start;
                doubleApos = -1;
                continue;
            }
            sb.append(s2, start, i);
            doubleApos = start = i + 1;
        }
        sb.append(s2, start, limit);
    }

    private int skipWhiteSpace(int index2) {
        return PatternProps.skipWhiteSpace(this.msg, index2);
    }

    private int skipIdentifier(int index2) {
        return PatternProps.skipIdentifier(this.msg, index2);
    }

    private int skipDouble(int index2) {
        char c;
        while (!(index2 >= this.msg.length() || (c = this.msg.charAt(index2)) < '0' && "+-.".indexOf(c) < 0 || c > '9' && c != 'e' && c != 'E' && c != '\u221e')) {
            ++index2;
        }
        return index2;
    }

    private static boolean isArgTypeChar(int c) {
        return 97 <= c && c <= 122 || 65 <= c && c <= 90;
    }

    private boolean isChoice(int index2) {
        char c;
        return !((c = this.msg.charAt(index2++)) != 'c' && c != 'C' || (c = this.msg.charAt(index2++)) != 'h' && c != 'H' || (c = this.msg.charAt(index2++)) != 'o' && c != 'O' || (c = this.msg.charAt(index2++)) != 'i' && c != 'I' || (c = this.msg.charAt(index2++)) != 'c' && c != 'C' || (c = this.msg.charAt(index2)) != 'e' && c != 'E');
    }

    private boolean isPlural(int index2) {
        char c;
        return !((c = this.msg.charAt(index2++)) != 'p' && c != 'P' || (c = this.msg.charAt(index2++)) != 'l' && c != 'L' || (c = this.msg.charAt(index2++)) != 'u' && c != 'U' || (c = this.msg.charAt(index2++)) != 'r' && c != 'R' || (c = this.msg.charAt(index2++)) != 'a' && c != 'A' || (c = this.msg.charAt(index2)) != 'l' && c != 'L');
    }

    private boolean isSelect(int index2) {
        char c;
        return !((c = this.msg.charAt(index2++)) != 's' && c != 'S' || (c = this.msg.charAt(index2++)) != 'e' && c != 'E' || (c = this.msg.charAt(index2++)) != 'l' && c != 'L' || (c = this.msg.charAt(index2++)) != 'e' && c != 'E' || (c = this.msg.charAt(index2++)) != 'c' && c != 'C' || (c = this.msg.charAt(index2)) != 't' && c != 'T');
    }

    private boolean isOrdinal(int index2) {
        char c;
        return !((c = this.msg.charAt(index2++)) != 'o' && c != 'O' || (c = this.msg.charAt(index2++)) != 'r' && c != 'R' || (c = this.msg.charAt(index2++)) != 'd' && c != 'D' || (c = this.msg.charAt(index2++)) != 'i' && c != 'I' || (c = this.msg.charAt(index2++)) != 'n' && c != 'N' || (c = this.msg.charAt(index2++)) != 'a' && c != 'A' || (c = this.msg.charAt(index2)) != 'l' && c != 'L');
    }

    private boolean inMessageFormatPattern(int nestingLevel) {
        return nestingLevel > 0 || this.parts.get(0).type == Part.Type.MSG_START;
    }

    private boolean inTopLevelChoiceMessage(int nestingLevel, ArgType parentType) {
        return nestingLevel == 1 && parentType == ArgType.CHOICE && this.parts.get(0).type != Part.Type.MSG_START;
    }

    private void addPart(Part.Type type, int index2, int length, int value2) {
        this.parts.add(new Part(type, index2, length, value2));
    }

    private void addLimitPart(int start, Part.Type type, int index2, int length, int value2) {
        this.parts.get(start).limitPartIndex = this.parts.size();
        this.addPart(type, index2, length, value2);
    }

    private void addArgDoublePart(double numericValue, int start, int length) {
        int numericIndex;
        if (this.numericValues == null) {
            this.numericValues = new ArrayList();
            numericIndex = 0;
        } else {
            numericIndex = this.numericValues.size();
            if (numericIndex > Short.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Too many numeric values");
            }
        }
        this.numericValues.add(numericValue);
        this.addPart(Part.Type.ARG_DOUBLE, start, length, numericIndex);
    }

    private static String prefix(String s2, int start) {
        StringBuilder prefix = new StringBuilder(44);
        if (start == 0) {
            prefix.append("\"");
        } else {
            prefix.append("[at pattern index ").append(start).append("] \"");
        }
        int substringLength = s2.length() - start;
        if (substringLength <= 24) {
            prefix.append(start == 0 ? s2 : s2.substring(start));
        } else {
            int limit = start + 24 - 4;
            if (Character.isHighSurrogate(s2.charAt(limit - 1))) {
                --limit;
            }
            prefix.append(s2, start, limit).append(" ...");
        }
        return prefix.append("\"").toString();
    }

    private static String prefix(String s2) {
        return MessagePattern.prefix(s2, 0);
    }

    private String prefix(int start) {
        return MessagePattern.prefix(this.msg, start);
    }

    private String prefix() {
        return MessagePattern.prefix(this.msg, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgType {
        NONE,
        SIMPLE,
        CHOICE,
        PLURAL,
        SELECT,
        SELECTORDINAL;


        public boolean hasPluralStyle() {
            return this == PLURAL || this == SELECTORDINAL;
        }
    }

    public static final class Part {
        private static final int MAX_LENGTH = 65535;
        private static final int MAX_VALUE = Short.MAX_VALUE;
        private final Type type;
        private final int index;
        private final char length;
        private short value;
        private int limitPartIndex;

        private Part(Type t, int i, int l, int v) {
            this.type = t;
            this.index = i;
            this.length = (char)l;
            this.value = (short)v;
        }

        public Type getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLength() {
            return this.length;
        }

        public int getLimit() {
            return this.index + this.length;
        }

        public int getValue() {
            return this.value;
        }

        public ArgType getArgType() {
            Type type = this.getType();
            if (type == Type.ARG_START || type == Type.ARG_LIMIT) {
                return argTypes[this.value];
            }
            return ArgType.NONE;
        }

        public String toString() {
            String valueString = this.type == Type.ARG_START || this.type == Type.ARG_LIMIT ? this.getArgType().name() : Integer.toString(this.value);
            return this.type.name() + "(" + valueString + ")@" + this.index;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Part o = (Part)other;
            return this.type.equals((Object)o.type) && this.index == o.index && this.length == o.length && this.value == o.value && this.limitPartIndex == o.limitPartIndex;
        }

        public int hashCode() {
            return ((this.type.hashCode() * 37 + this.index) * 37 + this.length) * 37 + this.value;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            MSG_START,
            MSG_LIMIT,
            SKIP_SYNTAX,
            INSERT_CHAR,
            REPLACE_NUMBER,
            ARG_START,
            ARG_LIMIT,
            ARG_NUMBER,
            ARG_NAME,
            ARG_TYPE,
            ARG_STYLE,
            ARG_SELECTOR,
            ARG_INT,
            ARG_DOUBLE;


            public boolean hasNumericValue() {
                return this == ARG_INT || this == ARG_DOUBLE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ApostropheMode {
        DOUBLE_OPTIONAL,
        DOUBLE_REQUIRED;

    }
}

