/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.text.UnicodeSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompoundTransliterator
extends Transliterator {
    private Transliterator[] trans;
    private int numAnonymousRBTs = 0;

    CompoundTransliterator(List<Transliterator> list2) {
        this(list2, 0);
    }

    CompoundTransliterator(List<Transliterator> list2, int numAnonymousRBTs) {
        super("", null);
        this.trans = null;
        this.init(list2, 0, false);
        this.numAnonymousRBTs = numAnonymousRBTs;
    }

    CompoundTransliterator(String id, UnicodeFilter filter2, Transliterator[] trans2, int numAnonymousRBTs2) {
        super(id, filter2);
        this.trans = trans2;
        this.numAnonymousRBTs = numAnonymousRBTs2;
    }

    private void init(List<Transliterator> list2, int direction, boolean fixReverseID) {
        int i;
        int count2 = list2.size();
        this.trans = new Transliterator[count2];
        for (i = 0; i < count2; ++i) {
            int j = direction == 0 ? i : count2 - 1 - i;
            this.trans[i] = list2.get(j);
        }
        if (direction == 1 && fixReverseID) {
            StringBuilder newID = new StringBuilder();
            for (i = 0; i < count2; ++i) {
                if (i > 0) {
                    newID.append(';');
                }
                newID.append(this.trans[i].getID());
            }
            this.setID(newID.toString());
        }
        this.computeMaximumContextLength();
    }

    public int getCount() {
        return this.trans.length;
    }

    public Transliterator getTransliterator(int index2) {
        return this.trans[index2];
    }

    private static void _smartAppend(StringBuilder buf, char c) {
        if (buf.length() != 0 && buf.charAt(buf.length() - 1) != c) {
            buf.append(c);
        }
    }

    @Override
    public String toRules(boolean escapeUnprintable) {
        StringBuilder rulesSource = new StringBuilder();
        if (this.numAnonymousRBTs >= 1 && this.getFilter() != null) {
            rulesSource.append("::").append(this.getFilter().toPattern(escapeUnprintable)).append(';');
        }
        for (int i = 0; i < this.trans.length; ++i) {
            String rule;
            if (this.trans[i].getID().startsWith("%Pass")) {
                rule = this.trans[i].toRules(escapeUnprintable);
                if (this.numAnonymousRBTs > 1 && i > 0 && this.trans[i - 1].getID().startsWith("%Pass")) {
                    rule = "::Null;" + rule;
                }
            } else {
                rule = this.trans[i].getID().indexOf(59) >= 0 ? this.trans[i].toRules(escapeUnprintable) : this.trans[i].baseToRules(escapeUnprintable);
            }
            CompoundTransliterator._smartAppend(rulesSource, '\n');
            rulesSource.append(rule);
            CompoundTransliterator._smartAppend(rulesSource, ';');
        }
        return rulesSource.toString();
    }

    @Override
    public void addSourceTargetSet(UnicodeSet filter2, UnicodeSet sourceSet, UnicodeSet targetSet) {
        UnicodeSet myFilter = new UnicodeSet(this.getFilterAsUnicodeSet(filter2));
        UnicodeSet tempTargetSet = new UnicodeSet();
        for (int i = 0; i < this.trans.length; ++i) {
            tempTargetSet.clear();
            this.trans[i].addSourceTargetSet(myFilter, sourceSet, tempTargetSet);
            targetSet.addAll(tempTargetSet);
            myFilter.addAll(tempTargetSet);
        }
    }

    @Override
    protected void handleTransliterate(Replaceable text2, Transliterator.Position index2, boolean incremental) {
        if (this.trans.length < 1) {
            index2.start = index2.limit;
            return;
        }
        int compoundLimit = index2.limit;
        int compoundStart = index2.start;
        int delta = 0;
        Object log2 = null;
        for (int i = 0; i < this.trans.length; ++i) {
            index2.start = compoundStart;
            int limit = index2.limit;
            if (index2.start == index2.limit) break;
            this.trans[i].filteredTransliterate(text2, index2, incremental);
            if (!incremental && index2.start != index2.limit) {
                throw new RuntimeException("ERROR: Incomplete non-incremental transliteration by " + this.trans[i].getID());
            }
            delta += index2.limit - limit;
            if (!incremental) continue;
            index2.limit = index2.start;
        }
        index2.limit = compoundLimit += delta;
    }

    private void computeMaximumContextLength() {
        int max2 = 0;
        for (int i = 0; i < this.trans.length; ++i) {
            int len = this.trans[i].getMaximumContextLength();
            if (len <= max2) continue;
            max2 = len;
        }
        this.setMaximumContextLength(max2);
    }

    public Transliterator safeClone() {
        UnicodeFilter filter2 = this.getFilter();
        if (filter2 != null && filter2 instanceof UnicodeSet) {
            filter2 = new UnicodeSet((UnicodeSet)filter2);
        }
        return new CompoundTransliterator(this.getID(), filter2, this.trans, this.numAnonymousRBTs);
    }
}

