/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.DictionaryMatcher;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.CharsTrie;
import java.text.CharacterIterator;

class CharsDictionaryMatcher
extends DictionaryMatcher {
    private CharSequence characters;

    public CharsDictionaryMatcher(CharSequence chars) {
        this.characters = chars;
    }

    public int matches(CharacterIterator text_, int maxLength, int[] lengths, int[] count_, int limit, int[] values) {
        UCharacterIterator text2 = UCharacterIterator.getInstance(text_);
        CharsTrie uct = new CharsTrie(this.characters, 0);
        int c = text2.nextCodePoint();
        BytesTrie.Result result2 = uct.firstForCodePoint(c);
        int numChars = 1;
        int count2 = 0;
        while (true) {
            if (result2.hasValue()) {
                if (count2 < limit) {
                    if (values != null) {
                        values[count2] = uct.getValue();
                    }
                    lengths[count2] = numChars;
                    ++count2;
                }
                if (result2 == BytesTrie.Result.FINAL_VALUE) {
                    break;
                }
            } else if (result2 == BytesTrie.Result.NO_MATCH) break;
            if (numChars >= maxLength) break;
            c = text2.nextCodePoint();
            ++numChars;
            result2 = uct.nextForCodePoint(c);
        }
        count_[0] = count2;
        return numChars;
    }

    public int getType() {
        return 1;
    }
}

