/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Assert;
import com.ibm.icu.text.DictionaryMatcher;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.util.BytesTrie;
import java.text.CharacterIterator;

class BytesDictionaryMatcher
extends DictionaryMatcher {
    private final byte[] characters;
    private final int transform;

    public BytesDictionaryMatcher(byte[] chars, int transform2) {
        this.characters = chars;
        Assert.assrt((transform2 & 0x7F000000) == 0x1000000);
        this.transform = transform2;
    }

    private int transform(int c) {
        if (c == 8205) {
            return 255;
        }
        if (c == 8204) {
            return 254;
        }
        int delta = c - (this.transform & 0x1FFFFF);
        if (delta < 0 || 253 < delta) {
            return -1;
        }
        return delta;
    }

    public int matches(CharacterIterator text_, int maxLength, int[] lengths, int[] count_, int limit, int[] values) {
        UCharacterIterator text2 = UCharacterIterator.getInstance(text_);
        BytesTrie bt = new BytesTrie(this.characters, 0);
        int c = text2.nextCodePoint();
        BytesTrie.Result result2 = bt.first(this.transform(c));
        int numChars = 1;
        int count2 = 0;
        while (true) {
            if (result2.hasValue()) {
                if (count2 < limit) {
                    if (values != null) {
                        values[count2] = bt.getValue();
                    }
                    lengths[count2] = numChars;
                    ++count2;
                }
                if (result2 == BytesTrie.Result.FINAL_VALUE) {
                    break;
                }
            } else if (result2 == BytesTrie.Result.NO_MATCH) break;
            if (numChars >= maxLength) break;
            c = text2.nextCodePoint();
            ++numChars;
            result2 = bt.next(this.transform(c));
        }
        count_[0] = count2;
        return numChars;
    }

    public int getType() {
        return 0;
    }
}

