/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CacheBase;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SoftCache<K, V, D>
extends CacheBase<K, V, D> {
    private ConcurrentHashMap<K, SettableSoftReference<V>> map = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V getInstance(K key, D data2) {
        SettableSoftReference<V> valueRef = this.map.get(key);
        if (valueRef != null) {
            SettableSoftReference<V> settableSoftReference = valueRef;
            synchronized (settableSoftReference) {
                Object value2 = ((SettableSoftReference)valueRef).ref.get();
                if (value2 != null) {
                    return (V)value2;
                }
                value2 = this.createInstance(key, data2);
                if (value2 != null) {
                    ((SettableSoftReference)valueRef).ref = new SoftReference(value2);
                }
                return (V)value2;
            }
        }
        Object value2 = this.createInstance(key, data2);
        if (value2 == null) {
            return null;
        }
        valueRef = this.map.putIfAbsent(key, new SettableSoftReference(value2));
        if (valueRef == null) {
            return value2;
        }
        return (V)((SettableSoftReference)valueRef).setIfAbsent(value2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SettableSoftReference<V> {
        private SoftReference<V> ref;

        private SettableSoftReference(V value2) {
            this.ref = new SoftReference<V>(value2);
        }

        private synchronized V setIfAbsent(V value2) {
            V oldValue = this.ref.get();
            if (oldValue == null) {
                this.ref = new SoftReference<V>(value2);
                return value2;
            }
            return oldValue;
        }
    }
}

