/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.text.UCharacterIterator;

public class BOCU {
    private static final int SLOPE_MIN_ = 3;
    private static final int SLOPE_MAX_ = 255;
    private static final int SLOPE_MIDDLE_ = 129;
    private static final int SLOPE_TAIL_COUNT_ = 253;
    private static final int SLOPE_SINGLE_ = 80;
    private static final int SLOPE_LEAD_2_ = 42;
    private static final int SLOPE_LEAD_3_ = 3;
    private static final int SLOPE_REACH_POS_1_ = 80;
    private static final int SLOPE_REACH_NEG_1_ = -80;
    private static final int SLOPE_REACH_POS_2_ = 10667;
    private static final int SLOPE_REACH_NEG_2_ = -10668;
    private static final int SLOPE_REACH_POS_3_ = 192785;
    private static final int SLOPE_REACH_NEG_3_ = -192786;
    private static final int SLOPE_START_POS_2_ = 210;
    private static final int SLOPE_START_POS_3_ = 252;
    private static final int SLOPE_START_NEG_2_ = 49;
    private static final int SLOPE_START_NEG_3_ = 7;

    public static int compress(String source, byte[] buffer, int offset) {
        int prev = 0;
        UCharacterIterator iterator2 = UCharacterIterator.getInstance(source);
        int codepoint = iterator2.nextCodePoint();
        while (codepoint != -1) {
            prev = prev < 19968 || prev >= 40960 ? (prev & 0xFFFFFF80) - -80 : 30292;
            offset = BOCU.writeDiff(codepoint - prev, buffer, offset);
            prev = codepoint;
            codepoint = iterator2.nextCodePoint();
        }
        return offset;
    }

    public static int getCompressionLength(String source) {
        int prev = 0;
        int result2 = 0;
        UCharacterIterator iterator2 = UCharacterIterator.getInstance(source);
        int codepoint = iterator2.nextCodePoint();
        while (codepoint != -1) {
            prev = prev < 19968 || prev >= 40960 ? (prev & 0xFFFFFF80) - -80 : 30292;
            codepoint = iterator2.nextCodePoint();
            result2 += BOCU.lengthOfDiff(codepoint - prev);
            prev = codepoint;
        }
        return result2;
    }

    private BOCU() {
    }

    private static final long getNegDivMod(int number2, int factor) {
        int modulo = number2 % factor;
        long result2 = number2 / factor;
        if (modulo < 0) {
            --result2;
            modulo += factor;
        }
        return result2 << 32 | (long)modulo;
    }

    private static final int writeDiff(int diff2, byte[] buffer, int offset) {
        if (diff2 >= -80) {
            if (diff2 <= 80) {
                buffer[offset++] = (byte)(129 + diff2);
            } else if (diff2 <= 10667) {
                buffer[offset++] = (byte)(210 + diff2 / 253);
                buffer[offset++] = (byte)(3 + diff2 % 253);
            } else if (diff2 <= 192785) {
                buffer[offset + 2] = (byte)(3 + diff2 % 253);
                buffer[offset + 1] = (byte)(3 + (diff2 /= 253) % 253);
                buffer[offset] = (byte)(252 + diff2 / 253);
                offset += 3;
            } else {
                buffer[offset + 3] = (byte)(3 + diff2 % 253);
                buffer[offset] = (byte)(3 + (diff2 /= 253) % 253);
                buffer[offset + 1] = (byte)(3 + (diff2 /= 253) % 253);
                buffer[offset] = -1;
                offset += 4;
            }
        } else {
            long division = BOCU.getNegDivMod(diff2, 253);
            int modulo = (int)division;
            if (diff2 >= -10668) {
                diff2 = (int)(division >> 32);
                buffer[offset++] = (byte)(49 + diff2);
                buffer[offset++] = (byte)(3 + modulo);
            } else if (diff2 >= -192786) {
                buffer[offset + 2] = (byte)(3 + modulo);
                diff2 = (int)(division >> 32);
                division = BOCU.getNegDivMod(diff2, 253);
                modulo = (int)division;
                diff2 = (int)(division >> 32);
                buffer[offset + 1] = (byte)(3 + modulo);
                buffer[offset] = (byte)(7 + diff2);
                offset += 3;
            } else {
                buffer[offset + 3] = (byte)(3 + modulo);
                diff2 = (int)(division >> 32);
                division = BOCU.getNegDivMod(diff2, 253);
                modulo = (int)division;
                diff2 = (int)(division >> 32);
                buffer[offset + 2] = (byte)(3 + modulo);
                division = BOCU.getNegDivMod(diff2, 253);
                modulo = (int)division;
                buffer[offset + 1] = (byte)(3 + modulo);
                buffer[offset] = 3;
                offset += 4;
            }
        }
        return offset;
    }

    private static final int lengthOfDiff(int diff2) {
        if (diff2 >= -80) {
            if (diff2 <= 80) {
                return 1;
            }
            if (diff2 <= 10667) {
                return 2;
            }
            if (diff2 <= 192785) {
                return 3;
            }
            return 4;
        }
        if (diff2 >= -10668) {
            return 2;
        }
        if (diff2 >= -192786) {
            return 3;
        }
        return 4;
    }
}

