/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.schemabuilder.StatementStart;
import com.google.common.base.Strings;
import java.nio.ByteBuffer;

public abstract class SchemaStatement
extends RegularStatement {
    static final String STATEMENT_START = "\n\t";
    static final String COLUMN_FORMATTING = "\n\t\t";
    private volatile String cache;

    abstract String buildInternal();

    @Override
    public String getQueryString() {
        if (this.cache == null) {
            this.cache = this.buildInternal();
        }
        return this.cache;
    }

    @Override
    public ByteBuffer[] getValues(ProtocolVersion protocolVersion) {
        return new ByteBuffer[0];
    }

    @Override
    public boolean hasValues() {
        return false;
    }

    @Override
    public String getKeyspace() {
        return null;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        return null;
    }

    static void validateNotEmpty(String columnName, String label) {
        if (Strings.isNullOrEmpty(columnName)) {
            throw new IllegalArgumentException(label + " should not be null or blank");
        }
    }

    static void validateNotNull(Object value2, String label) {
        if (value2 == null) {
            throw new IllegalArgumentException(label + " should not be null");
        }
    }

    static void validateNotKeyWord(String label, String message) {
        if (Metadata.isReservedCqlKeyword(label)) {
            throw new IllegalArgumentException(message);
        }
    }

    static SchemaStatement fromQueryString(final String queryString) {
        return new SchemaStatement(){

            @Override
            public String buildInternal() {
                return queryString;
            }
        };
    }

    StatementStart asStatementStart() {
        return new StatementStart(){

            @Override
            public String buildInternal() {
                return SchemaStatement.this.buildInternal();
            }
        };
    }
}

