/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.ReplicationStrategy;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata {
    private static final Logger logger = LoggerFactory.getLogger(Metadata.class);
    private final Cluster.Manager cluster;
    volatile String clusterName;
    volatile String partitioner;
    private final ConcurrentMap<InetSocketAddress, Host> hosts = new ConcurrentHashMap<InetSocketAddress, Host>();
    private final ConcurrentMap<String, KeyspaceMetadata> keyspaces = new ConcurrentHashMap<String, KeyspaceMetadata>();
    volatile TokenMap tokenMap;
    private static final Pattern alphanumeric = Pattern.compile("\\w+");
    private static final Pattern lowercaseAlphanumeric = Pattern.compile("[a-z][a-z0-9_]*");
    private static final Set<String> RESERVED_KEYWORDS = ImmutableSet.of("add", "allow", "alter", "and", "any", "apply", new String[]{"asc", "authorize", "batch", "begin", "by", "columnfamily", "create", "delete", "desc", "drop", "each_quorum", "from", "grant", "in", "index", "inet", "infinity", "insert", "into", "keyspace", "keyspaces", "limit", "local_one", "local_quorum", "modify", "nan", "norecursive", "of", "on", "one", "order", "password", "primary", "quorum", "rename", "revoke", "schema", "select", "set", "table", "to", "token", "three", "truncate", "two", "unlogged", "update", "use", "using", "where", "with"});

    Metadata(Cluster.Manager cluster) {
        this.cluster = cluster;
    }

    synchronized void rebuildSchema(SchemaElement targetType, String targetKeyspace, String targetName, ResultSet ks, ResultSet udts, ResultSet cfs, ResultSet cols, VersionNumber cassandraVersion) {
        Map<String, List<Row>> tableRows = this.groupByKeyspace(cfs);
        Map<String, List<Row>> udtRows = this.groupByKeyspace(udts);
        Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> colsDefs = this.groupByKeyspaceAndTable(cols, cassandraVersion);
        if (targetType == null || targetType == SchemaElement.KEYSPACE) {
            assert (ks != null);
            Map<String, KeyspaceMetadata> keyspaces = this.buildKeyspaces(ks, tableRows, colsDefs, udtRows, cassandraVersion);
            this.updateKeyspaces(this.keyspaces, keyspaces, targetKeyspace);
        } else if (targetType == SchemaElement.TABLE) {
            assert (targetKeyspace != null);
            KeyspaceMetadata keyspace = (KeyspaceMetadata)this.keyspaces.get(targetKeyspace);
            if (keyspace == null) {
                logger.info(String.format("Asked to rebuild table %s.%s but I don't know keyspace %s", targetKeyspace, targetName, targetKeyspace));
                this.cluster.submitSchemaRefresh(null, null, null);
                return;
            }
            if (tableRows.containsKey(targetKeyspace)) {
                Map<String, TableMetadata> tables = this.buildTables(keyspace, tableRows.get(targetKeyspace), colsDefs.get(targetKeyspace), cassandraVersion);
                this.updateTables(keyspace.tables, tables, targetName);
            }
        } else if (targetType == SchemaElement.TYPE) {
            assert (targetKeyspace != null);
            KeyspaceMetadata keyspace = (KeyspaceMetadata)this.keyspaces.get(targetKeyspace);
            if (keyspace == null) {
                logger.info(String.format("Asked to rebuild UDT %s.%s but I don't know keyspace %s", targetKeyspace, targetName, targetKeyspace));
                this.cluster.submitSchemaRefresh(null, null, null);
                return;
            }
            if (udtRows.containsKey(targetKeyspace)) {
                Map<String, UserType> userTypes = this.buildUserTypes(udtRows.get(targetKeyspace));
                this.updateUserTypes(keyspace.userTypes, userTypes, targetName);
            }
        }
    }

    private Map<String, List<Row>> groupByKeyspace(ResultSet rows) {
        if (rows == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Row>> groupedRows = new HashMap<String, List<Row>>();
        for (Row row : rows) {
            String ksName = row.getString("keyspace_name");
            ArrayList<Row> l = (ArrayList<Row>)groupedRows.get(ksName);
            if (l == null) {
                l = new ArrayList<Row>();
                groupedRows.put(ksName, l);
            }
            l.add(row);
        }
        return groupedRows;
    }

    private Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> groupByKeyspaceAndTable(ResultSet rows, VersionNumber cassandraVersion) {
        if (rows == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, ColumnMetadata.Raw>>> groupedRows = new HashMap<String, Map<String, Map<String, ColumnMetadata.Raw>>>();
        for (Row row : rows) {
            HashMap<String, ColumnMetadata.Raw> l;
            String ksName = row.getString("keyspace_name");
            String cfName = row.getString("columnfamily_name");
            HashMap colsByCf = (HashMap)groupedRows.get(ksName);
            if (colsByCf == null) {
                colsByCf = new HashMap();
                groupedRows.put(ksName, colsByCf);
            }
            if ((l = (HashMap<String, ColumnMetadata.Raw>)colsByCf.get(cfName)) == null) {
                l = new HashMap<String, ColumnMetadata.Raw>();
                colsByCf.put(cfName, l);
            }
            ColumnMetadata.Raw c = ColumnMetadata.Raw.fromRow(row, cassandraVersion);
            l.put(c.name, c);
        }
        return groupedRows;
    }

    private Map<String, KeyspaceMetadata> buildKeyspaces(ResultSet keyspaceRows, Map<String, List<Row>> tableRows, Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> colsDefs, Map<String, List<Row>> udtRows, VersionNumber cassandraVersion) {
        LinkedHashMap<String, KeyspaceMetadata> keyspaces = new LinkedHashMap<String, KeyspaceMetadata>();
        for (Row keyspaceRow : keyspaceRows) {
            KeyspaceMetadata keyspace = KeyspaceMetadata.build(keyspaceRow);
            Map<String, TableMetadata> tables = this.buildTables(keyspace, tableRows.get(keyspace.getName()), colsDefs.get(keyspace.getName()), cassandraVersion);
            for (TableMetadata table : tables.values()) {
                keyspace.add(table);
            }
            Map<String, UserType> userTypes = this.buildUserTypes(udtRows.get(keyspace.getName()));
            for (UserType userType : userTypes.values()) {
                keyspace.add(userType);
            }
            keyspaces.put(keyspace.getName(), keyspace);
        }
        return keyspaces;
    }

    private Map<String, TableMetadata> buildTables(KeyspaceMetadata keyspace, List<Row> tableRows, Map<String, Map<String, ColumnMetadata.Raw>> colsDefs, VersionNumber cassandraVersion) {
        LinkedHashMap<String, TableMetadata> tables = new LinkedHashMap<String, TableMetadata>();
        if (tableRows != null) {
            for (Row tableDef : tableRows) {
                String cfName = tableDef.getString("columnfamily_name");
                try {
                    Map<String, ColumnMetadata.Raw> cols;
                    Map<String, ColumnMetadata.Raw> map2 = cols = colsDefs == null ? null : colsDefs.get(cfName);
                    if (cols == null || cols.isEmpty()) {
                        if (cassandraVersion.getMajor() >= 2) continue;
                        cols = Collections.emptyMap();
                    }
                    TableMetadata table = TableMetadata.build(keyspace, tableDef, cols, cassandraVersion);
                    tables.put(table.getName(), table);
                }
                catch (RuntimeException e) {
                    logger.error(String.format("Error parsing schema for table %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getTable(\"%s\") will be missing or incomplete", keyspace.getName(), cfName, keyspace.getName(), cfName), e);
                }
            }
        }
        return tables;
    }

    private Map<String, UserType> buildUserTypes(List<Row> udtRows) {
        LinkedHashMap<String, UserType> userTypes = new LinkedHashMap<String, UserType>();
        if (udtRows != null) {
            for (Row udtRow : udtRows) {
                UserType type = UserType.build(udtRow);
                userTypes.put(type.getTypeName(), type);
            }
        }
        return userTypes;
    }

    private void updateKeyspaces(Map<String, KeyspaceMetadata> oldKeyspaces, Map<String, KeyspaceMetadata> newKeyspaces, String keyspaceToRebuild) {
        Iterator<KeyspaceMetadata> it = oldKeyspaces.values().iterator();
        while (it.hasNext()) {
            KeyspaceMetadata oldKeyspace = it.next();
            String keyspaceName = oldKeyspace.getName();
            if (keyspaceToRebuild != null && !keyspaceToRebuild.equals(keyspaceName) || newKeyspaces.containsKey(keyspaceName)) continue;
            it.remove();
            this.triggerOnKeyspaceRemoved(oldKeyspace);
        }
        for (KeyspaceMetadata newKeyspace : newKeyspaces.values()) {
            KeyspaceMetadata oldKeyspace = oldKeyspaces.put(newKeyspace.getName(), newKeyspace);
            if (oldKeyspace == null) {
                this.triggerOnKeyspaceAdded(newKeyspace);
            } else if (!oldKeyspace.equals(newKeyspace)) {
                this.triggerOnKeyspaceChanged(newKeyspace, oldKeyspace);
            }
            HashMap<String, TableMetadata> oldTables = oldKeyspace == null ? new HashMap() : oldKeyspace.tables;
            this.updateTables(oldTables, newKeyspace.tables, null);
            HashMap<String, UserType> oldTypes = oldKeyspace == null ? new HashMap() : oldKeyspace.userTypes;
            this.updateUserTypes(oldTypes, newKeyspace.userTypes, null);
        }
    }

    private void updateTables(Map<String, TableMetadata> oldTables, Map<String, TableMetadata> newTables, String tableToRebuild) {
        Iterator<TableMetadata> it = oldTables.values().iterator();
        while (it.hasNext()) {
            TableMetadata oldTable = it.next();
            String tableName = oldTable.getName();
            if (tableToRebuild != null && !tableToRebuild.equals(tableName) || newTables.containsKey(tableName)) continue;
            it.remove();
            this.triggerOnTableRemoved(oldTable);
        }
        for (TableMetadata newTable : newTables.values()) {
            TableMetadata oldTable = oldTables.put(newTable.getName(), newTable);
            if (oldTable == null) {
                this.triggerOnTableAdded(newTable);
                continue;
            }
            if (oldTable.equals(newTable)) continue;
            this.triggerOnTableChanged(newTable, oldTable);
        }
    }

    private void updateUserTypes(Map<String, UserType> oldTypes, Map<String, UserType> newTypes, String typeToRebuild) {
        Iterator<UserType> it = oldTypes.values().iterator();
        while (it.hasNext()) {
            UserType oldType = it.next();
            String typeName = oldType.getTypeName();
            if (typeToRebuild != null && !typeToRebuild.equals(typeName) || newTypes.containsKey(typeName)) continue;
            it.remove();
            this.triggerOnUserTypeRemoved(oldType);
        }
        for (UserType newType : newTypes.values()) {
            UserType oldType = oldTypes.put(newType.getTypeName(), newType);
            if (oldType == null) {
                this.triggerOnUserTypeAdded(newType);
                continue;
            }
            if (newType.equals(oldType)) continue;
            this.triggerOnUserTypeChanged(newType, oldType);
        }
    }

    void triggerOnKeyspaceAdded(KeyspaceMetadata keyspace) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onKeyspaceAdded(keyspace);
        }
    }

    void triggerOnKeyspaceChanged(KeyspaceMetadata current, KeyspaceMetadata previous) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onKeyspaceChanged(current, previous);
        }
    }

    void triggerOnKeyspaceRemoved(KeyspaceMetadata keyspace) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onKeyspaceRemoved(keyspace);
        }
    }

    void triggerOnTableAdded(TableMetadata table) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onTableAdded(table);
        }
    }

    void triggerOnTableChanged(TableMetadata current, TableMetadata previous) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onTableChanged(current, previous);
        }
    }

    void triggerOnTableRemoved(TableMetadata table) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onTableRemoved(table);
        }
    }

    void triggerOnUserTypeAdded(UserType type) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onUserTypeAdded(type);
        }
    }

    void triggerOnUserTypeChanged(UserType current, UserType previous) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onUserTypeChanged(current, previous);
        }
    }

    void triggerOnUserTypeRemoved(UserType type) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onUserTypeRemoved(type);
        }
    }

    synchronized void rebuildTokenMap(String partitioner, Map<Host, Collection<String>> allTokens) {
        Token.Factory factory;
        if (allTokens.isEmpty()) {
            return;
        }
        Object object = partitioner == null ? (this.tokenMap == null ? null : this.tokenMap.factory) : (factory = Token.getFactory(partitioner));
        if (factory == null) {
            return;
        }
        this.tokenMap = TokenMap.build(factory, allTokens, this.keyspaces.values());
    }

    Host newHost(InetSocketAddress address) {
        return new Host(address, this.cluster.convictionPolicyFactory, this.cluster);
    }

    Host addIfAbsent(Host host) {
        Host previous = this.hosts.putIfAbsent(host.getSocketAddress(), host);
        return previous == null ? host : null;
    }

    Host add(InetSocketAddress address) {
        return this.addIfAbsent(this.newHost(address));
    }

    boolean remove(Host host) {
        return this.hosts.remove(host.getSocketAddress()) != null;
    }

    Host getHost(InetSocketAddress address) {
        return (Host)this.hosts.get(address);
    }

    Collection<Host> allHosts() {
        return this.hosts.values();
    }

    static String handleId(String id) {
        if (id == null) {
            return null;
        }
        if (alphanumeric.matcher(id).matches()) {
            return id.toLowerCase();
        }
        if (!id.isEmpty() && id.charAt(0) == '\"' && id.charAt(id.length() - 1) == '\"') {
            return id.substring(1, id.length() - 1).replaceAll("\"\"", "\"");
        }
        return id;
    }

    static String escapeId(String ident2) {
        return lowercaseAlphanumeric.matcher(ident2).matches() && !Metadata.isReservedCqlKeyword(ident2) ? ident2 : Metadata.quote(ident2);
    }

    public static String quote(String id) {
        return '\"' + id.replace("\"", "\"\"") + '\"';
    }

    public static boolean isReservedCqlKeyword(String id) {
        return id != null && RESERVED_KEYWORDS.contains(id.toLowerCase());
    }

    public Set<TokenRange> getTokenRanges() {
        TokenMap current = this.tokenMap;
        return current == null ? Collections.emptySet() : current.tokenRanges;
    }

    public Set<TokenRange> getTokenRanges(String keyspace, Host host) {
        keyspace = Metadata.handleId(keyspace);
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Map dcRanges = (Map)current.hostsToRanges.get(keyspace);
        if (dcRanges == null) {
            return Collections.emptySet();
        }
        Set ranges = (Set)dcRanges.get(host);
        return ranges == null ? Collections.emptySet() : ranges;
    }

    public Set<Host> getReplicas(String keyspace, ByteBuffer partitionKey) {
        keyspace = Metadata.handleId(keyspace);
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Set hosts = current.getReplicas(keyspace, current.factory.hash(partitionKey));
        return hosts == null ? Collections.emptySet() : hosts;
    }

    public Set<Host> getReplicas(String keyspace, TokenRange range2) {
        keyspace = Metadata.handleId(keyspace);
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Set hosts = current.getReplicas(keyspace, range2.getEnd());
        return hosts == null ? Collections.emptySet() : hosts;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getPartitioner() {
        return this.partitioner;
    }

    public Set<Host> getAllHosts() {
        return new HashSet<Host>(this.allHosts());
    }

    public boolean checkSchemaAgreement() {
        try {
            return this.cluster.controlConnection.checkSchemaAgreement();
        }
        catch (Exception e) {
            logger.warn("Error while checking schema agreement", e);
            return false;
        }
    }

    public KeyspaceMetadata getKeyspace(String keyspace) {
        return (KeyspaceMetadata)this.keyspaces.get(Metadata.handleId(keyspace));
    }

    KeyspaceMetadata getKeyspaceInternal(String keyspace) {
        return (KeyspaceMetadata)this.keyspaces.get(keyspace);
    }

    KeyspaceMetadata removeKeyspace(String keyspace) {
        KeyspaceMetadata removed = (KeyspaceMetadata)this.keyspaces.remove(keyspace);
        if (this.tokenMap != null) {
            this.tokenMap.tokenToHosts.remove(keyspace);
        }
        return removed;
    }

    public List<KeyspaceMetadata> getKeyspaces() {
        return new ArrayList<KeyspaceMetadata>(this.keyspaces.values());
    }

    public String exportSchemaAsString() {
        StringBuilder sb = new StringBuilder();
        for (KeyspaceMetadata ksm : this.keyspaces.values()) {
            sb.append(ksm.exportAsString()).append('\n');
        }
        return sb.toString();
    }

    public Token newToken(String tokenStr) {
        TokenMap current = this.tokenMap;
        if (current == null) {
            throw new IllegalStateException("Token factory not set. This should only happen if metadata was explicitly disabled");
        }
        return current.factory.fromString(tokenStr);
    }

    public TokenRange newTokenRange(Token start, Token end) {
        TokenMap current = this.tokenMap;
        if (current == null) {
            throw new IllegalStateException("Token factory not set. This should only happen if metadata was explicitly disabled");
        }
        return new TokenRange(start, end, current.factory);
    }

    Token.Factory tokenFactory() {
        TokenMap current = this.tokenMap;
        return current == null ? null : current.factory;
    }

    static class TokenMap {
        private final Token.Factory factory;
        private final Map<String, Map<Token, Set<Host>>> tokenToHosts;
        private final Map<String, Map<Host, Set<TokenRange>>> hostsToRanges;
        private final List<Token> ring;
        private final Set<TokenRange> tokenRanges;
        final Set<Host> hosts;

        private TokenMap(Token.Factory factory, Map<Host, Set<Token>> primaryToTokens, Map<String, Map<Token, Set<Host>>> tokenToHosts, Map<String, Map<Host, Set<TokenRange>>> hostsToRanges, List<Token> ring, Set<TokenRange> tokenRanges, Set<Host> hosts) {
            this.factory = factory;
            this.tokenToHosts = tokenToHosts;
            this.hostsToRanges = hostsToRanges;
            this.ring = ring;
            this.tokenRanges = tokenRanges;
            this.hosts = hosts;
            for (Map.Entry<Host, Set<Token>> entry2 : primaryToTokens.entrySet()) {
                Host host = entry2.getKey();
                host.setTokens(ImmutableSet.copyOf((Collection)entry2.getValue()));
            }
        }

        public static TokenMap build(Token.Factory factory, Map<Host, Collection<String>> allTokens, Collection<KeyspaceMetadata> keyspaces) {
            Set<Host> hosts = allTokens.keySet();
            HashMap<Token, Host> tokenToPrimary = new HashMap<Token, Host>();
            HashMap<Host, Set<Token>> primaryToTokens = new HashMap<Host, Set<Token>>();
            TreeSet<Token> allSorted = new TreeSet<Token>();
            for (Map.Entry<Host, Collection<String>> entry2 : allTokens.entrySet()) {
                Host host = entry2.getKey();
                for (String tokenStr : entry2.getValue()) {
                    try {
                        Token t = factory.fromString(tokenStr);
                        allSorted.add(t);
                        tokenToPrimary.put(t, host);
                        HashSet<Token> hostTokens = (HashSet<Token>)primaryToTokens.get(host);
                        if (hostTokens == null) {
                            hostTokens = new HashSet<Token>();
                            primaryToTokens.put(host, hostTokens);
                        }
                        hostTokens.add(t);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            ArrayList<Token> ring = new ArrayList<Token>(allSorted);
            Set<TokenRange> tokenRanges = TokenMap.makeTokenRanges(ring, factory);
            HashMap<String, Map<Token, Set<Host>>> tokenToHosts = new HashMap<String, Map<Token, Set<Host>>>();
            HashMap<ReplicationStrategy, Map<Token, Set<Host>>> replStrategyToHosts = new HashMap<ReplicationStrategy, Map<Token, Set<Host>>>();
            HashMap<String, Map<Host, Set<TokenRange>>> hostsToRanges = new HashMap<String, Map<Host, Set<TokenRange>>>();
            for (KeyspaceMetadata keyspace : keyspaces) {
                Map<Host, Set<TokenRange>> ksRanges;
                ReplicationStrategy strategy = keyspace.replicationStrategy();
                Map<Token, Set<Host>> ksTokens = (Map<Token, Set<Host>>)replStrategyToHosts.get(strategy);
                if (ksTokens == null) {
                    ksTokens = strategy == null ? TokenMap.makeNonReplicatedMap(tokenToPrimary) : strategy.computeTokenToReplicaMap(keyspace.getName(), tokenToPrimary, ring);
                    replStrategyToHosts.put(strategy, ksTokens);
                }
                tokenToHosts.put(keyspace.getName(), ksTokens);
                if (ring.size() == 1) {
                    ImmutableMap.Builder<Host, Set<TokenRange>> builder = ImmutableMap.builder();
                    for (Host host : allTokens.keySet()) {
                        builder.put(host, tokenRanges);
                    }
                    ksRanges = builder.build();
                } else {
                    ksRanges = TokenMap.computeHostsToRangesMap(tokenRanges, ksTokens, hosts.size());
                }
                hostsToRanges.put(keyspace.getName(), ksRanges);
            }
            return new TokenMap(factory, primaryToTokens, tokenToHosts, hostsToRanges, ring, tokenRanges, hosts);
        }

        private Set<Host> getReplicas(String keyspace, Token token2) {
            Map<Token, Set<Host>> keyspaceHosts = this.tokenToHosts.get(keyspace);
            if (keyspaceHosts == null) {
                return Collections.emptySet();
            }
            Set<Host> hosts = keyspaceHosts.get(token2);
            if (hosts != null) {
                return hosts;
            }
            int i = Collections.binarySearch(this.ring, token2);
            if (i < 0 && (i = -i - 1) >= this.ring.size()) {
                i = 0;
            }
            return keyspaceHosts.get(this.ring.get(i));
        }

        private static Map<Token, Set<Host>> makeNonReplicatedMap(Map<Token, Host> input2) {
            HashMap<Token, Set<Host>> output = new HashMap<Token, Set<Host>>(input2.size());
            for (Map.Entry<Token, Host> entry2 : input2.entrySet()) {
                output.put(entry2.getKey(), ImmutableSet.of(entry2.getValue()));
            }
            return output;
        }

        private static Set<TokenRange> makeTokenRanges(List<Token> ring, Token.Factory factory) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ring.size() == 1) {
                builder.add(new TokenRange(factory.minToken(), factory.minToken(), factory));
            } else {
                for (int i = 0; i < ring.size(); ++i) {
                    Token start = ring.get(i);
                    Token end = ring.get((i + 1) % ring.size());
                    builder.add(new TokenRange(start, end, factory));
                }
            }
            return builder.build();
        }

        private static Map<Host, Set<TokenRange>> computeHostsToRangesMap(Set<TokenRange> tokenRanges, Map<Token, Set<Host>> ksTokens, int hostCount) {
            HashMap builders = Maps.newHashMapWithExpectedSize(hostCount);
            for (TokenRange range2 : tokenRanges) {
                Set<Host> replicas = ksTokens.get(range2.getEnd());
                for (Host host : replicas) {
                    ImmutableSet.Builder hostRanges = (ImmutableSet.Builder)builders.get(host);
                    if (hostRanges == null) {
                        hostRanges = ImmutableSet.builder();
                        builders.put(host, hostRanges);
                    }
                    hostRanges.add(range2);
                }
            }
            HashMap<Host, Set<TokenRange>> ksRanges = Maps.newHashMapWithExpectedSize(hostCount);
            for (Map.Entry entry2 : builders.entrySet()) {
                ksRanges.put((Host)entry2.getKey(), (Set<TokenRange>)((Object)((ImmutableSet.Builder)entry2.getValue()).build()));
            }
            return ksRanges;
        }
    }
}

