/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeakReferenceMonitor {
    private static final Log logger = LogFactory.getLog(WeakReferenceMonitor.class);
    private static final ReferenceQueue<Object> handleQueue = new ReferenceQueue();
    private static final Map<Reference, ReleaseListener> trackedEntries = new HashMap<Reference, ReleaseListener>();
    private static Thread monitoringThread = null;

    public static void monitor(Object handle2, ReleaseListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Monitoring handle [" + handle2 + "] with release listener [" + listener + "]"));
        }
        WeakReference<Object> weakRef = new WeakReference<Object>(handle2, handleQueue);
        WeakReferenceMonitor.addEntry(weakRef, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(Reference ref, ReleaseListener entry2) {
        Class<WeakReferenceMonitor> clazz = WeakReferenceMonitor.class;
        synchronized (WeakReferenceMonitor.class) {
            trackedEntries.put(ref, entry2);
            if (monitoringThread == null) {
                monitoringThread = new Thread((Runnable)new MonitoringProcess(), WeakReferenceMonitor.class.getName());
                monitoringThread.setDaemon(true);
                monitoringThread.start();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReleaseListener removeEntry(Reference reference) {
        Class<WeakReferenceMonitor> clazz = WeakReferenceMonitor.class;
        synchronized (WeakReferenceMonitor.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return trackedEntries.remove(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean keepMonitoringThreadAlive() {
        Class<WeakReferenceMonitor> clazz = WeakReferenceMonitor.class;
        synchronized (WeakReferenceMonitor.class) {
            if (!trackedEntries.isEmpty()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            logger.debug((Object)"No entries left to track - stopping reference monitor thread");
            monitoringThread = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return false;
        }
    }

    public static interface ReleaseListener {
        public void released();
    }

    private static class MonitoringProcess
    implements Runnable {
        private MonitoringProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            logger.debug((Object)"Starting reference monitor thread");
            while (WeakReferenceMonitor.keepMonitoringThreadAlive()) {
                try {
                    Reference reference = handleQueue.remove();
                    ReleaseListener entry2 = WeakReferenceMonitor.removeEntry(reference);
                    if (entry2 == null) continue;
                    try {
                        entry2.released();
                    }
                    catch (Throwable ex) {
                        logger.warn((Object)"Reference release listener threw exception", ex);
                    }
                }
                catch (InterruptedException ex) {
                    Class<WeakReferenceMonitor> clazz = WeakReferenceMonitor.class;
                    synchronized (WeakReferenceMonitor.class) {
                        monitoringThread = null;
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        logger.debug((Object)"Reference monitor thread interrupted", (Throwable)ex);
                        return;
                    }
                }
            }
        }
    }
}

