/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;

public class InMemoryTokenRepositoryImpl
implements PersistentTokenRepository {
    private final Map<String, PersistentRememberMeToken> seriesTokens = new HashMap<String, PersistentRememberMeToken>();

    public synchronized void createNewToken(PersistentRememberMeToken token2) {
        PersistentRememberMeToken current = this.seriesTokens.get(token2.getSeries());
        if (current != null) {
            throw new DataIntegrityViolationException("Series Id '" + token2.getSeries() + "' already exists!");
        }
        this.seriesTokens.put(token2.getSeries(), token2);
    }

    public synchronized void updateToken(String series, String tokenValue, Date lastUsed) {
        PersistentRememberMeToken token2 = this.getTokenForSeries(series);
        PersistentRememberMeToken newToken = new PersistentRememberMeToken(token2.getUsername(), series, tokenValue, new Date());
        this.seriesTokens.put(series, newToken);
    }

    public synchronized PersistentRememberMeToken getTokenForSeries(String seriesId) {
        return this.seriesTokens.get(seriesId);
    }

    public synchronized void removeUserTokens(String username) {
        Iterator<String> series = this.seriesTokens.keySet().iterator();
        while (series.hasNext()) {
            String seriesId = series.next();
            PersistentRememberMeToken token2 = this.seriesTokens.get(seriesId);
            if (!username.equals(token2.getUsername())) continue;
            series.remove();
        }
    }
}

