/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.core.sessions.CoreSessionEventManager;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.ClientSession;

public class SessionEventManager
extends CoreSessionEventManager<SessionEventListener>
implements Cloneable,
Serializable {
    protected List<SessionEventListener> listeners = new ArrayList<SessionEventListener>();
    protected Session session;

    public SessionEventManager() {
    }

    public SessionEventManager(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(SessionEventListener listener) {
        if (this.session != null) {
            if (this.session.isConnected()) {
                SessionEventManager sessionEventManager = this;
                synchronized (sessionEventManager) {
                    if (this.listeners != null) {
                        ArrayList<SessionEventListener> listenersCopy = new ArrayList<SessionEventListener>(this.listeners);
                        listenersCopy.add(listener);
                        this.listeners = listenersCopy;
                    } else {
                        this.listeners = new ArrayList<SessionEventListener>();
                        this.listeners.add(listener);
                    }
                }
            } else {
                this.getListeners().add(listener);
            }
            if (this.session.isSessionBroker()) {
                for (AbstractSession memberSession : ((SessionBroker)this.session).getSessionsByName().values()) {
                    memberSession.getEventManager().addListener(listener);
                }
            }
        } else {
            this.getListeners().add(listener);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            return new InternalError(exception.toString());
        }
    }

    public SessionEventManager clone(Session newSession) {
        SessionEventManager newManager = (SessionEventManager)this.clone();
        newManager.setSession(newSession);
        if (this.listeners != null) {
            newManager.setListeners(new ArrayList<SessionEventListener>(this.listeners));
        }
        return newManager;
    }

    public List<SessionEventListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<SessionEventListener>();
        }
        return this.listeners;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void missingDescriptor(Class missingClass) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(32, this.getSession());
        event.setResult(missingClass);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).missingDescriptor(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void moreRowsDetected(DatabaseCall call) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(20, this.getSession());
        event.setResult(call);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).moreRowsDetected(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void noRowsModified(ModifyQuery query, Object object) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(35, this.getSession());
        event.setQuery(query);
        event.setResult(object);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).noRowsModified(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void outputParametersDetected(Record outputRow, DatasourceCall call) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(19, this.getSession());
        event.setResult(outputRow);
        event.setProperty("call", call);
        event.setQuery(call.getQuery());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).outputParametersDetected(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postAcquireClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(16, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postAcquireClientSession(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postAcquireConnection(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(22, this.getSession());
        event.setResult(accessor);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postAcquireConnection(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postAcquireExclusiveConnection(ClientSession clientSession, Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        SessionEvent event = new SessionEvent(33, clientSession);
        event.setResult(accessor);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postAcquireExclusiveConnection(event);
            ++index2;
        }
    }

    public void postAcquireUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(9, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postAcquireUnitOfWork(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postBeginTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(4, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postBeginTransaction(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postCommitTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(6, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postCommitTransaction(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postCommitUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(11, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postCommitUnitOfWork(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postConnect(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(21, this.getSession());
        event.setResult(accessor);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postConnect(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postExecuteQuery(DatabaseQuery query, Object result2) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(2, this.getSession());
        event.setQuery(query);
        event.setResult(result2);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            this.listeners.get(index2).postExecuteQuery(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postReleaseClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(18, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postReleaseClientSession(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postReleaseUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(13, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postReleaseUnitOfWork(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postResumeUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(15, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postResumeUnitOfWork(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postRollbackTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(8, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postRollbackTransaction(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postDistributedMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(29, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postDistributedMergeUnitOfWorkChangeSet(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(28, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postMergeUnitOfWorkChangeSet(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preBeginTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(3, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preBeginTransaction(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preCalculateUnitOfWorkChangeSet() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(30, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preCalculateUnitOfWorkChangeSet(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postCalculateUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(31, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postCalculateUnitOfWorkChangeSet(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preCommitTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(5, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preCommitTransaction(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preCommitUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(10, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preCommitUnitOfWork(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preExecuteQuery(DatabaseQuery query) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(1, this.getSession());
        event.setQuery(query);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preExecuteQuery(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preLogin(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(24, session);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preLogin(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postLogin(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(25, session);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postLogin(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preLogout(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(40, session);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preLogout(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void postLogout(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(41, session);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).postLogout(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void prepareUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(14, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).prepareUnitOfWork(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preReleaseClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(17, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preReleaseClientSession(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preReleaseConnection(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(23, this.getSession());
        event.setResult(accessor);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preReleaseConnection(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preReleaseExclusiveConnection(ClientSession clientSession, Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        SessionEvent event = new SessionEvent(34, clientSession);
        event.setResult(accessor);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preReleaseExclusiveConnection(event);
            ++index2;
        }
    }

    public void preReleaseUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(12, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preReleaseUnitOfWork(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preRollbackTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(7, this.getSession());
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preRollbackTransaction(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preDistributedMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(27, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preDistributedMergeUnitOfWorkChangeSet(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    public void preMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(26, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        List<SessionEventListener> listeners = this.listeners;
        int size2 = listeners.size();
        int index2 = 0;
        while (index2 < size2) {
            listeners.get(index2).preMergeUnitOfWorkChangeSet(event);
            ++index2;
        }
        this.endOperationProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SessionEventListener listener) {
        if (this.session != null) {
            boolean isRemoved = false;
            if (this.session.isConnected()) {
                SessionEventManager sessionEventManager = this;
                synchronized (sessionEventManager) {
                    ArrayList<SessionEventListener> listenersCopy;
                    if (this.listeners != null && (isRemoved = (listenersCopy = new ArrayList<SessionEventListener>(this.listeners)).remove(listener))) {
                        this.listeners = listenersCopy;
                    }
                }
            } else {
                isRemoved = this.getListeners().remove(listener);
            }
            if (this.session.isSessionBroker() && isRemoved) {
                for (AbstractSession memberSession : ((SessionBroker)this.session).getSessionsByName().values()) {
                    memberSession.getEventManager().removeListener(listener);
                }
            }
        } else {
            this.getListeners().remove(listener);
        }
    }

    protected void setListeners(List<SessionEventListener> listeners) {
        this.listeners = listeners;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    protected void startOperationProfile() {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().startOperationProfile("Timer:SessionEvents");
        }
    }

    protected void endOperationProfile() {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().endOperationProfile("Timer:SessionEvents");
        }
    }
}

