/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server;

import java.io.IOException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public class ServerLog
extends AbstractSessionLog {
    @Override
    public void log(SessionLogEntry entry2) {
        if (!this.shouldLog(entry2.getLevel())) {
            return;
        }
        String message = this.getSupplementDetailString(entry2);
        if (entry2.hasException()) {
            if (entry2.getLevel() == 7) {
                message = String.valueOf(message) + Helper.printStackTraceToString(entry2.getException());
            } else if (entry2.getLevel() <= 6) {
                message = this.shouldLogExceptionStackTrace() ? String.valueOf(message) + Helper.printStackTraceToString(entry2.getException()) : String.valueOf(message) + entry2.getException();
            }
        } else {
            message = String.valueOf(message) + this.formatMessage(entry2);
        }
        this.basicLog(entry2.getLevel(), entry2.getNameSpace(), message);
    }

    protected void basicLog(int level, String category, String message) {
        try {
            this.printPrefixString(level, null);
            this.getWriter().write(message);
            this.getWriter().write(Helper.cr());
            this.getWriter().flush();
        }
        catch (IOException exception) {
            throw ValidationException.logIOError(exception);
        }
    }
}

