/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class EISOneToManyQueryBasedValueHolder
extends QueryBasedValueHolder {
    private EISOneToManyMapping mapping;

    public EISOneToManyQueryBasedValueHolder(EISOneToManyMapping mapping, ReadQuery query, AbstractRecord sourceRow, AbstractSession session) {
        super(query, sourceRow, session);
        this.mapping = mapping;
    }

    @Override
    protected Object instantiate(AbstractSession session) throws DatabaseException {
        Vector rows = this.mapping.getForeignKeyRows(this.getRow(), session);
        int size2 = rows.size();
        ContainerPolicy cp = ((ReadAllQuery)this.getQuery()).getContainerPolicy();
        Object returnValue = cp.containerInstance(size2);
        int i = 0;
        while (i < size2) {
            Iterator<Object> iter2;
            AbstractRecord nextRow = (AbstractRecord)rows.get(i);
            Object results = session.executeQuery((DatabaseQuery)this.getQuery(), nextRow);
            if (results instanceof Collection) {
                iter2 = ((Collection)results).iterator();
                while (iter2.hasNext()) {
                    cp.addInto(iter2.next(), returnValue, session);
                }
            } else if (results instanceof Map) {
                iter2 = ((Map)results).values().iterator();
                while (iter2.hasNext()) {
                    cp.addInto(iter2.next(), returnValue, session);
                }
            } else {
                cp.addInto(results, returnValue, session);
            }
            ++i;
        }
        return returnValue;
    }
}

