/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class DynamicPropertiesInitializatonPolicy {
    public void initializeProperties(DynamicTypeImpl type, DynamicEntityImpl entity) {
        if (type != null) {
            for (DatabaseMapping mapping : type.getMappingsRequiringInitialization()) {
                this.initializeDefaultValue(mapping, entity);
            }
        }
    }

    private void initializeDefaultValue(DatabaseMapping mapping, DynamicEntityImpl entity) {
        Object value2 = null;
        if (mapping.isDirectToFieldMapping() && mapping.getAttributeClassification().isPrimitive()) {
            Class primClass = mapping.getAttributeClassification();
            if (primClass == ClassConstants.PBOOLEAN) {
                value2 = false;
            } else if (primClass == ClassConstants.PINT) {
                value2 = 0;
            } else if (primClass == ClassConstants.PLONG) {
                value2 = 0L;
            } else if (primClass == ClassConstants.PCHAR) {
                value2 = Character.valueOf('\u0000');
            } else if (primClass == ClassConstants.PDOUBLE) {
                value2 = 0.0;
            } else if (primClass == ClassConstants.PFLOAT) {
                value2 = Float.valueOf(0.0f);
            } else if (primClass == ClassConstants.PSHORT) {
                value2 = (short)Short.MIN_VALUE;
            } else if (primClass == ClassConstants.PBYTE) {
                value2 = (byte)-128;
            }
        } else if (mapping.isForeignReferenceMapping()) {
            ForeignReferenceMapping refMapping = (ForeignReferenceMapping)mapping;
            if (refMapping.usesIndirection() && refMapping.getIndirectionPolicy() instanceof BasicIndirectionPolicy) {
                value2 = new ValueHolder(value2);
            } else if (refMapping.isCollectionMapping()) {
                value2 = ((CollectionMapping)refMapping).getContainerPolicy().containerInstance();
            }
        } else if (mapping.isAggregateObjectMapping()) {
            value2 = mapping.getReferenceDescriptor().getObjectBuilder().buildNewInstance();
        }
        DynamicEntityImpl.PropertyWrapper propertyWrapper = entity.getPropertiesMap().get(mapping.getAttributeName());
        propertyWrapper.setValue(value2);
    }
}

