/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.lang.reflect.Method;
import java.util.Collection;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;

public class DescriptorException
extends ValidationException {
    protected transient ClassDescriptor descriptor;
    protected transient DatabaseMapping mapping;
    public static final int ATTRIBUTE_AND_MAPPING_WITH_INDIRECTION_MISMATCH = 1;
    public static final int ATTRIBUTE_AND_MAPPING_WITHOUT_INDIRECTION_MISMATCH = 2;
    public static final int ATTRIBUTE_NAME_NOT_SPECIFIED = 6;
    public static final int ATTRIBUTE_TYPE_NOT_VALID = 7;
    public static final int CLASS_INDICATOR_FIELD_NOT_FOUND = 8;
    public static final int DIRECT_FIELD_NAME_NOT_SET = 9;
    public static final int FIELD_NAME_NOT_SET_IN_MAPPING = 10;
    public static final int FOREIGN_KEYS_DEFINED_INCORRECTLY = 11;
    public static final int IDENTITY_MAP_NOT_SPECIFIED = 12;
    public static final int ILLEGAL_ACCESS_WHILE_GETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 13;
    public static final int ILLEGAL_ACCESS_WHILE_CLONING = 14;
    public static final int ILLEGAL_ACCESS_WHILE_CONSTRUCTOR_INSTANTIATION = 15;
    public static final int ILLEGAL_ACCESS_WHILE_EVENT_EXECUTION = 16;
    public static final int ILLEGAL_ACCESS_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 17;
    public static final int ILLEGAL_ACCESS_WHILE_INSTANTIATING_METHOD_BASED_PROXY = 18;
    public static final int ILLEGAL_ACCESS_WHILE_INVOKING_ATTRIBUTE_METHOD = 19;
    public static final int ILLEGAL_ACCESS_WHILE_INVOKING_FIELD_TO_METHOD = 20;
    public static final int ILLEGAL_ACCESS_WHILE_INVOKING_ROW_EXTRACTION_METHOD = 21;
    public static final int ILLEGAL_ACCESS_WHILE_METHOD_INSTANTIATION = 22;
    public static final int ILLEGAL_ACCESS_WHILE_OBSOLETE_EVENT_EXECUTION = 23;
    public static final int ILLEGAL_ACCESS_WHILE_SETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 24;
    public static final int ILLEGAL_ACCESS_WHILE_SETTING_VALUE_THRU_METHOD_ACCESSOR = 25;
    public static final int ILLEGAL_ARGUMENT_WHILE_GETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 26;
    public static final int ILLEGAL_ARGUMENT_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 27;
    public static final int ILLEGAL_ARGUMENT_WHILE_INSTANTIATING_METHOD_BASED_PROXY = 28;
    public static final int ILLEGAL_ARGUMENT_WHILE_INVOKING_ATTRIBUTE_METHOD = 29;
    public static final int ILLEGAL_ARGUMENT_WHILE_INVOKING_FIELD_TO_METHOD = 30;
    public static final int ILLEGAL_ARGUMENT_WHILE_OBSOLETE_EVENT_EXECUTION = 31;
    public static final int ILLEGAL_ARGUMENT_WHILE_SETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 32;
    public static final int ILLEGAL_ARGUMENT_WHILE_SETTING_VALUE_THRU_METHOD_ACCESSOR = 33;
    public static final int INSTANTIATION_WHILE_CONSTRUCTOR_INSTANTIATION = 34;
    public static final int INVALID_DATA_MODIFICATION_EVENT = 35;
    public static final int INVALID_DATA_MODIFICATION_EVENT_CODE = 36;
    public static final int INVALID_DESCRIPTOR_EVENT_CODE = 37;
    public static final int INVALID_IDENTITY_MAP = 38;
    public static final int JAVA_CLASS_NOT_SPECIFIED = 39;
    public static final int DESCRIPTOR_FOR_INTERFACE_IS_MISSING = 40;
    public static final int MAPPING_FOR_SEQUENCE_NUMBER_FIELD = 41;
    public static final int MISSING_CLASS_FOR_INDICATOR_FIELD_VALUE = 43;
    public static final int MISSING_CLASS_INDICATOR_FIELD = 44;
    public static final int MISSING_MAPPING_FOR_FIELD = 45;
    public static final int NO_MAPPING_FOR_PRIMARY_KEY = 46;
    public static final int MULTIPLE_TABLE_PRIMARY_KEY_NOT_SPECIFIED = 47;
    public static final int MULTIPLE_WRITE_MAPPINGS_FOR_FIELD = 48;
    public static final int NO_ATTRIBUTE_TRANSFORMATION_METHOD = 49;
    public static final int NO_FIELD_NAME_FOR_MAPPING = 50;
    public static final int NO_FOREIGN_KEYS_ARE_SPECIFIED = 51;
    public static final int NO_REFERENCE_KEY_IS_SPECIFIED = 52;
    public static final int NO_RELATION_TABLE = 53;
    public static final int NO_SOURCE_RELATION_KEYS_SPECIFIED = 54;
    public static final int NO_SUCH_METHOD_ON_FIND_OBSOLETE_METHOD = 55;
    public static final int NO_SUCH_METHOD_ON_INITIALIZING_ATTRIBUTE_METHOD = 56;
    public static final int NO_SUCH_METHOD_WHILE_CONSTRUCTOR_INSTANTIATION = 57;
    public static final int NO_SUCH_METHOD_WHILE_CONVERTING_TO_METHOD = 58;
    public static final int NO_SUCH_FIELD_WHILE_INITIALIZING_ATTRIBUTES_IN_INSTANCE_VARIABLE_ACCESSOR = 59;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_ATTRIBUTES_IN_METHOD_ACCESSOR = 60;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_CLASS_EXTRACTION_METHOD = 61;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_COPY_POLICY = 62;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_INSTANTIATION_POLICY = 63;
    public static final int NO_TARGET_FOREIGN_KEYS_SPECIFIED = 64;
    public static final int NO_TARGET_RELATION_KEYS_SPECIFIED = 65;
    public static final int NOT_DESERIALIZABLE = 66;
    public static final int NOT_SERIALIZABLE = 67;
    public static final int NULL_FOR_NON_NULL_AGGREGATE = 68;
    public static final int NULL_POINTER_WHILE_GETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 69;
    public static final int NULL_POINTER_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 70;
    public static final int NULL_POINTER_WHILE_SETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 71;
    public static final int NULL_POINTER_WHILE_SETTING_VALUE_THRU_METHOD_ACCESSOR = 72;
    public static final int PARENT_DESCRIPTOR_NOT_SPECIFIED = 73;
    public static final int PRIMARY_KEY_FIELDS_NOT_SPECIFIED = 74;
    public static final int REFERENCE_CLASS_NOT_SPECIFIED = 75;
    public static final int REFERENCE_DESCRIPTOR_IS_NOT_AGGREGATE = 77;
    public static final int REFERENCE_KEY_FIELD_NOT_PROPERLY_SPECIFIED = 78;
    public static final int REFERENCE_TABLE_NOT_SPECIFIED = 79;
    public static final int RELATION_KEY_FIELD_NOT_PROPERLY_SPECIFIED = 80;
    public static final int RETURN_TYPE_IN_GET_ATTRIBUTE_ACCESSOR = 81;
    public static final int SECURITY_ON_FIND_METHOD = 82;
    public static final int SECURITY_ON_FIND_OBSOLETE_METHOD = 83;
    public static final int SECURITY_ON_INITIALIZING_ATTRIBUTE_METHOD = 84;
    public static final int SECURITY_WHILE_CONVERTING_TO_METHOD = 85;
    public static final int SECURITY_WHILE_INITIALIZING_ATTRIBUTES_IN_INSTANCE_VARIABLE_ACCESSOR = 86;
    public static final int SECURITY_WHILE_INITIALIZING_ATTRIBUTES_IN_METHOD_ACCESSOR = 87;
    public static final int SECURITY_WHILE_INITIALIZING_CLASS_EXTRACTION_METHOD = 88;
    public static final int SECURITY_WHILE_INITIALIZING_COPY_POLICY = 89;
    public static final int SECURITY_WHILE_INITIALIZING_INSTANTIATION_POLICY = 90;
    public static final int SEQUENCE_NUMBER_PROPERTY_NOT_SPECIFIED = 91;
    public static final int SIZE_MISMATCH_OF_FOREIGN_KEYS = 92;
    public static final int TABLE_NOT_PRESENT = 93;
    public static final int TABLE_NOT_SPECIFIED = 94;
    public static final int TARGET_FOREIGN_KEYS_SIZE_MISMATCH = 96;
    public static final int TARGET_INVOCATION_WHILE_CLONING = 97;
    public static final int TARGET_INVOCATION_WHILE_EVENT_EXECUTION = 98;
    public static final int TARGET_INVOCATION_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 99;
    public static final int TARGET_INVOCATION_WHILE_INSTANTIATING_METHOD_BASED_PROXY = 100;
    public static final int TARGET_INVOCATION_WHILE_INVOKING_ATTRIBUTE_METHOD = 101;
    public static final int TARGET_INVOCATION_WHILE_INVOKING_FIELD_TO_METHOD = 102;
    public static final int TARGET_INVOCATION_WHILE_INVOKING_ROW_EXTRACTION_METHOD = 103;
    public static final int TARGET_INVOCATION_WHILE_METHOD_INSTANTIATION = 104;
    public static final int TARGET_INVOCATION_WHILE_OBSOLETE_EVENT_EXECUTION = 105;
    public static final int TARGET_INVOCATION_WHILE_SETTING_VALUE_THRU_METHOD_ACESSOR = 106;
    public static final int VALUE_NOT_FOUND_IN_CLASS_INDICATOR_MAPPING = 108;
    public static final int WRITE_LOCK_FIELD_IN_CHILD_DESCRIPTOR = 109;
    public static final int DESCRIPTOR_IS_MISSING = 110;
    public static final int MULTIPLE_TABLE_PRIMARY_KEY_MUST_BE_FULLY_QUALIFIED = 111;
    public static final int ONLY_ONE_TABLE_CAN_BE_ADDED_WITH_THIS_METHOD = 112;
    public static final int NULL_POINTER_WHILE_CONSTRUCTOR_INSTANTIATION = 113;
    public static final int NULL_POINTER_WHILE_METHOD_INSTANTIATION = 114;
    public static final int NO_ATTRBUTE_VALUE_CONVERSION_TO_FIELD_VALUE_PROVIDED = 115;
    public static final int NO_FIELD_VALUE_CONVERSION_TO_ATTRIBUTE_VALUE_PROVIDED = 116;
    public static final int LOCK_MAPPING_CANNOT_BE_READONLY = 118;
    public static final int LOCK_MAPPING_MUST_BE_READONLY = 119;
    public static final int CHILD_DOES_NOT_DEFINE_ABSTRACT_QUERY_KEY = 120;
    public static final int SET_EXISTENCE_CHECKING_NOT_UNDERSTOOD = 122;
    public static final int VALUE_HOLDER_INSTANTIATION_MISMATCH = 125;
    public static final int NO_SUB_CLASS_MATCH = 126;
    public static final int RETURN_AND_MAPPING_WITH_INDIRECTION_MISMATCH = 127;
    public static final int RETURN_AND_MAPPING_WITHOUT_INDIRECTION_MISMATCH = 128;
    public static final int PARAMETER_AND_MAPPING_WITH_INDIRECTION_MISMATCH = 129;
    public static final int PARAMETER_AND_MAPPING_WITHOUT_INDIRECTION_MISMATCH = 130;
    public static final int GET_METHOD_RETURN_TYPE_NOT_VALID = 131;
    public static final int SET_METHOD_PARAMETER_TYPE_NOT_VALID = 133;
    public static final int ILLEGAL_TABLE_NAME_IN_MULTIPLE_TABLE_FOREIGN_KEY = 135;
    public static final int ATTRIBUTE_AND_MAPPING_WITH_TRANSPARENT_INDIRECTION_MISMATCH = 138;
    public static final int RETURN_AND_MAPPING_WITH_TRANSPARENT_INDIRECTION_MISMATCH = 139;
    public static final int PARAMETER_AND_MAPPING_WITH_TRANSPARENT_INDIRECTION_MISMATCH = 140;
    public static final int FIELD_IS_NOT_PRESENT_IN_DATABASE = 141;
    public static final int TABLE_IS_NOT_PRESENT_IN_DATABASE = 142;
    public static final int MULTIPLE_TABLE_INSERT_ORDER_MISMATCH = 143;
    public static final int INVALID_USE_OF_TRANSPARENT_INDIRECTION = 144;
    public static final int MISSING_INDIRECT_CONTAINER_CONSTRUCTOR = 145;
    public static final int COULD_NOT_INSTANTIATE_INDIRECT_CONTAINER_CLASS = 146;
    public static final int INVALID_CONTAINER_POLICY = 147;
    public static final int INVALID_CONTAINER_POLICY_WITH_TRANSPARENT_INDIRECTION = 148;
    public static final int INVALID_USE_OF_NO_INDIRECTION = 149;
    public static final int INDIRECT_CONTAINER_INSTANTIATION_MISMATCH = 150;
    public static final int INVALID_MAPPING_OPERATION = 151;
    public static final int INVALID_INDIRECTION_POLICY_OPERATION = 152;
    public static final int REFERENCE_DESCRIPTOR_IS_NOT_AGGREGATECOLLECTION = 153;
    public static final int INVALID_INDIRECTION_CONTAINER_CLASS = 154;
    public static final int MISSING_FOREIGN_KEY_TRANSLATION = 155;
    public static final int STRUCTURE_NAME_NOT_SET_IN_MAPPING = 156;
    public static final int NORMAL_DESCRIPTORS_DO_NOT_SUPPORT_NON_RELATIONAL_EXTENSIONS = 157;
    public static final int PARENT_CLASS_IS_SELF = 158;
    public static final int PROXY_INDIRECTION_NOT_AVAILABLE = 159;
    public static final int INVALID_ATTRIBUTE_TYPE_FOR_PROXY_INDIRECTION = 160;
    public static final int INVALID_GET_RETURN_TYPE_FOR_PROXY_INDIRECTION = 161;
    public static final int INVALID_SET_PARAMETER_TYPE_FOR_PROXY_INDIRECTION = 162;
    public static final int INCORRECT_COLLECTION_POLICY = 163;
    public static final int INVALID_AMENDMENT_METHOD = 164;
    public static final int ERROR_OCCURED_IN_AMENDMENT_METHOD = 165;
    public static final int VARIABLE_ONE_TO_ONE_MAPPING_IS_NOT_DEFINED = 166;
    public static final int NO_CONSTRUCTOR_INDIRECT_COLLECTION_CLASS = 167;
    public static final int TARGET_INVOCATION_WHILE_CONSTRUCTOR_INSTANTIATION = 168;
    public static final int TARGET_INVOCATION_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 169;
    public static final int ILLEGAL_ACCESS_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 170;
    public static final int INSTANTIATION_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 171;
    public static final int NO_SUCH_METHOD_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 172;
    public static final int NULL_POINTER_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 173;
    public static final int ILLEGAL_ACCESS_WHILE_METHOD_INSTANTIATION_OF_FACTORY = 174;
    public static final int TARGET_INVOCATION_WHILE_METHOD_INSTANTIATION_OF_FACTORY = 175;
    public static final int NULL_POINTER_WHILE_METHOD_INSTANTIATION_OF_FACTORY = 176;
    public static final int NO_MAPPING_FOR_ATTRIBUTENAME = 177;
    public static final int NO_MAPPING_FOR_ATTRIBUTENAME_IN_ENTITY_BEAN = 178;
    public static final int UNSUPPORTED_TYPE_FOR_BIDIRECTIONAL_RELATIONSHIP_MAINTENANCE = 179;
    public static final int REFERENCE_DESCRIPTOR_CANNOT_BE_AGGREGATE = 180;
    public static final int ATTRIBUTE_TRANSFORMER_CLASS_NOT_FOUND = 181;
    public static final int FIELD_TRANSFORMER_CLASS_NOT_FOUND = 182;
    public static final int ATTRIBUTE_TRANSFORMER_CLASS_INVALID = 183;
    public static final int FIELD_TRANSFORMER_CLASS_INVALID = 184;
    public static final int RETURNING_POLICY_FIELD_TYPE_CONFLICT = 185;
    public static final int RETURNING_POLICY_FIELD_INSERT_CONFLICT = 186;
    public static final int RETURNING_POLICY_AND_DESCRIPTOR_FIELD_TYPE_CONFLICT = 187;
    public static final int RETURNING_POLICY_UNMAPPED_FIELD_TYPE_NOT_SET = 188;
    public static final int RETURNING_POLICY_MAPPED_FIELD_TYPE_NOT_SET = 189;
    public static final int RETURNING_POLICY_MAPPING_NOT_SUPPORTED = 190;
    public static final int RETURNING_POLICY_FIELD_NOT_SUPPORTED = 191;
    public static final int CUSTOM_QUERY_AND_RETURNING_POLICY_CONFLICT = 192;
    public static final int NO_CUSTOM_QUERY_FOR_RETURNING_POLICY = 193;
    public static final int CLASS_EXTRACTION_METHOD_MUST_BE_STATIC = 194;
    public static final int ISOLATED_DESCRIPTOR_REFERENCED_BY_SHARED_DESCRIPTOR = 195;
    public static final int UPDATE_ALL_FIELDS_NOT_SET = 196;
    public static final int INVALID_MAPPING_TYPE = 197;
    public static final int NEED_TO_IMPLEMENT_CHANGETRACKER = 198;
    public static final int NEED_TO_IMPLEMENT_FETCHGROUPTRACKER = 199;
    public static final int ATTEMPT_TO_REGISTER_DEAD_INDIRECTION = 200;
    public static final int UNIT_OF_WORK_ISOLATED_OBJECTS_ACCESSED_IN_SESSION = 201;
    public static final int INTERNAL_ERROR_ACCESSING_PKFIELD = 202;
    public static final int INTERNAL_ERROR_SET_METHOD = 203;
    public static final int INSERT_ORDER_CONFLICTS_WITH_MULTIPLE_TABLE_FOREIGN_KEYS = 204;
    public static final int INSERT_ORDER_CYCLICAL_DEPENDENCY_BETWEEN_TWO_TABLES = 205;
    public static final int INSERT_ORDER_CYCLICAL_DEPENDENCY_BETWEEN_THREE_OR_MORE_TABLES = 206;
    public static final int INSERT_ORDER_CHILD_BEFORE_PARENT = 207;
    public static final int CANNOT_SET_CONVERTER_FOR_NON_DIRECT_MAPPING = 208;
    public static final int DIRECT_KEY_NOT_SET = 209;
    public static final int LIST_ORDER_FIELD_REQUIRES_LIST = 210;
    public static final int LIST_ORDER_FIELD_REQUIRES_INDIRECT_LIST = 211;
    public static final int LIST_ORDER_FIELD_TABLE_IS_WRONG = 212;
    public static final int MULTIPLE_TARGET_FOREIGN_KEY_TABLES = 213;
    public static final int ONE_TO_ONE_MAPPING_CONFLICT = 214;
    public static final int NO_RELATION_TABLE_MECHANISM = 215;
    public static final int CANNOT_USE_ID_VALUE_FOR_COMPOSITE_ID = 216;
    public static final int INVALID_XPATH_FOR_DIRECT_MAPPING = 217;
    public static final int NULL_POINTER_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR_IN_MODULE_ORDER_BREAKS_WEAVING = 218;
    public static final int ADDITIONAL_CRITERIA_NOT_SUPPORTED_WITH_INHERITANCE_VIEWS = 219;
    public static final int MISSING_PARTITION_POLICY = 220;
    public static final int SERIALIZED_OBJECT_POLICY_FIELD_NOT_SET = 221;
    public static final int EXCEPTION_ACCESSING_PRIMARY_KEY_INSTANCE = 222;

    protected DescriptorException(String theMessage) {
        super(theMessage);
    }

    protected DescriptorException(String theMessage, DatabaseMapping mapping) {
        this(theMessage);
        if (mapping != null) {
            this.mapping = mapping;
            this.descriptor = mapping.getDescriptor();
        }
    }

    protected DescriptorException(String theMessage, ClassDescriptor descriptor) {
        this(theMessage);
        this.descriptor = descriptor;
    }

    protected DescriptorException(String theMessage, ClassDescriptor descriptor, Throwable exception) {
        this(theMessage, descriptor);
        this.setInternalException(exception);
    }

    public static DescriptorException additionalCriteriaNotSupportedWithInheritanceViews(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 219, args), descriptor);
        exception.setErrorCode(219);
        return exception;
    }

    public static DescriptorException attemptToRegisterDeadIndirection(Object object, DatabaseMapping mapping) {
        Object[] args = new Object[]{object};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 200, args), mapping);
        exception.setErrorCode(200);
        return exception;
    }

    public static DescriptorException attributeAndMappingWithIndirectionMismatch(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 1, args), mapping);
        exception.setErrorCode(1);
        return exception;
    }

    public static DescriptorException attributeAndMappingWithoutIndirectionMismatch(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 2, args), mapping);
        exception.setErrorCode(2);
        return exception;
    }

    public static DescriptorException attributeAndMappingWithTransparentIndirectionMismatch(DatabaseMapping mapping, Class parameterType, String validTypeName) {
        Object[] args = new Object[]{mapping.getAttributeName(), parameterType, validTypeName};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 138, args), mapping);
        exception.setErrorCode(138);
        return exception;
    }

    public static DescriptorException attributeNameNotSpecified() {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 6, args));
        descriptorException.setErrorCode(6);
        return descriptorException;
    }

    public static DescriptorException attributeTransformerClassNotFound(String className, AbstractTransformationMapping mapping, Exception exception) {
        Object[] args = new Object[]{className};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 181, args));
        descriptorException.setErrorCode(181);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException attributeTransformerClassInvalid(String className, AbstractTransformationMapping mapping, Exception exception) {
        Object[] args = new Object[]{className};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 183, args));
        descriptorException.setErrorCode(183);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException attributeTypeNotValid(CollectionMapping mapping, Class interfaceType) {
        Object[] args = new Object[]{mapping.getAttributeName(), interfaceType};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 7, args), mapping);
        exception.setErrorCode(7);
        return exception;
    }

    public static DescriptorException childDoesNotDefineAbstractQueryKeyOfParent(ClassDescriptor child, ClassDescriptor parent, String queryKeyName) {
        Object[] args = new Object[]{queryKeyName, parent, child};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 120, args));
        descriptorException.setErrorCode(120);
        return descriptorException;
    }

    public static DescriptorException classIndicatorFieldNotFound(ClassDescriptor parentDescriptor, ClassDescriptor descriptor) {
        Object[] args = new Object[]{descriptor, parentDescriptor, CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 8, args), descriptor);
        descriptorException.setErrorCode(8);
        return descriptorException;
    }

    public static DescriptorException couldNotInstantiateIndirectContainerClass(Class containerClass, Exception exception) {
        Object[] args = new Object[]{containerClass, Helper.getShortClassName(containerClass)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 146, args));
        descriptorException.setErrorCode(146);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException descriptorForInterfaceIsMissing(String interfaceName) {
        Object[] args = new Object[]{interfaceName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 40, args));
        descriptorException.setErrorCode(40);
        return descriptorException;
    }

    public static DescriptorException descriptorIsMissing(String className, DatabaseMapping mapping) {
        Object[] args = new Object[]{className};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 110, args), mapping);
        descriptorException.setErrorCode(110);
        return descriptorException;
    }

    public static DescriptorException directFieldNameNotSet(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 9, args), mapping);
        descriptorException.setErrorCode(9);
        return descriptorException;
    }

    public static DescriptorException errorAccessingSetMethodOfEntity(Class aClass, String methodName, ClassDescriptor descriptor, Exception underlying) {
        Object[] args = new Object[]{aClass, methodName};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 203, args), descriptor, underlying);
        return exception;
    }

    public static DescriptorException errorOccuredInAmendmentMethod(Class amendmentClass, String method, Exception exception, ClassDescriptor descriptor) {
        Object[] args = new Object[]{amendmentClass, method};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 165, args), descriptor, exception);
        descriptorException.setErrorCode(165);
        return descriptorException;
    }

    public static DescriptorException fieldIsNotPresentInDatabase(ClassDescriptor descriptor, String tableName, String fieldName) {
        Object[] args = new Object[]{fieldName, tableName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 141, args), descriptor);
        descriptorException.setErrorCode(141);
        return descriptorException;
    }

    public static DescriptorException fieldNameNotSetInMapping(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 10, args), mapping);
        descriptorException.setErrorCode(10);
        return descriptorException;
    }

    public static DescriptorException fieldTransformerClassNotFound(String className, AbstractTransformationMapping mapping, Exception exception) {
        Object[] args = new Object[]{className};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 182, args));
        descriptorException.setErrorCode(182);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException fieldTransformerClassInvalid(String className, AbstractTransformationMapping mapping, Exception exception) {
        Object[] args = new Object[]{className};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 184, args));
        descriptorException.setErrorCode(182);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException foreignKeysDefinedIncorrectly(ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 11, args), mapping);
        descriptorException.setErrorCode(11);
        return descriptorException;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMessage() {
        if (this.getDescriptor() == null) {
            return super.getMessage();
        }
        if (this.getMapping() != null) {
            return String.valueOf(super.getMessage()) + DescriptorException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("MappingHeader") + this.getMapping().toString() + DescriptorException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("DescriptorHeader") + this.getDescriptor().toString();
        }
        return String.valueOf(super.getMessage()) + DescriptorException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("DescriptorHeader") + this.getDescriptor().toString();
    }

    public static DescriptorException getMethodReturnTypeNotValid(CollectionMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 131, args), mapping);
        exception.setErrorCode(131);
        return exception;
    }

    public static DescriptorException identityMapNotSpecified(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 12, args), descriptor);
        descriptorException.setErrorCode(12);
        return descriptorException;
    }

    public static DescriptorException illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(String attributeName, String objectName, Throwable exception) {
        Object[] args = new Object[]{attributeName, objectName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 13, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(13);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileCloning(Object domainObject, String methodName, ClassDescriptor descriptor, Throwable exception) {
        Object[] args = new Object[]{domainObject, methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 14, args), descriptor, exception);
        descriptorException.setErrorCode(14);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileConstructorInstantiation(ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 15, args), descriptor, exception);
        descriptorException.setErrorCode(15);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileConstructorInstantiationOfFactory(ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 170, args), descriptor, exception);
        descriptorException.setErrorCode(170);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileEventExecution(String eventMethodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{eventMethodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 16, args), descriptor, exception);
        descriptorException.setErrorCode(16);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileGettingValueThruMethodAccessor(String methodName, String objectName, Throwable exception) {
        Object[] args = new Object[]{methodName, objectName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 17, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(17);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInstantiatingMethodBasedProxy(Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 18, args));
        descriptorException.setErrorCode(18);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInvokingAttributeMethod(DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 19, args));
        descriptorException.setErrorCode(19);
        descriptorException.setInternalException(exception);
        descriptorException.setMapping(mapping);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInvokingFieldToMethod(String methodName, DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 20, args));
        descriptorException.setErrorCode(20);
        descriptorException.setInternalException(exception);
        descriptorException.setMapping(mapping);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInvokingRowExtractionMethod(AbstractRecord row, Method method, ClassDescriptor descriptor, Throwable exception) {
        Object[] args = new Object[]{row, method};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 21, args), descriptor, exception);
        descriptorException.setErrorCode(21);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileMethodInstantiation(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 22, args), descriptor, exception);
        descriptorException.setErrorCode(22);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileMethodInstantiationOfFactory(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 174, args), descriptor, exception);
        descriptorException.setErrorCode(174);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileObsoleteEventExecute(String eventMethodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{eventMethodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 23, args), descriptor, exception);
        descriptorException.setErrorCode(23);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileSettingValueThruInstanceVariableAccessor(String attributeName, String objectName, Object objectValue, Throwable exception) {
        Object[] args = new Object[]{attributeName, objectName, String.valueOf(objectValue), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 24, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(24);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileSettingValueThruMethodAccessor(String setMethodName, Object value2, Throwable exception) {
        Object[] args = new Object[]{setMethodName, String.valueOf(value2)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 25, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(25);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileGettingValueThruInstanceVariableAccessor(String attributeName, String typeName, String objectName, Throwable exception) {
        Object[] args = new Object[]{attributeName, typeName, objectName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 26, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(26);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileGettingValueThruMethodAccessor(String methodName, String objectName, Throwable exception) {
        Object[] args = new Object[]{methodName, objectName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 27, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(27);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileInstantiatingMethodBasedProxy(Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 28, args));
        descriptorException.setErrorCode(28);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileInvokingAttributeMethod(DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 29, args));
        descriptorException.setErrorCode(29);
        descriptorException.setInternalException(exception);
        descriptorException.setMapping(mapping);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileInvokingFieldToMethod(String methodName, DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 30, args));
        descriptorException.setInternalException(exception);
        descriptorException.setMapping(mapping);
        descriptorException.setErrorCode(30);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileObsoleteEventExecute(String eventMethodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{eventMethodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 31, args), descriptor, exception);
        descriptorException.setErrorCode(31);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileSettingValueThruInstanceVariableAccessor(String attributeName, String typeName, Object value2, Throwable exception) {
        Object[] args = new Object[]{String.valueOf(value2), attributeName, typeName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 32, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(32);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileSettingValueThruMethodAccessor(String setMethodName, Object value2, Throwable exception) {
        Object[] args = new Object[]{setMethodName, String.valueOf(value2)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 33, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(33);
        return descriptorException;
    }

    public static DescriptorException illegalTableNameInMultipleTableForeignKeyField(ClassDescriptor descriptor, DatabaseTable table) {
        Object[] args = new Object[]{table};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 135, args), descriptor);
        descriptorException.setErrorCode(135);
        return descriptorException;
    }

    public static DescriptorException incorrectCollectionPolicy(DatabaseMapping mapping, Class attributeClass, Class containerClass) {
        Object[] args = new Object[]{attributeClass, containerClass};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 163, args), mapping);
        descriptorException.setErrorCode(163);
        return descriptorException;
    }

    public static DescriptorException indirectContainerInstantiationMismatch(Object attributeValue, DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName(), attributeValue, CR};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 150, args), mapping);
        exception.setErrorCode(150);
        return exception;
    }

    public static DescriptorException instantiationWhileConstructorInstantiation(ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 34, args), descriptor, exception);
        descriptorException.setErrorCode(34);
        return descriptorException;
    }

    public static DescriptorException instantiationWhileConstructorInstantiationOfFactory(ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 171, args), descriptor, exception);
        descriptorException.setErrorCode(171);
        return descriptorException;
    }

    public static DescriptorException invalidAmendmentMethod(Class amendmentClass, String method, Exception exception, ClassDescriptor descriptor) {
        Object[] args = new Object[]{amendmentClass, method, CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 164, args), descriptor, exception);
        descriptorException.setErrorCode(164);
        return descriptorException;
    }

    public static DescriptorException invalidAttributeTypeForProxyIndirection(Class attributeType, Class[] targetInterfaces, DatabaseMapping mapping) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < targetInterfaces.length) {
            buffer.append(targetInterfaces[i].getName());
            if (i != targetInterfaces.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        Object[] args = new Object[]{mapping.getAttributeName(), mapping.getDescriptor().getJavaClass().getName(), attributeType.getName(), buffer.toString(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 160, args), mapping);
        descriptorException.setErrorCode(160);
        return descriptorException;
    }

    public static DescriptorException invalidContainerPolicy(ContainerPolicy containerPolicy, Class javaClass) {
        Object[] args = new Object[]{containerPolicy, javaClass};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 147, args));
        exception.setErrorCode(147);
        return exception;
    }

    public static DescriptorException invalidContainerPolicyWithTransparentIndirection(DatabaseMapping mapping, ContainerPolicy containerPolicy) {
        Object[] args = new Object[]{containerPolicy};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 148, args), mapping);
        exception.setErrorCode(148);
        return exception;
    }

    public static DescriptorException invalidDataModificationEvent(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 35, args), mapping);
        descriptorException.setErrorCode(35);
        return descriptorException;
    }

    public static DescriptorException invalidDataModificationEventCode(Object event, ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{event};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 36, args), mapping);
        descriptorException.setErrorCode(36);
        return descriptorException;
    }

    public static DescriptorException invalidDescriptorEventCode(DescriptorEvent event, ClassDescriptor descriptor) {
        Object[] args = new Object[]{event.getEventCode()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 37, args), descriptor);
        descriptorException.setErrorCode(37);
        return descriptorException;
    }

    public static DescriptorException invalidGetMethodReturnTypeForProxyIndirection(Class attributeType, Class[] targetInterfaces, DatabaseMapping mapping) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < targetInterfaces.length) {
            buffer.append(targetInterfaces[i].getName());
            if (i != targetInterfaces.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        Object[] args = new Object[]{mapping.getGetMethodName(), mapping.getDescriptor().getJavaClass().getName(), attributeType.getName(), buffer.toString(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 161, args), mapping);
        descriptorException.setErrorCode(161);
        return descriptorException;
    }

    public static DescriptorException invalidIdentityMap(ClassDescriptor descriptor, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 38, args), descriptor, exception);
        descriptorException.setErrorCode(38);
        return descriptorException;
    }

    public static DescriptorException invalidIndirectionContainerClass(ContainerIndirectionPolicy policy, Class containerClass) {
        Object[] args = new Object[]{containerClass};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 154, args), policy.getMapping());
        descriptorException.setErrorCode(154);
        return descriptorException;
    }

    public static DescriptorException invalidIndirectionPolicyOperation(IndirectionPolicy policy, String operation) {
        Object[] args = new Object[]{policy, operation};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 152, args), policy.getMapping());
        descriptorException.setErrorCode(152);
        return descriptorException;
    }

    public static DescriptorException invalidMappingOperation(DatabaseMapping mapping, String operation) {
        Object[] args = new Object[]{operation};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 151, args), mapping);
        descriptorException.setErrorCode(151);
        return descriptorException;
    }

    public static DescriptorException invalidSetMethodParameterTypeForProxyIndirection(Class attributeType, Class[] targetInterfaces, DatabaseMapping mapping) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < targetInterfaces.length) {
            buffer.append(targetInterfaces[i].getName());
            if (i != targetInterfaces.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        Object[] args = new Object[]{mapping.getSetMethodName(), mapping.getDescriptor().getJavaClass().getName(), attributeType.getName(), buffer.toString(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 162, args), mapping);
        descriptorException.setErrorCode(162);
        return descriptorException;
    }

    public static DescriptorException invalidUseOfNoIndirection(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 149, args), mapping);
        exception.setErrorCode(149);
        return exception;
    }

    public static DescriptorException invalidUseOfTransparentIndirection(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        String message = ExceptionMessageGenerator.buildMessage(DescriptorException.class, 144, args);
        DescriptorException exception = new DescriptorException(message, mapping);
        exception.setErrorCode(144);
        return exception;
    }

    public static DescriptorException isolateDescriptorReferencedBySharedDescriptor(String referenceClass, String sourceClass, DatabaseMapping mapping) {
        Object[] args = new Object[]{referenceClass, sourceClass};
        String message = ExceptionMessageGenerator.buildMessage(DescriptorException.class, 195, args);
        DescriptorException exception = new DescriptorException(message, mapping);
        exception.setErrorCode(195);
        return exception;
    }

    public static DescriptorException javaClassNotSpecified(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 39, args), descriptor);
        descriptorException.setErrorCode(39);
        return descriptorException;
    }

    public static DescriptorException mappingCanNotBeReadOnly(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getDescriptor().getJavaClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 118, args), mapping);
        descriptorException.setErrorCode(118);
        return descriptorException;
    }

    public static DescriptorException mappingForSequenceNumberField(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 41, args));
        descriptorException.setErrorCode(41);
        descriptorException.setDescriptor(descriptor);
        return descriptorException;
    }

    public static DescriptorException missingClassForIndicatorFieldValue(Object classFieldValue, ClassDescriptor descriptor) {
        Object[] args = new Object[]{classFieldValue, classFieldValue.getClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 43, args), descriptor);
        descriptorException.setErrorCode(43);
        return descriptorException;
    }

    public static DescriptorException missingClassIndicatorField(AbstractRecord row, ClassDescriptor descriptor) {
        Object[] args = new Object[]{row};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 44, args), descriptor);
        descriptorException.setErrorCode(44);
        return descriptorException;
    }

    public static DescriptorException missingClassIndicatorField(XMLRecord row, ClassDescriptor descriptor) {
        Object[] args = new Object[]{row};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 44, args), descriptor);
        descriptorException.setErrorCode(44);
        return descriptorException;
    }

    public static DescriptorException missingForeignKeyTranslation(ForeignReferenceMapping mapping, DatabaseField primaryKeyField) {
        Object[] args = new Object[]{primaryKeyField};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 155, args), mapping);
        exception.setErrorCode(155);
        return exception;
    }

    public static DescriptorException missingIndirectContainerConstructor(Class containerClass) {
        Object[] args = new Object[]{containerClass.getName(), String.valueOf(containerClass.getName()) + "()"};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 145, args));
        exception.setErrorCode(145);
        return exception;
    }

    public static DescriptorException missingMappingForField(DatabaseField field2, ClassDescriptor descriptor) {
        Object[] args = new Object[]{field2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 45, args));
        descriptorException.setErrorCode(45);
        descriptorException.setDescriptor(descriptor);
        return descriptorException;
    }

    public static DescriptorException multipleTableInsertOrderMismatch(ClassDescriptor aDescriptor) {
        Object[] args = new Object[]{aDescriptor.getMultipleTableInsertOrder(), aDescriptor.getTables(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 143, args));
        descriptorException.setErrorCode(143);
        descriptorException.setDescriptor(aDescriptor);
        return descriptorException;
    }

    public static DescriptorException multipleTablePrimaryKeyMustBeFullyQualified(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 111, args), descriptor);
        descriptorException.setErrorCode(111);
        return descriptorException;
    }

    public static DescriptorException multipleTablePrimaryKeyNotSpecified(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 47, args), descriptor);
        descriptorException.setErrorCode(47);
        return descriptorException;
    }

    public static DescriptorException multipleWriteMappingsForField(String fieldName, DatabaseMapping mapping) {
        Object[] args = new Object[]{fieldName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 48, args), mapping);
        descriptorException.setErrorCode(48);
        return descriptorException;
    }

    public static DescriptorException mustBeReadOnlyMappingWhenStoredInCache(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getDescriptor().getJavaClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 119, args), mapping);
        descriptorException.setErrorCode(119);
        return descriptorException;
    }

    public static DescriptorException noAttributeTransformationMethod(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 49, args), mapping);
        descriptorException.setErrorCode(49);
        return descriptorException;
    }

    public static DescriptorException noAttributeValueConversionToFieldValueProvided(Object attributeValue, DatabaseMapping mapping) {
        Object[] args = new Object[]{attributeValue};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 115, args), mapping);
        descriptorException.setErrorCode(115);
        return descriptorException;
    }

    public static DescriptorException noConstructorIndirectionContainerClass(ContainerIndirectionPolicy policy, Class containerClass) {
        Object[] args = new Object[]{containerClass};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 167, args), policy.getMapping());
        descriptorException.setErrorCode(167);
        return descriptorException;
    }

    public static DescriptorException noFieldNameForMapping(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 50, args), mapping);
        descriptorException.setErrorCode(50);
        return descriptorException;
    }

    public static DescriptorException noFieldValueConversionToAttributeValueProvided(Object fieldValue, DatabaseField field2, DatabaseMapping mapping) {
        Object[] args = new Object[]{fieldValue, field2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 116, args), mapping);
        descriptorException.setErrorCode(116);
        return descriptorException;
    }

    public static DescriptorException noForeignKeysAreSpecified(ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 51, args), mapping);
        descriptorException.setErrorCode(51);
        return descriptorException;
    }

    public static DescriptorException noMappingForPrimaryKey(DatabaseField field2, ClassDescriptor descriptor) {
        Object[] args = new Object[]{field2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 46, args), descriptor);
        descriptorException.setErrorCode(46);
        return descriptorException;
    }

    public static DescriptorException noReferenceKeyIsSpecified(ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 52, args), mapping);
        descriptorException.setErrorCode(52);
        return descriptorException;
    }

    public static DescriptorException noRelationTable(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 53, args), mapping);
        descriptorException.setErrorCode(53);
        return descriptorException;
    }

    public static DescriptorException normalDescriptorsDoNotSupportNonRelationalExtensions(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 157, args), descriptor);
        descriptorException.setErrorCode(157);
        return descriptorException;
    }

    public static DescriptorException noSourceRelationKeysSpecified(ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 54, args), mapping);
        descriptorException.setErrorCode(54);
        return descriptorException;
    }

    public static DescriptorException noSubClassMatch(Class theClass, DatabaseMapping mapping) {
        Object[] args = new Object[]{theClass};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 126, args), mapping);
        descriptorException.setErrorCode(126);
        return descriptorException;
    }

    public static DescriptorException noSuchFieldWhileInitializingAttributesInInstanceVariableAccessor(String attributeName, String javaClassName, Throwable exception) {
        Object[] args = new Object[]{attributeName, javaClassName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 59, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(59);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodOnFindObsoleteMethod(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 55, args), descriptor, exception);
        descriptorException.setErrorCode(55);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodOnInitializingAttributeMethod(String attributeMethodName, DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{attributeMethodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 56, args));
        descriptorException.setErrorCode(56);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileConstructorInstantiation(ClassDescriptor descriptor, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 57, args), descriptor, exception);
        descriptorException.setErrorCode(57);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileConstructorInstantiationOfFactory(ClassDescriptor descriptor, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 172, args), descriptor, exception);
        descriptorException.setErrorCode(172);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileConvertingToMethod(String methodName, DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 58, args));
        descriptorException.setErrorCode(58);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingAttributesInMethodAccessor(String setMethodName, String getMethodName, String javaClassName) {
        Object[] args = new Object[]{setMethodName, getMethodName, javaClassName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 60, args));
        descriptorException.setErrorCode(60);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingClassExtractionMethod(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 61, args), descriptor, exception);
        descriptorException.setErrorCode(61);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingCopyPolicy(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 62, args), descriptor, exception);
        descriptorException.setErrorCode(62);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingInstantiationPolicy(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 63, args), descriptor, exception);
        descriptorException.setErrorCode(63);
        return descriptorException;
    }

    public static DescriptorException noTargetForeignKeysSpecified(ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 64, args), mapping);
        descriptorException.setErrorCode(64);
        return descriptorException;
    }

    public static DescriptorException noTargetRelationKeysSpecified(ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 65, args), mapping);
        descriptorException.setErrorCode(65);
        return descriptorException;
    }

    public static DescriptorException notDeserializable(DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 66, args));
        descriptorException.setErrorCode(66);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException notSerializable(DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 67, args));
        descriptorException.setErrorCode(67);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException nullForNonNullAggregate(Object object, DatabaseMapping mapping) {
        Object[] args = new Object[]{object};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 68, args), mapping);
        exception.setErrorCode(68);
        return exception;
    }

    public static DescriptorException nullPointerWhileConstructorInstantiation(ClassDescriptor descriptor, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 113, args), descriptor, exception);
        descriptorException.setErrorCode(113);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileConstructorInstantiationOfFactory(ClassDescriptor descriptor, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 173, args), descriptor, exception);
        descriptorException.setErrorCode(173);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileGettingValueThruInstanceVariableAccessor(String attributeName, String objectName, Throwable exception) {
        Object[] args = new Object[]{attributeName, objectName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 69, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(69);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileGettingValueThruMethodAccessor(String methodName, String objectName, Throwable exception) {
        Object[] args = new Object[]{methodName, objectName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 70, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(70);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileGettingValueThruMethodAccessorCausedByWeavingNotOccurringBecauseOfModuleOrder(String methodName, String objectName, Throwable exception) {
        Object[] args = new Object[]{methodName, objectName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 218, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(218);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileMethodInstantiation(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 114, args), descriptor, exception);
        descriptorException.setErrorCode(114);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileMethodInstantiationOfFactory(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 176, args), descriptor, exception);
        descriptorException.setErrorCode(176);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileSettingValueThruInstanceVariableAccessor(String attributeName, Object objectValue, Throwable exception) {
        Object[] args = new Object[]{attributeName, String.valueOf(objectValue)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 71, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(71);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileSettingValueThruMethodAccessor(String setMethodName, Object value2, Throwable exception) {
        Object[] args = new Object[]{setMethodName, String.valueOf(value2)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 72, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(72);
        return descriptorException;
    }

    public static DescriptorException onlyOneTableCanBeAddedWithThisMethod(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 112, args), descriptor);
        descriptorException.setErrorCode(112);
        return descriptorException;
    }

    public static DescriptorException parameterAndMappingWithIndirectionMismatch(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 129, args), mapping);
        exception.setErrorCode(129);
        return exception;
    }

    public static DescriptorException parameterAndMappingWithoutIndirectionMismatch(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 130, args), mapping);
        exception.setErrorCode(130);
        return exception;
    }

    public static DescriptorException parameterAndMappingWithTransparentIndirectionMismatch(DatabaseMapping mapping, Class parameterType, String validTypeName) {
        Object[] args = new Object[]{mapping.getAttributeName(), parameterType, validTypeName};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 140, args), mapping);
        exception.setErrorCode(140);
        return exception;
    }

    public static DescriptorException parentClassIsSelf(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 158, args), descriptor);
        exception.setErrorCode(158);
        return exception;
    }

    public static DescriptorException parentDescriptorNotSpecified(String parentClassName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{parentClassName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 73, args), descriptor);
        descriptorException.setErrorCode(73);
        return descriptorException;
    }

    public static DescriptorException primaryKeyFieldsNotSepcified(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 74, args), descriptor);
        descriptorException.setErrorCode(74);
        return descriptorException;
    }

    public static DescriptorException proxyIndirectionNotAvailable(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 159, args), mapping);
        descriptorException.setErrorCode(159);
        return descriptorException;
    }

    public static DescriptorException referenceClassNotSpecified(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 75, args), mapping);
        descriptorException.setErrorCode(75);
        return descriptorException;
    }

    public static DescriptorException referenceDescriptorIsNotAggregate(String className, DatabaseMapping mapping) {
        Object[] args = new Object[]{className};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 77, args), mapping);
        descriptorException.setErrorCode(77);
        return descriptorException;
    }

    public static DescriptorException referenceDescriptorCannotBeAggregate(DatabaseMapping mapping) {
        DescriptorException descriptorException = new DescriptorException("Reference descriptor cannot be aggregate.", mapping);
        descriptorException.setErrorCode(180);
        return descriptorException;
    }

    public static DescriptorException referenceDescriptorIsNotAggregateCollection(String className, DatabaseMapping mapping) {
        Object[] args = new Object[]{className};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 153, args), mapping);
        descriptorException.setErrorCode(153);
        return descriptorException;
    }

    public static DescriptorException referenceKeyFieldNotProperlySpecified(DatabaseField field2, ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{field2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 78, args), mapping);
        descriptorException.setErrorCode(78);
        return descriptorException;
    }

    public static DescriptorException referenceTableNotSpecified(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 79, args), mapping);
        descriptorException.setErrorCode(79);
        return descriptorException;
    }

    public static DescriptorException relationKeyFieldNotProperlySpecified(DatabaseField field2, ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{field2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 80, args), mapping);
        descriptorException.setErrorCode(80);
        return descriptorException;
    }

    public static DescriptorException returnAndMappingWithIndirectionMismatch(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 127, args), mapping);
        exception.setErrorCode(127);
        return exception;
    }

    public static DescriptorException returnAndMappingWithoutIndirectionMismatch(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 128, args), mapping);
        exception.setErrorCode(128);
        return exception;
    }

    public static DescriptorException returnAndMappingWithTransparentIndirectionMismatch(DatabaseMapping mapping, Class parameterType, String validTypeName) {
        Object[] args = new Object[]{mapping.getAttributeName(), parameterType, validTypeName};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 139, args), mapping);
        exception.setErrorCode(139);
        return exception;
    }

    public static DescriptorException returnTypeInGetAttributeAccessor(String attributeMethodName, DatabaseMapping mapping) {
        Object[] args = new Object[]{attributeMethodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 81, args));
        descriptorException.setErrorCode(81);
        descriptorException.setMapping(mapping);
        return descriptorException;
    }

    public static DescriptorException securityOnFindMethod(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 82, args), descriptor, exception);
        descriptorException.setErrorCode(82);
        return descriptorException;
    }

    public static DescriptorException securityOnFindObsoleteMethod(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 83, args), descriptor, exception);
        descriptorException.setErrorCode(83);
        return descriptorException;
    }

    public static DescriptorException securityOnInitializingAttributeMethod(String attributeMethodName, DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{attributeMethodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 84, args));
        descriptorException.setErrorCode(84);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException securityWhileConvertingToMethod(String methodName, DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 85, args));
        descriptorException.setErrorCode(85);
        descriptorException.setMapping(mapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingAttributesInInstanceVariableAccessor(String attributeName, String javaClassName, Throwable exception) {
        Object[] args = new Object[]{attributeName, javaClassName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 86, args));
        descriptorException.setErrorCode(86);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingAttributesInMethodAccessor(String setMethodName, String getMethodName, String javaClassName) {
        Object[] args = new Object[]{setMethodName, getMethodName, javaClassName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 87, args));
        descriptorException.setErrorCode(87);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingClassExtractionMethod(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 88, args), descriptor, exception);
        descriptorException.setErrorCode(88);
        return descriptorException;
    }

    public static DescriptorException classExtractionMethodMustBeStatic(String methodName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 194, args), descriptor);
        descriptorException.setErrorCode(194);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingCopyPolicy(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 89, args), descriptor, exception);
        descriptorException.setErrorCode(89);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingInstantiationPolicy(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 90, args), descriptor, exception);
        descriptorException.setErrorCode(90);
        return descriptorException;
    }

    public static DescriptorException sequenceNumberPropertyNotSpecified(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 91, args), descriptor);
        descriptorException.setErrorCode(91);
        return descriptorException;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public static DescriptorException setExistenceCheckingNotUnderstood(String token2, ClassDescriptor descriptor) {
        Object[] args = new Object[]{token2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 122, args), descriptor);
        descriptorException.setErrorCode(122);
        return descriptorException;
    }

    public void setMapping(DatabaseMapping mapping) {
        if (mapping != null) {
            this.mapping = mapping;
            this.setDescriptor(mapping.getDescriptor());
        }
    }

    public static DescriptorException setMethodParameterTypeNotValid(CollectionMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 133, args), mapping);
        exception.setErrorCode(133);
        return exception;
    }

    public static DescriptorException sizeMismatchOfForeignKeys(ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 92, args), mapping);
        descriptorException.setErrorCode(92);
        return descriptorException;
    }

    public static DescriptorException structureNameNotSetInMapping(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 156, args), mapping);
        descriptorException.setErrorCode(156);
        return descriptorException;
    }

    public static DescriptorException tableIsNotPresentInDatabase(ClassDescriptor descriptor) {
        Object[] args = new Object[]{descriptor.getTableName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 142, args), descriptor);
        descriptorException.setErrorCode(142);
        return descriptorException;
    }

    public static DescriptorException tableNotPresent(String tableName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{tableName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 93, args), descriptor);
        descriptorException.setErrorCode(93);
        return descriptorException;
    }

    public static DescriptorException tableNotSpecified(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 94, args), descriptor);
        descriptorException.setErrorCode(94);
        return descriptorException;
    }

    public static DescriptorException targetForeignKeysSizeMismatch(ForeignReferenceMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 96, args), mapping);
        descriptorException.setErrorCode(96);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileCloning(Object domainObject, String methodName, ClassDescriptor descriptor, Throwable exception) {
        Object[] args = new Object[]{domainObject, methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 97, args), descriptor, exception);
        descriptorException.setErrorCode(97);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileConstructorInstantiation(ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 168, args), descriptor, exception);
        descriptorException.setErrorCode(168);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileConstructorInstantiationOfFactory(ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 169, args), descriptor, exception);
        descriptorException.setErrorCode(169);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileEventExecution(String eventMethodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{eventMethodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 98, args), descriptor, exception);
        descriptorException.setErrorCode(98);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileGettingValueThruMethodAccessor(String methodName, String objectName, Throwable exception) {
        Object[] args = new Object[]{methodName, objectName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 99, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(99);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInstantiatingMethodBasedProxy(Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 100, args));
        descriptorException.setErrorCode(100);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInvokingAttributeMethod(DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 101, args));
        descriptorException.setErrorCode(101);
        descriptorException.setInternalException(exception);
        descriptorException.setMapping(mapping);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInvokingFieldToMethod(String methodName, DatabaseMapping mapping, Throwable exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 102, args));
        descriptorException.setErrorCode(102);
        descriptorException.setInternalException(exception);
        descriptorException.setMapping(mapping);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInvokingRowExtractionMethod(AbstractRecord row, Method method, ClassDescriptor descriptor, Throwable exception) {
        Object[] args = new Object[]{row, method};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 103, args), descriptor, exception);
        descriptorException.setErrorCode(103);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileMethodInstantiation(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 104, args), descriptor, exception);
        descriptorException.setErrorCode(104);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileMethodInstantiationOfFactory(String methodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{methodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 175, args), descriptor, exception);
        descriptorException.setErrorCode(175);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileObsoleteEventExecute(String eventMethodName, ClassDescriptor descriptor, Exception exception) {
        Object[] args = new Object[]{eventMethodName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 105, args), descriptor, exception);
        descriptorException.setErrorCode(105);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileSettingValueThruMethodAccessor(String setMethodName, Object value2, Throwable exception) {
        Object[] args = new Object[]{setMethodName, String.valueOf(value2), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 106, args));
        descriptorException.setInternalException(exception);
        descriptorException.setErrorCode(106);
        return descriptorException;
    }

    public static DescriptorException unsupportedTypeForBidirectionalRelationshipMaintenance(DatabaseMapping mapping, ContainerPolicy containerPolicy) {
        Object[] args = new Object[]{mapping.getAttributeName(), containerPolicy};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 179, args), mapping);
        exception.setErrorCode(179);
        return exception;
    }

    public static DescriptorException valueHolderInstantiationMismatch(Object attributeValue, DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName(), attributeValue};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 125, args), mapping);
        exception.setErrorCode(125);
        return exception;
    }

    public static DescriptorException valueNotFoundInClassIndicatorMapping(ClassDescriptor parentDescriptor, ClassDescriptor descriptor) {
        Object[] args = new Object[]{parentDescriptor};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 108, args), descriptor);
        descriptorException.setErrorCode(108);
        return descriptorException;
    }

    public static DescriptorException variableOneToOneMappingIsNotDefinedProperly(DatabaseMapping mapping, ClassDescriptor descriptor, String targetKeyName) {
        Object[] args = new Object[]{targetKeyName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 166, args), mapping);
        descriptorException.setErrorCode(166);
        return descriptorException;
    }

    public static DescriptorException writeLockFieldInChildDescriptor(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 109, args), descriptor);
        descriptorException.setErrorCode(109);
        return descriptorException;
    }

    public static DescriptorException mappingForAttributeIsMissing(String attributeName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{attributeName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 177, args), descriptor);
        descriptorException.setErrorCode(177);
        return descriptorException;
    }

    public static DescriptorException attributeMappingIsMissingForEntityBean(String attributeName, String beanName) {
        Object[] args = new Object[]{attributeName, beanName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 178, args));
        descriptorException.setErrorCode(178);
        return descriptorException;
    }

    public static DescriptorException returningPolicyFieldTypeConflict(String fieldName, String type1Name, String type2Name, ClassDescriptor descriptor) {
        Object[] args = new Object[]{fieldName, type1Name, type2Name};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 185, args), descriptor);
        descriptorException.setErrorCode(185);
        return descriptorException;
    }

    public static DescriptorException returningPolicyFieldInsertConflict(String fieldName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{fieldName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 186, args), descriptor);
        descriptorException.setErrorCode(186);
        return descriptorException;
    }

    public static DescriptorException returningPolicyAndDescriptorFieldTypeConflict(String fieldName, String returningPolicyFieldTypeName, String descriptorFieldTypeName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{fieldName, returningPolicyFieldTypeName, descriptorFieldTypeName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 187, args), descriptor);
        descriptorException.setErrorCode(187);
        return descriptorException;
    }

    public static DescriptorException returningPolicyUnmappedFieldTypeNotSet(String fieldName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{fieldName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 188, args), descriptor);
        descriptorException.setErrorCode(188);
        return descriptorException;
    }

    public static DescriptorException returningPolicyMappedFieldTypeNotSet(String fieldName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{fieldName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 189, args), descriptor);
        descriptorException.setErrorCode(189);
        return descriptorException;
    }

    public static DescriptorException returningPolicyMappingNotSupported(String fieldName, String mappingClassName, DatabaseMapping mapping) {
        Object[] args = new Object[]{fieldName, mappingClassName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 190, args), mapping);
        descriptorException.setErrorCode(190);
        return descriptorException;
    }

    public static DescriptorException returningPolicyFieldNotSupported(String fieldName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{fieldName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 191, args), descriptor);
        descriptorException.setErrorCode(191);
        return descriptorException;
    }

    public static DescriptorException customQueryAndReturningPolicyFieldConflict(String queryTypeName, String fieldName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{queryTypeName, fieldName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 192, args), descriptor);
        descriptorException.setErrorCode(192);
        return descriptorException;
    }

    public static DescriptorException noCustomQueryForReturningPolicy(String queryTypeName, String platformTypeName, ClassDescriptor descriptor) {
        Object[] args = new Object[]{queryTypeName, platformTypeName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 193, args), descriptor);
        descriptorException.setErrorCode(193);
        return descriptorException;
    }

    public static DescriptorException updateAllFieldsNotSet(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 196, args), descriptor);
        descriptorException.setErrorCode(196);
        return descriptorException;
    }

    public static DescriptorException invalidMappingType(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 197, args), mapping);
        descriptorException.setErrorCode(197);
        return descriptorException;
    }

    public static DescriptorException needToImplementChangeTracker(ClassDescriptor descriptor) {
        Object[] args = new Object[]{descriptor.getJavaClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 198, args), descriptor);
        descriptorException.setErrorCode(198);
        return descriptorException;
    }

    public static DescriptorException needToImplementFetchGroupTracker(Class aClass, ClassDescriptor descriptor) {
        Object[] args = new Object[]{aClass};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 199, args), descriptor);
        descriptorException.setErrorCode(199);
        return descriptorException;
    }

    public static DescriptorException errorUsingPrimaryKey(Object primaryKey, ClassDescriptor descriptor, Exception underlying) {
        Object[] args = new Object[]{primaryKey};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 202, args), descriptor, underlying);
        exception.setErrorCode(202);
        return exception;
    }

    public static DescriptorException unitOfWorkIsolatedObjectsAccessedInSession(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 201, args), descriptor);
        descriptorException.setErrorCode(201);
        return descriptorException;
    }

    public static DescriptorException insertOrderConflictsWithMultipleTableForeignKeys(ClassDescriptor descriptor, DatabaseTable table1, DatabaseTable table2) {
        Object[] args = new Object[]{table1, table2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 204, args), descriptor);
        descriptorException.setErrorCode(204);
        return descriptorException;
    }

    public static DescriptorException insertOrderCyclicalDependencyBetweenTwoTables(ClassDescriptor descriptor, DatabaseTable table1, DatabaseTable table2) {
        Object[] args = new Object[]{table1, table2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 205, args), descriptor);
        descriptorException.setErrorCode(205);
        return descriptorException;
    }

    public static DescriptorException insertOrderCyclicalDependencyBetweenThreeOrMoreTables(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 206, args), descriptor);
        descriptorException.setErrorCode(206);
        return descriptorException;
    }

    public static DescriptorException insertOrderChildBeforeParent(ClassDescriptor descriptor, DatabaseTable table1, DatabaseTable table2) {
        Object[] args = new Object[]{table1, table2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 207, args), descriptor);
        descriptorException.setErrorCode(207);
        return descriptorException;
    }

    public static DescriptorException cannotSetConverterForNonDirectMapping(ClassDescriptor descriptor, DatabaseMapping mapping, String keyConverterClassName) {
        Object[] args = new Object[]{mapping, keyConverterClassName};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 208, args), descriptor);
        descriptorException.setErrorCode(208);
        return descriptorException;
    }

    public static DescriptorException directKeyNotSet(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 209, args), descriptor);
        descriptorException.setErrorCode(209);
        return descriptorException;
    }

    public static DescriptorException listOrderFieldRequiersList(ClassDescriptor descriptor, DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 210, args), descriptor);
        descriptorException.setErrorCode(210);
        return descriptorException;
    }

    public static DescriptorException listOrderFieldRequiersIndirectList(ClassDescriptor descriptor, DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 211, args), descriptor);
        descriptorException.setErrorCode(211);
        return descriptorException;
    }

    public static DescriptorException listOrderFieldTableIsWrong(ClassDescriptor descriptor, DatabaseMapping mapping, DatabaseTable wrongTable, DatabaseTable correctTable) {
        Object[] args = new Object[]{mapping, wrongTable, correctTable};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 212, args), descriptor);
        descriptorException.setErrorCode(212);
        return descriptorException;
    }

    public static DescriptorException multipleTargetForeignKeyTables(ClassDescriptor descriptor, DatabaseMapping mapping, Collection tables) {
        Object[] args = new Object[]{mapping, tables};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 213, args), descriptor);
        descriptorException.setErrorCode(213);
        return descriptorException;
    }

    public static DescriptorException oneToOneMappingConflict(ClassDescriptor descriptor, DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 214, args), descriptor);
        descriptorException.setErrorCode(214);
        return descriptorException;
    }

    public static DescriptorException noRelationTableMechanism(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 215, args), mapping);
        descriptorException.setErrorCode(215);
        return descriptorException;
    }

    public static DescriptorException cannotUseIdValueForCompositeId(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 216, args), descriptor);
        descriptorException.setErrorCode(216);
        return descriptorException;
    }

    public static DescriptorException invalidXpathForXMLDirectMapping(DatabaseMapping mapping) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 217, args), mapping);
        descriptorException.setErrorCode(217);
        return descriptorException;
    }

    public static DescriptorException missingPartitioningPolicy(String name, ClassDescriptor descriptor, DatabaseMapping mapping) {
        Object[] args = new Object[]{name};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 220, args), descriptor);
        if (mapping != null) {
            descriptorException.setMapping(mapping);
        }
        descriptorException.setErrorCode(220);
        return descriptorException;
    }

    public static DescriptorException serializedObjectPolicyFieldNotSet(ClassDescriptor descriptor) {
        Object[] args = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 221, args), descriptor);
        descriptorException.setErrorCode(221);
        return descriptorException;
    }

    public static DescriptorException exceptionAccessingPrimaryKeyInstance(ClassDescriptor descriptor, Exception underlying) {
        Object[] args = new Object[]{};
        DescriptorException exception = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 222, args), descriptor, underlying);
        exception.setErrorCode(222);
        return exception;
    }
}

