/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.FieldPartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.RangePartition;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;

public class RangePartitioningPolicy
extends FieldPartitioningPolicy {
    protected List<RangePartition> partitions = new ArrayList<RangePartition>();

    public RangePartitioningPolicy() {
    }

    public RangePartitioningPolicy(String partitionField) {
        super(partitionField);
    }

    public RangePartitioningPolicy(String partitionField, boolean unionUnpartitionableQueries) {
        super(partitionField, unionUnpartitionableQueries);
    }

    public RangePartitioningPolicy(String partitionField, RangePartition ... partitions) {
        this(partitionField);
        RangePartition[] rangePartitionArray = partitions;
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            RangePartition partition2 = rangePartitionArray[n2];
            this.addPartition(partition2);
            ++n2;
        }
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (RangePartition rangePartition : this.partitions) {
            rangePartition.convertClassNamesToClasses(classLoader);
        }
    }

    public List<RangePartition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<RangePartition> partitions) {
        this.partitions = partitions;
    }

    public void addPartition(String connectionPool, Comparable startValue, Comparable endValue) {
        this.getPartitions().add(new RangePartition(connectionPool, startValue, endValue));
    }

    public void addPartition(RangePartition partition2) {
        this.getPartitions().add(partition2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Accessor> getConnectionsForQuery(AbstractSession session, DatabaseQuery query, AbstractRecord arguments) {
        Object value2 = arguments.get(this.partitionField);
        ArrayList<Accessor> accessors = null;
        if (value2 == null) {
            if (!this.unionUnpartitionableQueries) return null;
            accessors = new ArrayList(this.partitions.size());
        } else {
            accessors = new ArrayList<Accessor>(1);
        }
        int size2 = this.partitions.size();
        int index2 = 0;
        while (index2 < size2) {
            RangePartition partition2 = this.partitions.get(index2);
            if (value2 == null || partition2.isInRange(value2)) {
                if (session.getPlatform().hasPartitioningCallback()) {
                    session.getPlatform().getPartitioningCallback().setPartitionId(index2);
                    return null;
                }
                accessors.add(this.getAccessor(partition2.getConnectionPool(), session, query, false));
                if (value2 != null) break;
            }
            ++index2;
        }
        if (!accessors.isEmpty()) return accessors;
        return null;
    }

    @Override
    public void partitionPersist(AbstractSession session, Object object, ClassDescriptor descriptor) {
        Object value2 = this.extractPartitionValueForPersist(session, object, descriptor);
        if (value2 == null) {
            return;
        }
        int size2 = this.partitions.size();
        int index2 = 0;
        while (index2 < size2) {
            RangePartition partition2 = this.partitions.get(index2);
            if (partition2.isInRange(value2)) {
                if (session.getPlatform().hasPartitioningCallback()) {
                    session.getPlatform().getPartitioningCallback().setPartitionId(index2);
                } else {
                    this.getAccessor(partition2.getConnectionPool(), session, null, false);
                }
                return;
            }
            ++index2;
        }
    }
}

