/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.persistence.descriptors.FieldsLockingPolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;

public class ChangedFieldsLockingPolicy
extends FieldsLockingPolicy {
    @Override
    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery query) {
        this.verifyUsage(query.getSession());
        if (query.isDeleteObjectQuery()) {
            return;
        }
        Object object = query.getBackupClone();
        if (query.isUpdateObjectQuery()) {
            query.setShouldValidateUpdateCallCacheUse(true);
        }
        Enumeration enumtr = query.getModifyRow().keys();
        while (enumtr.hasMoreElements()) {
            DatabaseField field2 = (DatabaseField)enumtr.nextElement();
            DatabaseMapping mapping = this.descriptor.getObjectBuilder().getMappingForField(field2);
            mapping.writeFromObjectIntoRow(object, query.getTranslationRow(), query.getSession(), DatabaseMapping.WriteType.UNDEFINED);
        }
    }

    @Override
    public Expression buildDeleteExpression(DatabaseTable table, Expression mainExpression, AbstractRecord row) {
        return mainExpression;
    }

    @Override
    protected List<DatabaseField> getFieldsToCompare(DatabaseTable table, AbstractRecord transRow, AbstractRecord modifyRow) {
        List<DatabaseField> fields = this.getAllNonPrimaryKeyFields(table);
        ArrayList<DatabaseField> returnedFields = new ArrayList<DatabaseField>();
        for (DatabaseField field2 : fields) {
            if (!modifyRow.containsKey(field2)) continue;
            returnedFields.add(field2);
        }
        return returnedFields;
    }
}

