/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ConfigUtils {
    public static String getClientConfigStr(String configData) {
        Properties props = new Properties();
        try {
            props.load(new StringReader(configData));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        String version = "";
        for (Map.Entry<Object, Object> entry2 : props.entrySet()) {
            QuorumPeer.QuorumServer qs;
            String key = entry2.getKey().toString().trim();
            String value2 = entry2.getValue().toString().trim();
            if (key.equals("version")) {
                version = value2;
            }
            if (!key.startsWith("server.")) continue;
            try {
                qs = new QuorumPeer.QuorumServer(-1L, value2);
            }
            catch (QuorumPeerConfig.ConfigException e) {
                e.printStackTrace();
                continue;
            }
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            if (null == qs.clientAddr) continue;
            sb.append(qs.clientAddr.getHostString() + ":" + qs.clientAddr.getPort());
        }
        return version + " " + sb.toString();
    }
}

