/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import org.apache.kafka.common.Node;

public class PartitionInfo {
    private final String topic;
    private final int partition;
    private final Node leader;
    private final Node[] replicas;
    private final Node[] inSyncReplicas;

    public PartitionInfo(String topic, int partition2, Node leader, Node[] replicas, Node[] inSyncReplicas) {
        this.topic = topic;
        this.partition = partition2;
        this.leader = leader;
        this.replicas = replicas;
        this.inSyncReplicas = inSyncReplicas;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public Node leader() {
        return this.leader;
    }

    public Node[] replicas() {
        return this.replicas;
    }

    public Node[] inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public String toString() {
        return String.format("Partition(topic = %s, partition = %d, leader = %d, replicas = %s, isr = %s", this.topic, this.partition, this.leader.id(), this.fmtNodeIds(this.replicas), this.fmtNodeIds(this.inSyncReplicas));
    }

    private String fmtNodeIds(Node[] nodes) {
        StringBuilder b = new StringBuilder("[");
        for (int i = 0; i < nodes.length - 1; ++i) {
            b.append(Integer.toString(nodes[i].id()));
            b.append(',');
        }
        if (nodes.length > 0) {
            b.append(Integer.toString(nodes[nodes.length - 1].id()));
            b.append(',');
        }
        b.append("]");
        return b.toString();
    }
}

