/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.com.google.common.util.concurrent;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.shaded.com.google.common.annotations.GwtCompatible;

@GwtCompatible(emulated=true)
abstract class InterruptibleTask
implements Runnable {
    private volatile Thread runner;
    private volatile boolean doneInterrupting;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Logger log;

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (!ATOMIC_HELPER.compareAndSetRunner(this, null, Thread.currentThread())) {
            return;
        }
        try {
            this.runInterruptibly();
        }
        finally {
            if (this.wasInterrupted()) {
                while (!this.doneInterrupting) {
                    Thread.yield();
                }
            }
        }
    }

    abstract void runInterruptibly();

    abstract boolean wasInterrupted();

    final void interruptTask() {
        Thread currentRunner = this.runner;
        if (currentRunner != null) {
            currentRunner.interrupt();
        }
        this.doneInterrupting = true;
    }

    static {
        AtomicHelper helper;
        log = Logger.getLogger(InterruptibleTask.class.getName());
        try {
            helper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(InterruptibleTask.class, Thread.class, "runner"));
        }
        catch (Throwable reflectionFailure) {
            log.log(Level.SEVERE, "SafeAtomicHelper is broken!", reflectionFailure);
            helper = new SynchronizedAtomicHelper();
        }
        ATOMIC_HELPER = helper;
    }

    private static final class SynchronizedAtomicHelper
    extends AtomicHelper {
        private SynchronizedAtomicHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean compareAndSetRunner(InterruptibleTask task, Thread expect, Thread update2) {
            InterruptibleTask interruptibleTask = task;
            synchronized (interruptibleTask) {
                if (task.runner == expect) {
                    task.runner = update2;
                }
            }
            return true;
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<InterruptibleTask, Thread> runnerUpdater;

        SafeAtomicHelper(AtomicReferenceFieldUpdater runnerUpdater) {
            this.runnerUpdater = runnerUpdater;
        }

        @Override
        boolean compareAndSetRunner(InterruptibleTask task, Thread expect, Thread update2) {
            return this.runnerUpdater.compareAndSet(task, expect, update2);
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract boolean compareAndSetRunner(InterruptibleTask var1, Thread var2, Thread var3);
    }
}

