/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.com.google.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.curator.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.curator.shaded.com.google.common.annotations.GwtIncompatible;
import org.apache.curator.shaded.com.google.common.base.Objects;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.AbstractMapEntry;
import org.apache.curator.shaded.com.google.common.collect.BiMap;
import org.apache.curator.shaded.com.google.common.collect.CollectPreconditions;
import org.apache.curator.shaded.com.google.common.collect.Hashing;
import org.apache.curator.shaded.com.google.common.collect.ImmutableEntry;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.curator.shaded.com.google.common.collect.Serialization;
import org.apache.curator.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.curator.shaded.com.google.j2objc.annotations.RetainedWith;

@GwtCompatible(emulated=true)
public final class HashBiMap<K, V>
extends Maps.IteratorBasedAbstractMap<K, V>
implements BiMap<K, V>,
Serializable {
    private static final double LOAD_FACTOR = 1.0;
    private transient BiEntry<K, V>[] hashTableKToV;
    private transient BiEntry<K, V>[] hashTableVToK;
    private transient BiEntry<K, V> firstInKeyInsertionOrder;
    private transient BiEntry<K, V> lastInKeyInsertionOrder;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    @RetainedWith
    private transient BiMap<V, K> inverse;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> HashBiMap<K, V> create() {
        return HashBiMap.create(16);
    }

    public static <K, V> HashBiMap<K, V> create(int expectedSize) {
        return new HashBiMap<K, V>(expectedSize);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map2) {
        HashBiMap<K, V> bimap = HashBiMap.create(map2.size());
        bimap.putAll(map2);
        return bimap;
    }

    private HashBiMap(int expectedSize) {
        this.init(expectedSize);
    }

    private void init(int expectedSize) {
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        int tableSize = Hashing.closedTableSize(expectedSize, 1.0);
        this.hashTableKToV = this.createTable(tableSize);
        this.hashTableVToK = this.createTable(tableSize);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        this.size = 0;
        this.mask = tableSize - 1;
        this.modCount = 0;
    }

    private void delete(BiEntry<K, V> entry2) {
        int keyBucket = entry2.keyHash & this.mask;
        BiEntry<K, V> prevBucketEntry = null;
        BiEntry<K, V> bucketEntry = this.hashTableKToV[keyBucket];
        while (true) {
            if (bucketEntry == entry2) {
                if (prevBucketEntry == null) {
                    this.hashTableKToV[keyBucket] = entry2.nextInKToVBucket;
                    break;
                }
                prevBucketEntry.nextInKToVBucket = entry2.nextInKToVBucket;
                break;
            }
            prevBucketEntry = bucketEntry;
            bucketEntry = bucketEntry.nextInKToVBucket;
        }
        int valueBucket = entry2.valueHash & this.mask;
        prevBucketEntry = null;
        BiEntry<K, V> bucketEntry2 = this.hashTableVToK[valueBucket];
        while (true) {
            if (bucketEntry2 == entry2) {
                if (prevBucketEntry == null) {
                    this.hashTableVToK[valueBucket] = entry2.nextInVToKBucket;
                    break;
                }
                prevBucketEntry.nextInVToKBucket = entry2.nextInVToKBucket;
                break;
            }
            prevBucketEntry = bucketEntry2;
            bucketEntry2 = bucketEntry2.nextInVToKBucket;
        }
        if (entry2.prevInKeyInsertionOrder == null) {
            this.firstInKeyInsertionOrder = entry2.nextInKeyInsertionOrder;
        } else {
            entry2.prevInKeyInsertionOrder.nextInKeyInsertionOrder = entry2.nextInKeyInsertionOrder;
        }
        if (entry2.nextInKeyInsertionOrder == null) {
            this.lastInKeyInsertionOrder = entry2.prevInKeyInsertionOrder;
        } else {
            entry2.nextInKeyInsertionOrder.prevInKeyInsertionOrder = entry2.prevInKeyInsertionOrder;
        }
        --this.size;
        ++this.modCount;
    }

    private void insert(BiEntry<K, V> entry2, @Nullable BiEntry<K, V> oldEntryForKey) {
        int keyBucket = entry2.keyHash & this.mask;
        entry2.nextInKToVBucket = this.hashTableKToV[keyBucket];
        this.hashTableKToV[keyBucket] = entry2;
        int valueBucket = entry2.valueHash & this.mask;
        entry2.nextInVToKBucket = this.hashTableVToK[valueBucket];
        this.hashTableVToK[valueBucket] = entry2;
        if (oldEntryForKey == null) {
            entry2.prevInKeyInsertionOrder = this.lastInKeyInsertionOrder;
            entry2.nextInKeyInsertionOrder = null;
            if (this.lastInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = entry2;
            } else {
                this.lastInKeyInsertionOrder.nextInKeyInsertionOrder = entry2;
            }
            this.lastInKeyInsertionOrder = entry2;
        } else {
            entry2.prevInKeyInsertionOrder = oldEntryForKey.prevInKeyInsertionOrder;
            if (entry2.prevInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = entry2;
            } else {
                entry2.prevInKeyInsertionOrder.nextInKeyInsertionOrder = entry2;
            }
            entry2.nextInKeyInsertionOrder = oldEntryForKey.nextInKeyInsertionOrder;
            if (entry2.nextInKeyInsertionOrder == null) {
                this.lastInKeyInsertionOrder = entry2;
            } else {
                entry2.nextInKeyInsertionOrder.prevInKeyInsertionOrder = entry2;
            }
        }
        ++this.size;
        ++this.modCount;
    }

    private BiEntry<K, V> seekByKey(@Nullable Object key, int keyHash) {
        BiEntry<K, V> entry2 = this.hashTableKToV[keyHash & this.mask];
        while (entry2 != null) {
            if (keyHash == entry2.keyHash && Objects.equal(key, entry2.key)) {
                return entry2;
            }
            entry2 = entry2.nextInKToVBucket;
        }
        return null;
    }

    private BiEntry<K, V> seekByValue(@Nullable Object value2, int valueHash) {
        BiEntry<K, V> entry2 = this.hashTableVToK[valueHash & this.mask];
        while (entry2 != null) {
            if (valueHash == entry2.valueHash && Objects.equal(value2, entry2.value)) {
                return entry2;
            }
            entry2 = entry2.nextInVToKBucket;
        }
        return null;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.seekByKey(key, Hashing.smearedHash(key)) != null;
    }

    @Override
    public boolean containsValue(@Nullable Object value2) {
        return this.seekByValue(value2, Hashing.smearedHash(value2)) != null;
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        return Maps.valueOrNull(this.seekByKey(key, Hashing.smearedHash(key)));
    }

    @Override
    @CanIgnoreReturnValue
    public V put(@Nullable K key, @Nullable V value2) {
        return this.put(key, value2, false);
    }

    @Override
    @CanIgnoreReturnValue
    public V forcePut(@Nullable K key, @Nullable V value2) {
        return this.put(key, value2, true);
    }

    private V put(@Nullable K key, @Nullable V value2, boolean force2) {
        int keyHash = Hashing.smearedHash(key);
        int valueHash = Hashing.smearedHash(value2);
        BiEntry<K, V> oldEntryForKey = this.seekByKey(key, keyHash);
        if (oldEntryForKey != null && valueHash == oldEntryForKey.valueHash && Objects.equal(value2, oldEntryForKey.value)) {
            return value2;
        }
        BiEntry<K, V> oldEntryForValue = this.seekByValue(value2, valueHash);
        if (oldEntryForValue != null) {
            if (force2) {
                this.delete(oldEntryForValue);
            } else {
                throw new IllegalArgumentException("value already present: " + value2);
            }
        }
        BiEntry<K, V> newEntry = new BiEntry<K, V>(key, keyHash, value2, valueHash);
        if (oldEntryForKey != null) {
            this.delete(oldEntryForKey);
            this.insert(newEntry, oldEntryForKey);
            oldEntryForKey.prevInKeyInsertionOrder = null;
            oldEntryForKey.nextInKeyInsertionOrder = null;
            this.rehashIfNecessary();
            return (V)oldEntryForKey.value;
        }
        this.insert(newEntry, null);
        this.rehashIfNecessary();
        return null;
    }

    @Nullable
    private K putInverse(@Nullable V value2, @Nullable K key, boolean force2) {
        int valueHash = Hashing.smearedHash(value2);
        int keyHash = Hashing.smearedHash(key);
        BiEntry<K, V> oldEntryForValue = this.seekByValue(value2, valueHash);
        if (oldEntryForValue != null && keyHash == oldEntryForValue.keyHash && Objects.equal(key, oldEntryForValue.key)) {
            return key;
        }
        BiEntry<K, V> oldEntryForKey = this.seekByKey(key, keyHash);
        if (oldEntryForKey != null) {
            if (force2) {
                this.delete(oldEntryForKey);
            } else {
                throw new IllegalArgumentException("value already present: " + key);
            }
        }
        if (oldEntryForValue != null) {
            this.delete(oldEntryForValue);
        }
        BiEntry<K, V> newEntry = new BiEntry<K, V>(key, keyHash, value2, valueHash);
        this.insert(newEntry, oldEntryForKey);
        if (oldEntryForKey != null) {
            oldEntryForKey.prevInKeyInsertionOrder = null;
            oldEntryForKey.nextInKeyInsertionOrder = null;
        }
        this.rehashIfNecessary();
        return Maps.keyOrNull(oldEntryForValue);
    }

    private void rehashIfNecessary() {
        BiEntry<K, V>[] oldKToV = this.hashTableKToV;
        if (Hashing.needsResizing(this.size, oldKToV.length, 1.0)) {
            int newTableSize = oldKToV.length * 2;
            this.hashTableKToV = this.createTable(newTableSize);
            this.hashTableVToK = this.createTable(newTableSize);
            this.mask = newTableSize - 1;
            this.size = 0;
            BiEntry<K, V> entry2 = this.firstInKeyInsertionOrder;
            while (entry2 != null) {
                this.insert(entry2, entry2);
                entry2 = entry2.nextInKeyInsertionOrder;
            }
            ++this.modCount;
        }
    }

    private BiEntry<K, V>[] createTable(int length) {
        return new BiEntry[length];
    }

    @Override
    @CanIgnoreReturnValue
    public V remove(@Nullable Object key) {
        BiEntry<K, V> entry2 = this.seekByKey(key, Hashing.smearedHash(key));
        if (entry2 == null) {
            return null;
        }
        this.delete(entry2);
        entry2.prevInKeyInsertionOrder = null;
        entry2.nextInKeyInsertionOrder = null;
        return (V)entry2.value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Set<V> values() {
        return this.inverse().keySet();
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> output(BiEntry<K, V> entry2) {
                return new MapEntry(entry2);
            }

            class MapEntry
            extends AbstractMapEntry<K, V> {
                BiEntry<K, V> delegate;

                MapEntry(BiEntry<K, V> entry2) {
                    this.delegate = entry2;
                }

                @Override
                public K getKey() {
                    return this.delegate.key;
                }

                @Override
                public V getValue() {
                    return this.delegate.value;
                }

                @Override
                public V setValue(V value2) {
                    Object oldValue = this.delegate.value;
                    int valueHash = Hashing.smearedHash(value2);
                    if (valueHash == this.delegate.valueHash && Objects.equal(value2, oldValue)) {
                        return value2;
                    }
                    Preconditions.checkArgument(HashBiMap.this.seekByValue(value2, valueHash) == null, "value already present: %s", value2);
                    HashBiMap.this.delete(this.delegate);
                    BiEntry newEntry = new BiEntry(this.delegate.key, this.delegate.keyHash, value2, valueHash);
                    HashBiMap.this.insert(newEntry, this.delegate);
                    this.delegate.prevInKeyInsertionOrder = null;
                    this.delegate.nextInKeyInsertionOrder = null;
                    expectedModCount = HashBiMap.this.modCount;
                    if (toRemove == this.delegate) {
                        toRemove = newEntry;
                    }
                    this.delegate = newEntry;
                    return oldValue;
                }
            }
        };
    }

    @Override
    public BiMap<V, K> inverse() {
        return this.inverse == null ? (this.inverse = new Inverse()) : this.inverse;
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMap(this, stream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.init(16);
        int size2 = Serialization.readCount(stream);
        Serialization.populateMap(this, stream, size2);
    }

    private static final class InverseSerializedForm<K, V>
    implements Serializable {
        private final HashBiMap<K, V> bimap;

        InverseSerializedForm(HashBiMap<K, V> bimap) {
            this.bimap = bimap;
        }

        Object readResolve() {
            return this.bimap.inverse();
        }
    }

    private final class Inverse
    extends AbstractMap<V, K>
    implements BiMap<V, K>,
    Serializable {
        private Inverse() {
        }

        BiMap<K, V> forward() {
            return HashBiMap.this;
        }

        @Override
        public int size() {
            return HashBiMap.this.size;
        }

        @Override
        public void clear() {
            this.forward().clear();
        }

        @Override
        public boolean containsKey(@Nullable Object value2) {
            return this.forward().containsValue(value2);
        }

        @Override
        public K get(@Nullable Object value2) {
            return Maps.keyOrNull(HashBiMap.this.seekByValue(value2, Hashing.smearedHash(value2)));
        }

        @Override
        public K put(@Nullable V value2, @Nullable K key) {
            return HashBiMap.this.putInverse(value2, key, false);
        }

        @Override
        public K forcePut(@Nullable V value2, @Nullable K key) {
            return HashBiMap.this.putInverse(value2, key, true);
        }

        @Override
        public K remove(@Nullable Object value2) {
            BiEntry entry2 = HashBiMap.this.seekByValue(value2, Hashing.smearedHash(value2));
            if (entry2 == null) {
                return null;
            }
            HashBiMap.this.delete(entry2);
            entry2.prevInKeyInsertionOrder = null;
            entry2.nextInKeyInsertionOrder = null;
            return entry2.key;
        }

        @Override
        public BiMap<K, V> inverse() {
            return this.forward();
        }

        @Override
        public Set<V> keySet() {
            return new InverseKeySet();
        }

        @Override
        public Set<K> values() {
            return this.forward().keySet();
        }

        @Override
        public Set<Map.Entry<V, K>> entrySet() {
            return new Maps.EntrySet<V, K>(){

                @Override
                Map<V, K> map() {
                    return Inverse.this;
                }

                @Override
                public Iterator<Map.Entry<V, K>> iterator() {
                    return new Itr<Map.Entry<V, K>>(){

                        @Override
                        Map.Entry<V, K> output(BiEntry<K, V> entry2) {
                            return new InverseEntry(entry2);
                        }

                        class InverseEntry
                        extends AbstractMapEntry<V, K> {
                            BiEntry<K, V> delegate;

                            InverseEntry(BiEntry<K, V> entry2) {
                                this.delegate = entry2;
                            }

                            @Override
                            public V getKey() {
                                return this.delegate.value;
                            }

                            @Override
                            public K getValue() {
                                return this.delegate.key;
                            }

                            @Override
                            public K setValue(K key) {
                                Object oldKey = this.delegate.key;
                                int keyHash = Hashing.smearedHash(key);
                                if (keyHash == this.delegate.keyHash && Objects.equal(key, oldKey)) {
                                    return key;
                                }
                                Preconditions.checkArgument(HashBiMap.this.seekByKey(key, keyHash) == null, "value already present: %s", key);
                                HashBiMap.this.delete(this.delegate);
                                BiEntry newEntry = new BiEntry(key, keyHash, this.delegate.value, this.delegate.valueHash);
                                this.delegate = newEntry;
                                HashBiMap.this.insert(newEntry, null);
                                expectedModCount = HashBiMap.this.modCount;
                                return oldKey;
                            }
                        }
                    };
                }
            };
        }

        Object writeReplace() {
            return new InverseSerializedForm(HashBiMap.this);
        }

        private final class InverseKeySet
        extends Maps.KeySet<V, K> {
            InverseKeySet() {
                super(Inverse.this);
            }

            @Override
            public boolean remove(@Nullable Object o) {
                BiEntry entry2 = HashBiMap.this.seekByValue(o, Hashing.smearedHash(o));
                if (entry2 == null) {
                    return false;
                }
                HashBiMap.this.delete(entry2);
                return true;
            }

            @Override
            public Iterator<V> iterator() {
                return new Itr<V>(){

                    @Override
                    V output(BiEntry<K, V> entry2) {
                        return entry2.value;
                    }
                };
            }
        }
    }

    private final class KeySet
    extends Maps.KeySet<K, V> {
        KeySet() {
            super(HashBiMap.this);
        }

        @Override
        public Iterator<K> iterator() {
            return new Itr<K>(){

                @Override
                K output(BiEntry<K, V> entry2) {
                    return entry2.key;
                }
            };
        }

        @Override
        public boolean remove(@Nullable Object o) {
            BiEntry entry2 = HashBiMap.this.seekByKey(o, Hashing.smearedHash(o));
            if (entry2 == null) {
                return false;
            }
            HashBiMap.this.delete(entry2);
            entry2.prevInKeyInsertionOrder = null;
            entry2.nextInKeyInsertionOrder = null;
            return true;
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        BiEntry<K, V> next;
        BiEntry<K, V> toRemove;
        int expectedModCount;

        Itr() {
            this.next = HashBiMap.this.firstInKeyInsertionOrder;
            this.toRemove = null;
            this.expectedModCount = HashBiMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (HashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BiEntry entry2 = this.next;
            this.next = entry2.nextInKeyInsertionOrder;
            this.toRemove = entry2;
            return this.output(entry2);
        }

        @Override
        public void remove() {
            if (HashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            CollectPreconditions.checkRemove(this.toRemove != null);
            HashBiMap.this.delete(this.toRemove);
            this.expectedModCount = HashBiMap.this.modCount;
            this.toRemove = null;
        }

        abstract T output(BiEntry<K, V> var1);
    }

    private static final class BiEntry<K, V>
    extends ImmutableEntry<K, V> {
        final int keyHash;
        final int valueHash;
        @Nullable
        BiEntry<K, V> nextInKToVBucket;
        @Nullable
        BiEntry<K, V> nextInVToKBucket;
        @Nullable
        BiEntry<K, V> nextInKeyInsertionOrder;
        @Nullable
        BiEntry<K, V> prevInKeyInsertionOrder;

        BiEntry(K key, int keyHash, V value2, int valueHash) {
            super(key, value2);
            this.keyHash = keyHash;
            this.valueHash = valueHash;
        }
    }
}

