/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.csv.Assertions;
import org.apache.commons.csv.CSVFormat;

public final class CSVPrinter
implements Flushable,
Closeable {
    private final Appendable out;
    private final CSVFormat format;
    private boolean newRecord = true;

    public CSVPrinter(Appendable out, CSVFormat format2) throws IOException {
        Assertions.notNull(out, "out");
        Assertions.notNull(format2, "format");
        this.out = out;
        this.format = format2;
        if (format2.getHeaderComments() != null) {
            for (String line : format2.getHeaderComments()) {
                if (line == null) continue;
                this.printComment(line);
            }
        }
        if (format2.getHeader() != null && !format2.getSkipHeaderRecord()) {
            this.printRecord(format2.getHeader());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out instanceof Flushable) {
            ((Flushable)((Object)this.out)).flush();
        }
    }

    public Appendable getOut() {
        return this.out;
    }

    public void print(Object value2) throws IOException {
        this.format.print(value2, this.out, this.newRecord);
        this.newRecord = false;
    }

    public void printComment(String comment2) throws IOException {
        if (!this.format.isCommentMarkerSet()) {
            return;
        }
        if (!this.newRecord) {
            this.println();
        }
        this.out.append(this.format.getCommentMarker().charValue());
        this.out.append(' ');
        block4: for (int i = 0; i < comment2.length(); ++i) {
            char c = comment2.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 < comment2.length() && comment2.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    this.println();
                    this.out.append(this.format.getCommentMarker().charValue());
                    this.out.append(' ');
                    continue block4;
                }
                default: {
                    this.out.append(c);
                }
            }
        }
        this.println();
    }

    public void println() throws IOException {
        this.format.println(this.out);
        this.newRecord = true;
    }

    public void printRecord(Iterable<?> values) throws IOException {
        for (Object value2 : values) {
            this.print(value2);
        }
        this.println();
    }

    public void printRecord(Object ... values) throws IOException {
        this.format.printRecord(this.out, values);
        this.newRecord = true;
    }

    public void printRecords(Iterable<?> values) throws IOException {
        for (Object value2 : values) {
            if (value2 instanceof Object[]) {
                this.printRecord((Object[])value2);
                continue;
            }
            if (value2 instanceof Iterable) {
                this.printRecord((Iterable)value2);
                continue;
            }
            this.printRecord(value2);
        }
    }

    public void printRecords(Object ... values) throws IOException {
        for (Object value2 : values) {
            if (value2 instanceof Object[]) {
                this.printRecord((Object[])value2);
                continue;
            }
            if (value2 instanceof Iterable) {
                this.printRecord((Iterable)value2);
                continue;
            }
            this.printRecord(value2);
        }
    }

    public void printRecords(ResultSet resultSet) throws SQLException, IOException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            for (int i = 1; i <= columnCount; ++i) {
                this.print(resultSet.getObject(i));
            }
            this.println();
        }
    }
}

