/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.htmlparser.jericho.Config;

public final class Util {
    private static final int BUFFER_SIZE = 2048;
    private static final String CSVNewLine = System.getProperty("line.separator");

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        try {
            int n;
            char[] cArray = new char[2048];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = reader.read(cArray, 0, 2048)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            reader.close();
        }
    }

    public static void outputCSVLine(Writer writer, String[] stringArray) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2 != null) {
                if (string2 == Config.ColumnValueTrue || string2 == Config.ColumnValueFalse) {
                    writer.write(string2);
                } else {
                    writer.write(34);
                    Util.outputValueEscapeQuotes(writer, string2);
                    writer.write(34);
                }
            }
            if (++n == stringArray.length) continue;
            writer.write(44);
        }
        writer.write(CSVNewLine);
    }

    private static void outputValueEscapeQuotes(Writer writer, String string2) throws IOException {
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            writer.write(c);
            if (c != '\"') continue;
            writer.write(c);
        }
    }

    static char[] getConcatenatedCharArray(String string2, String string3) {
        char[] cArray = new char[string2.length() + string3.length()];
        string2.getChars(0, string2.length(), cArray, 0);
        string3.getChars(0, string3.length(), cArray, string2.length());
        return cArray;
    }
}

