/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.Iterator;
import net.htmlparser.jericho.Cache;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

final class SubCache {
    private final Cache cache;
    public final TagType tagType;
    private final CacheEntry bof;
    private final CacheEntry eof;
    private CacheEntry[] array = new CacheEntry[64];
    private static final int INITIAL_CAPACITY = 64;

    public SubCache(Cache cache, TagType tagType) {
        this.cache = cache;
        this.tagType = tagType;
        this.array[0] = this.bof = new CacheEntry(0, -1, null, false, false);
        this.array[1] = this.eof = new CacheEntry(1, cache.getSourceLength(), null, false, false);
    }

    public int size() {
        return this.eof.index + 1;
    }

    public void clear() {
        this.bof.nextCached = false;
        this.eof.index = 1;
        this.eof.previousCached = false;
        this.array[1] = this.eof;
    }

    public void bulkLoad_Init(int n) {
        this.array = new CacheEntry[n + 2];
        this.array[0] = this.bof;
        this.bof.nextCached = true;
        this.eof.index = n + 1;
        this.array[this.eof.index] = this.eof;
        this.eof.previousCached = true;
    }

    public void bulkLoad_Set(int n, Tag tag) {
        int n2 = n + 1;
        this.array[n2] = new CacheEntry(n2, tag.begin, tag, true, true);
    }

    public void bulkLoad_AddToTypeSpecificCache(Tag tag) {
        int n = this.eof.index;
        if (this.array.length == this.eof.index + 1) {
            this.doubleCapacity();
        }
        this.array[n] = new CacheEntry(n, tag.begin, tag, true, true);
        ++this.eof.index;
    }

    public void bulkLoad_FinaliseTypeSpecificCache() {
        this.bof.nextCached = true;
        this.eof.previousCached = true;
        this.array[this.eof.index] = this.eof;
    }

    public Tag getTagAt(int n, boolean bl) {
        if (this.cache.getSourceLength() == 0) {
            return null;
        }
        if (n < 0 || n >= this.cache.getSourceLength()) {
            return null;
        }
        int n2 = this.getIndexOfPos(n);
        CacheEntry cacheEntry = this.array[n2];
        if (cacheEntry.pos == n) {
            if (bl && !cacheEntry.tag.getTagType().isServerTag()) {
                return null;
            }
            return cacheEntry.tag;
        }
        if (cacheEntry.previousCached) {
            return null;
        }
        return this.cache.addTagAt(n, bl);
    }

    public void addTagAt(int n, Tag tag) {
        int n2 = this.getIndexOfPos(n);
        CacheEntry cacheEntry = this.array[n2];
        CacheEntry cacheEntry2 = this.getPrevious(cacheEntry);
        this.add(cacheEntry2, new CacheEntry(n2, n, tag, n == cacheEntry2.pos + 1, n == cacheEntry.pos - 1), cacheEntry);
    }

    public Tag getPreviousTag(int n) {
        if (this.cache.getSourceLength() == 0) {
            return null;
        }
        if (n < 0 || n >= this.cache.getSourceLength()) {
            return null;
        }
        int n2 = this.getIndexOfPos(n);
        CacheEntry cacheEntry = this.array[n2];
        if (cacheEntry.pos == n && cacheEntry.tag != null && cacheEntry.tag.includeInSearch()) {
            return cacheEntry.tag;
        }
        Tag tag = this.getPreviousTag(this.getPrevious(cacheEntry), n, cacheEntry);
        this.addPreviousTag(n, tag);
        return tag;
    }

    public Tag getNextTag(int n) {
        Tag tag;
        if (this.cache.getSourceLength() == 0) {
            return null;
        }
        if (n < 0 || n >= this.cache.getSourceLength()) {
            return null;
        }
        int n2 = this.getIndexOfPos(n);
        CacheEntry cacheEntry = this.array[n2];
        if (cacheEntry.pos == n) {
            if (cacheEntry.tag != null && cacheEntry.tag.includeInSearch()) {
                return cacheEntry.tag;
            }
            tag = this.getNextTag(cacheEntry, n, this.getNext(cacheEntry));
        } else {
            tag = this.getNextTag(this.getPrevious(cacheEntry), n, cacheEntry);
        }
        this.addNextTag(n, tag);
        return tag;
    }

    public Iterator<Tag> getTagIterator() {
        return new TagIterator();
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    protected StringBuilder appendTo(StringBuilder stringBuilder) {
        stringBuilder.append("Cache for TagType : ").append(this.tagType).append(Config.NewLine);
        for (int i = 0; i <= this.lastIndex(); ++i) {
            stringBuilder.append(this.array[i]).append(Config.NewLine);
        }
        return stringBuilder;
    }

    private Tag getPreviousTag(CacheEntry cacheEntry, int n, CacheEntry cacheEntry2) {
        while (true) {
            Tag tag;
            if (!cacheEntry2.previousCached && (tag = Tag.getPreviousTagUncached(this.cache.source, n, this.tagType, cacheEntry.pos)) != null) {
                if (!this.cache.source.useAllTypesCache) {
                    this.addTagAt(tag.begin, tag);
                }
                return tag;
            }
            if (cacheEntry == this.bof) {
                return null;
            }
            if (cacheEntry.tag != null && cacheEntry.tag.includeInSearch()) {
                return cacheEntry.tag;
            }
            n = cacheEntry.pos - 1;
            cacheEntry2 = cacheEntry;
            cacheEntry = this.getPrevious(cacheEntry2);
        }
    }

    private Tag getNextTag(CacheEntry cacheEntry, int n, CacheEntry cacheEntry2) {
        while (true) {
            Tag tag;
            if (!cacheEntry.nextCached && (tag = Tag.getNextTagUncached(this.cache.source, n, this.tagType, cacheEntry2.pos)) != null) {
                if (!this.cache.source.useAllTypesCache) {
                    this.addTagAt(tag.begin, tag);
                }
                return tag;
            }
            if (cacheEntry2 == this.eof) {
                return null;
            }
            if (cacheEntry2.tag != null && cacheEntry2.tag.includeInSearch()) {
                return cacheEntry2.tag;
            }
            n = cacheEntry2.pos + 1;
            cacheEntry = cacheEntry2;
            cacheEntry2 = this.getNext(cacheEntry);
        }
    }

    private void addPreviousTag(int n, Tag tag) {
        int n2;
        int n3 = n2 = tag == null ? this.bof.pos : tag.begin;
        if (n2 == n) {
            return;
        }
        int n4 = this.getIndexOfPos(n);
        CacheEntry cacheEntry = this.array[n4];
        int n5 = Integer.MAX_VALUE;
        if (cacheEntry.pos == n) {
            cacheEntry.previousCached = true;
            if (cacheEntry.isRedundant()) {
                cacheEntry.removed = true;
                n5 = Math.min(n5, cacheEntry.index);
            }
        } else if (!cacheEntry.previousCached) {
            if (this.tagType == null) {
                this.cache.addTagAt(n, false);
            } else {
                this.addTagAt(n, null);
            }
            n4 = this.getIndexOfPos(n);
            cacheEntry = this.array[n4];
            if (cacheEntry.pos == n) {
                cacheEntry.previousCached = true;
                if (cacheEntry.isRedundant()) {
                    cacheEntry.removed = true;
                    n5 = Math.min(n5, cacheEntry.index);
                }
            }
        }
        while (true) {
            cacheEntry = this.array[--n4];
            if (cacheEntry.pos <= n2) break;
            if (cacheEntry.tag != null) {
                if (cacheEntry.tag.includeInSearch()) {
                    throw new SourceCacheEntryMissingInternalError(this.tagType, tag, this);
                }
                cacheEntry.previousCached = true;
                cacheEntry.nextCached = true;
                continue;
            }
            cacheEntry.removed = true;
            n5 = Math.min(n5, cacheEntry.index);
        }
        if (cacheEntry.pos != n2) {
            throw new FoundCacheEntryMissingInternalError(this.tagType, tag, this);
        }
        cacheEntry.nextCached = true;
        this.compact(n5);
    }

    private void addNextTag(int n, Tag tag) {
        int n2;
        int n3 = n2 = tag == null ? this.eof.pos : tag.begin;
        if (n2 == n) {
            return;
        }
        int n4 = this.getIndexOfPos(n);
        CacheEntry cacheEntry = this.array[n4];
        int n5 = Integer.MAX_VALUE;
        if (cacheEntry.pos == n) {
            cacheEntry.nextCached = true;
            if (cacheEntry.isRedundant()) {
                cacheEntry.removed = true;
                n5 = Math.min(n5, cacheEntry.index);
            }
        } else if (!this.getPrevious((CacheEntry)cacheEntry).nextCached) {
            if (this.tagType == null) {
                this.cache.addTagAt(n, false);
            } else {
                this.addTagAt(n, null);
            }
            n4 = this.getIndexOfPos(n);
            cacheEntry = this.array[n4];
            if (cacheEntry.pos == n) {
                cacheEntry.nextCached = true;
                if (cacheEntry.isRedundant()) {
                    cacheEntry.removed = true;
                    n5 = Math.min(n5, cacheEntry.index);
                }
            }
        }
        if (cacheEntry.pos < n2) {
            while (true) {
                cacheEntry = this.array[++n4];
                if (cacheEntry.pos >= n2) break;
                if (cacheEntry.tag != null) {
                    if (cacheEntry.tag.includeInSearch()) {
                        throw new SourceCacheEntryMissingInternalError(this.tagType, tag, this);
                    }
                    cacheEntry.previousCached = true;
                    cacheEntry.nextCached = true;
                    continue;
                }
                cacheEntry.removed = true;
                n5 = Math.min(n5, cacheEntry.index);
            }
            if (cacheEntry.pos != n2) {
                throw new FoundCacheEntryMissingInternalError(this.tagType, tag, this);
            }
        }
        cacheEntry.previousCached = true;
        this.compact(n5);
    }

    private void compact(int n) {
        int n2 = this.lastIndex();
        int n3 = 1;
        while (n < n2) {
            CacheEntry cacheEntry = this.array[++n];
            if (cacheEntry.removed) {
                ++n3;
                continue;
            }
            cacheEntry.index = n - n3;
            this.array[cacheEntry.index] = cacheEntry;
        }
    }

    private void add(CacheEntry cacheEntry, CacheEntry cacheEntry2, CacheEntry cacheEntry3) {
        if (!cacheEntry2.isRedundant()) {
            this.insert(cacheEntry2);
        }
        if (cacheEntry2.previousCached) {
            cacheEntry.nextCached = true;
            if (cacheEntry.isRedundant()) {
                this.remove(cacheEntry);
            }
        }
        if (cacheEntry2.nextCached) {
            cacheEntry3.previousCached = true;
            if (cacheEntry3.isRedundant()) {
                this.remove(cacheEntry3);
            }
        }
    }

    private int getIndexOfPos(int n) {
        int n2 = 0;
        int n3 = this.lastIndex();
        int n4 = n3 >> 1;
        while (true) {
            CacheEntry cacheEntry;
            CacheEntry cacheEntry2 = this.array[n4];
            if (n > cacheEntry2.pos) {
                cacheEntry = this.getNext(cacheEntry2);
                if (n <= cacheEntry.pos) {
                    return cacheEntry.index;
                }
                n2 = cacheEntry.index;
            } else if (n < cacheEntry2.pos) {
                cacheEntry = this.getPrevious(cacheEntry2);
                if (n == cacheEntry.pos) {
                    return cacheEntry.index;
                }
                if (n > cacheEntry.pos) {
                    return n4;
                }
                n3 = cacheEntry.index;
            } else {
                return n4;
            }
            n4 = n2 + n3 >> 1;
        }
    }

    private CacheEntry getNext(CacheEntry cacheEntry) {
        return this.array[cacheEntry.index + 1];
    }

    private CacheEntry getPrevious(CacheEntry cacheEntry) {
        return this.array[cacheEntry.index - 1];
    }

    private int lastIndex() {
        return this.eof.index;
    }

    private void insert(CacheEntry cacheEntry) {
        int n = cacheEntry.index;
        if (this.array.length == this.size()) {
            this.doubleCapacity();
        }
        for (int i = this.lastIndex(); i >= n; --i) {
            CacheEntry cacheEntry2 = this.array[i];
            cacheEntry2.index = i + 1;
            this.array[cacheEntry2.index] = cacheEntry2;
        }
        this.array[n] = cacheEntry;
    }

    private void remove(CacheEntry cacheEntry) {
        int n = this.lastIndex();
        int n2 = cacheEntry.index;
        while (n2 < n) {
            CacheEntry cacheEntry2 = this.array[n2 + 1];
            cacheEntry2.index = n2++;
            this.array[cacheEntry2.index] = cacheEntry2;
        }
    }

    private void doubleCapacity() {
        CacheEntry[] cacheEntryArray = new CacheEntry[this.array.length << 1];
        for (int i = this.lastIndex(); i >= 0; --i) {
            cacheEntryArray[i] = this.array[i];
        }
        this.array = cacheEntryArray;
    }

    private static final class CacheEntry {
        public int index;
        public final int pos;
        public final Tag tag;
        public boolean previousCached;
        public boolean nextCached;
        public boolean removed = false;

        public CacheEntry(int n, int n2, Tag tag, boolean bl, boolean bl2) {
            this.index = n;
            this.pos = n2;
            this.tag = tag;
            this.previousCached = bl;
            this.nextCached = bl2;
        }

        public boolean isRedundant() {
            return this.tag == null && this.previousCached && this.nextCached;
        }

        public String toString() {
            return this.pad(this.index, 4) + " " + this.pad(this.pos, 5) + " " + (this.previousCached ? (char)'|' : '-') + ' ' + (this.nextCached ? (char)'|' : '-') + ' ' + (this.tag == null ? "null" : this.tag.getDebugInfo());
        }

        private String pad(int n, int n2) {
            String string2 = String.valueOf(n);
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = n2 - string2.length(); i > 0; --i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2);
            return stringBuilder.toString();
        }
    }

    private final class TagIterator
    implements Iterator<Tag> {
        private int i = 0;
        private Tag nextTag;

        public TagIterator() {
            this.loadNextTag();
        }

        @Override
        public boolean hasNext() {
            return this.nextTag != null;
        }

        @Override
        public Tag next() {
            Tag tag = this.nextTag;
            this.loadNextTag();
            return tag;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void loadNextTag() {
            while (++this.i <= SubCache.this.lastIndex() && (this.nextTag = ((SubCache)SubCache.this).array[this.i].tag) == null) {
            }
        }
    }

    private static class FoundCacheEntryMissingInternalError
    extends CacheEntryMissingInternalError {
        public FoundCacheEntryMissingInternalError(TagType tagType, Tag tag, SubCache subCache) {
            super(tagType, tag, subCache, "missing cache entry for found tag");
        }
    }

    private static class SourceCacheEntryMissingInternalError
    extends CacheEntryMissingInternalError {
        public SourceCacheEntryMissingInternalError(TagType tagType, Tag tag, SubCache subCache) {
            super(tagType, tag, subCache, "cache entry no longer found in source:");
        }
    }

    private static class CacheEntryMissingInternalError
    extends AssertionError {
        public CacheEntryMissingInternalError(TagType tagType, Tag tag, SubCache subCache, String string2) {
            super((Object)("INTERNAL ERROR: Inconsistent Cache State for TagType \"" + tagType + "\" - " + string2 + ' ' + tag.getDebugInfo() + '\n' + subCache));
        }
    }
}

