/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.HTMLElementTerminatingTagNameSets;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

public final class StartTag
extends Tag {
    private final Attributes attributes;
    final StartTagType startTagType;
    static final StartTag NOT_CACHED = (StartTag)Tag.NOT_CACHED;

    StartTag(Source source, int n, int n2, StartTagType startTagType, String string2, Attributes attributes) {
        super(source, n, n2, string2);
        this.attributes = attributes;
        this.startTagType = startTagType;
        if (attributes != null) {
            attributes.setStartTag(this);
        }
    }

    StartTag() {
        this.attributes = null;
        this.startTagType = null;
    }

    @Override
    public Element getElement() {
        if (this.element == Element.NOT_CACHED) {
            EndTag endTag2 = this.getEndTagInternal();
            this.element = new Element(this.source, this, endTag2);
            if (endTag2 != null) {
                if (endTag2.element != Element.NOT_CACHED && this.source.logger.isErrorEnabled() && !this.element.equals(endTag2.element)) {
                    this.source.logger.error(this.source.getRowColumnVector(endTag2.begin).appendTo(new StringBuilder(200).append("End tag ").append(endTag2).append(" at ")).append(" terminates more than one element").toString());
                }
                endTag2.element = this.element;
            }
        }
        return this.element;
    }

    public boolean isEmptyElementTag() {
        return this.isSyntacticalEmptyElementTag() && !HTMLElements.isClosingSlashIgnored(this.name);
    }

    public boolean isSyntacticalEmptyElementTag() {
        return this.startTagType == StartTagType.NORMAL && this.source.charAt(this.end - 2) == '/';
    }

    public StartTagType getStartTagType() {
        return this.startTagType;
    }

    @Override
    public TagType getTagType() {
        return this.startTagType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String string2) {
        return this.attributes == null ? null : this.attributes.getValue(string2);
    }

    @Override
    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int n) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int n2 = this.end - this.startTagType.getClosingDelimiter().length();
        int n3 = this.begin + 1 + this.name.length();
        while (!StartTag.isXMLNameStartChar(this.source.charAt(n3))) {
            if (++n3 != n2) continue;
            return null;
        }
        Attributes attributes = Attributes.construct(this.source, this.begin, n3, n2, this.startTagType, this.name, n);
        if (attributes != null) {
            attributes.setStartTag(this);
        }
        return attributes;
    }

    public Segment getTagContent() {
        return new Segment(this.source, this.begin + 1 + this.name.length(), this.end - this.startTagType.getClosingDelimiter().length());
    }

    public FormControl getFormControl() {
        return this.getElement().getFormControl();
    }

    public boolean isEndTagForbidden() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() == null;
        }
        if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return this.isSyntacticalEmptyElementTag();
    }

    public boolean isEndTagRequired() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() != null;
        }
        if (HTMLElements.getEndTagRequiredElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return !this.isSyntacticalEmptyElementTag();
    }

    @Override
    public boolean isUnregistered() {
        return this.startTagType == StartTagType.UNREGISTERED;
    }

    @Override
    public String tidy() {
        return this.tidy(false);
    }

    public String tidy(boolean bl) {
        if (this.attributes == null || this.attributes.containsServerTagOutsideOfAttributeValue) {
            return this.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        if (bl && this.startTagType == StartTagType.NORMAL) {
            stringBuilder.append(this.name);
        } else {
            int n;
            int n2 = n + this.name.length();
            for (n = this.begin + this.startTagType.startDelimiterPrefix.length(); n < n2; ++n) {
                stringBuilder.append(this.source.charAt(n));
            }
        }
        try {
            this.attributes.appendTidy(stringBuilder, this.getNextTag());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.startTagType == StartTagType.NORMAL && this.getElement().getEndTag() == null && !HTMLElements.getEndTagOptionalElementNames().contains(this.name)) {
            stringBuilder.append(" /");
        }
        stringBuilder.append(this.startTagType.getClosingDelimiter());
        return stringBuilder.toString();
    }

    public static String generateHTML(String string2, Map<String, String> map2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<').append(string2);
        try {
            Attributes.appendHTML(stringBuilder, map2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (bl) {
            stringBuilder.append(" />");
        } else {
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendDebugTag(stringBuilder);
        stringBuilder.append(' ');
        this.appendDebugTagType(stringBuilder);
        stringBuilder.append(super.getDebugInfo());
        return stringBuilder.toString();
    }

    StringBuilder appendDebugTag(StringBuilder stringBuilder) {
        if (this.startTagType == StartTagType.NORMAL && this.getAttributes().isEmpty()) {
            stringBuilder.append(this);
        } else {
            stringBuilder.append('<').append(this.getNameSegment()).append(' ');
            if (this.isSyntacticalEmptyElementTag()) {
                stringBuilder.append('/');
            }
            stringBuilder.append(this.startTagType.getClosingDelimiter());
        }
        return stringBuilder;
    }

    StringBuilder appendDebugTagType(StringBuilder stringBuilder) {
        if (this.startTagType != StartTagType.NORMAL) {
            stringBuilder.append('(').append(this.startTagType.getDescription()).append(") ");
        }
        return stringBuilder;
    }

    private EndTag getEndTagInternal() {
        Object object;
        boolean bl = true;
        EndTagType endTagType = this.startTagType.getCorrespondingEndTagType();
        if (this.startTagType == StartTagType.NORMAL) {
            boolean bl2 = bl = !HTMLElements.isClosingSlashIgnored(this.name);
            if (bl && this.isSyntacticalEmptyElementTag()) {
                return null;
            }
            if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
                return null;
            }
            object = HTMLElements.getTerminatingTagNameSets(this.name);
            if (object != null) {
                return this.getOptionalEndTag((HTMLElementTerminatingTagNameSets)object);
            }
        } else if (endTagType == null) {
            return null;
        }
        if ((object = this.source.getNextEndTag(this.end, endTagType.getEndTagName(this.name), endTagType)) != null) {
            if (this.startTagType == StartTagType.NORMAL && HTMLElements.END_TAG_REQUIRED_NESTING_FORBIDDEN_SET.contains(this.name)) {
                StartTag startTag2 = this.source.getNextStartTag(this.end, this.name);
                if (startTag2 == null || startTag2.begin > ((EndTag)object).begin) {
                    return object;
                }
                if (this.source.logger.isErrorEnabled()) {
                    this.source.logger.error(this.source.getRowColumnVector(this.begin).appendTo(new StringBuilder(200).append("StartTag at ")).append(" missing required end tag - invalid nested start tag encountered before end tag").toString());
                }
                return new EndTag(this.source, startTag2.begin, startTag2.begin, EndTagType.NORMAL, this.name);
            }
            Segment[] segmentArray = this.getEndTag((EndTag)object, bl, Tag.isXMLName(this.name));
            if (segmentArray != null) {
                return (EndTag)segmentArray[0];
            }
        }
        if (this.source.logger.isErrorEnabled()) {
            this.source.logger.error(this.source.getRowColumnVector(this.begin).appendTo(new StringBuilder(200).append("StartTag at ")).append(" missing required end tag").toString());
        }
        return null;
    }

    private EndTag getOptionalEndTag(HTMLElementTerminatingTagNameSets hTMLElementTerminatingTagNameSets) {
        Tag tag;
        int n = this.end;
        while (n < this.source.end && (tag = Tag.getNextTag(this.source, n)) != null) {
            Set<String> set;
            if (tag instanceof EndTag) {
                if (tag.name == this.name) {
                    return (EndTag)tag;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingEndTagNameSet;
            } else {
                set = hTMLElementTerminatingTagNameSets.NonterminatingElementNameSet;
                if (set != null && set.contains(tag.name)) {
                    Element element = ((StartTag)tag).getElement();
                    n = element.end;
                    continue;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingStartTagNameSet;
            }
            if (set != null && set.contains(tag.name)) {
                return new EndTag(this.source, tag.begin, tag.begin, EndTagType.NORMAL, this.name);
            }
            n = tag.begin + 1;
        }
        return new EndTag(this.source, this.source.end, this.source.end, EndTagType.NORMAL, this.name);
    }

    static String getStartDelimiter(String string2) {
        if (string2.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        String string3 = "<" + string2;
        if (string3.charAt("<".length()) == '/') {
            throw new IllegalArgumentException("searchName argument \"" + string2 + "\" must not start with '/'");
        }
        return string3;
    }

    static StartTag getPrevious(Source source, int n, String string2, StartTagType startTagType) {
        return StartTag.getPrevious(source, n, string2, startTagType, startTagType == StartTagType.NORMAL ? Tag.isXMLName(string2) : true);
    }

    static StartTag getPrevious(Source source, int n, String string2, StartTagType startTagType, boolean bl) {
        if (string2 == null) {
            return (StartTag)source.getPreviousTag(n, startTagType);
        }
        if (source.wasFullSequentialParseCalled() && bl) {
            StartTag startTag2 = (StartTag)Tag.getPreviousTag(source, n, startTagType);
            while (true) {
                if (startTag2 == null) {
                    return null;
                }
                if (startTag2.name.equals(string2)) {
                    return startTag2;
                }
                if (startTag2.name.startsWith(string2) && startTag2.isPartialNameSearchMatch(string2)) {
                    return startTag2;
                }
                if (startTag2.name.length() < string2.length() && source.getParseText().containsAt(string2, startTag2.begin + startTagType.startDelimiterPrefix.length())) {
                    return startTag2;
                }
                startTag2 = (StartTag)startTag2.getPreviousTag(startTagType);
            }
        }
        String string3 = StartTag.getStartDelimiter(string2);
        ParseText parseText = source.getParseText();
        int n2 = n;
        do {
            if ((n2 = parseText.lastIndexOf(string3, n2)) == -1) {
                return null;
            }
            StartTag startTag3 = (StartTag)Tag.getTagAt(source, n2, false);
            if (startTag3 == null || startTagType != startTag3.getStartTagType() && (startTagType != StartTagType.NORMAL || bl || !startTag3.isUnregistered()) || startTag3.getName().length() > string2.length() && !startTag3.isPartialNameSearchMatch(string2)) continue;
            return startTag3;
        } while ((n2 -= 2) >= 0);
        return null;
    }

    final boolean isPartialNameSearchMatch(String string2) {
        char c = string2.charAt(string2.length() - 1);
        return c == ':' || !StartTag.isXMLNameChar(c);
    }

    static StartTag getNext(Source source, int n, String string2, StartTagType startTagType) {
        return StartTag.getNext(source, n, string2, startTagType, startTagType == StartTagType.NORMAL ? Tag.isXMLName(string2) : true);
    }

    static StartTag getNext(Source source, int n, String string2, StartTagType startTagType, boolean bl) {
        if (string2 == null) {
            return (StartTag)source.getNextTag(n, startTagType);
        }
        if (source.wasFullSequentialParseCalled() && bl) {
            StartTag startTag2 = (StartTag)Tag.getNextTag(source, n, startTagType);
            while (true) {
                if (startTag2 == null) {
                    return null;
                }
                if (startTag2.name.equals(string2)) {
                    return startTag2;
                }
                if (startTag2.name.startsWith(string2) && startTag2.isPartialNameSearchMatch(string2)) {
                    return startTag2;
                }
                if (startTag2.name.length() < string2.length() && source.getParseText().containsAt(string2, startTag2.begin + startTagType.startDelimiterPrefix.length())) {
                    return startTag2;
                }
                startTag2 = (StartTag)startTag2.getNextTag(startTagType);
            }
        }
        String string3 = StartTag.getStartDelimiter(string2);
        try {
            ParseText parseText = source.getParseText();
            int n2 = n;
            do {
                if ((n2 = parseText.indexOf(string3, n2)) == -1) {
                    return null;
                }
                StartTag startTag3 = (StartTag)Tag.getTagAt(source, n2, false);
                if (startTag3 == null || startTagType != startTag3.getStartTagType() && (startTagType != StartTagType.NORMAL || bl || !startTag3.isUnregistered()) || startTag3.getName().length() > string2.length() && !startTag3.isPartialNameSearchMatch(string2)) continue;
                return startTag3;
            } while (++n2 < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static StartTag getPrevious(Source source, int n) {
        Tag tag = Tag.getPreviousTag(source, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof StartTag) {
            return (StartTag)tag;
        }
        return tag.getPreviousStartTag();
    }

    static StartTag getNext(Source source, int n) {
        Tag tag = Tag.getNextTag(source, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof StartTag) {
            return (StartTag)tag;
        }
        return tag.getNextStartTag();
    }

    static StartTag getNext(Source source, int n, String string2, String string3, boolean bl) {
        if (string3 == null || string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (source.wasFullSequentialParseCalled()) {
            StartTag startTag2 = source.getNextStartTag(n);
            while (true) {
                if (startTag2 == null) {
                    return null;
                }
                if (startTag2.hasAttribute(string2, string3, bl)) {
                    return startTag2;
                }
                startTag2 = startTag2.getNextStartTag();
            }
        }
        String string4 = string3.length() >= 3 || string3.length() > 0 && string2.length() < 3 ? string3 : string2;
        ParseText parseText = source.getParseText();
        int n2 = n;
        while (n2 < source.end) {
            StartTag startTag3;
            n2 = parseText.indexOf(string4.toLowerCase(), n2);
            if (n2 == -1) {
                return null;
            }
            Tag tag = source.getEnclosingTag(n2);
            if (tag == null || !(tag instanceof StartTag)) {
                ++n2;
                continue;
            }
            if (tag.begin >= n && (startTag3 = (StartTag)tag).hasAttribute(string2, string3, bl)) {
                return startTag3;
            }
            n2 = tag.end;
        }
        return null;
    }

    boolean hasAttribute(String string2, String string3, boolean bl) {
        if (this.attributes == null) {
            return false;
        }
        String string4 = this.attributes.getValue(string2);
        if (string4 == null) {
            return false;
        }
        if (string3.equals(string4)) {
            return true;
        }
        if ((!bl || this.source.logger.isWarnEnabled()) && string3.equalsIgnoreCase(string4)) {
            if (!bl) {
                return true;
            }
            if (this.source.logger.isWarnEnabled()) {
                this.source.logger.warn(this.getRowColumnVector().appendTo(new StringBuilder(200)).append(": StartTag with attribute ").append(string2).append("=\"").append(string4).append("\" ignored during search because its case does not match search value \"").append(string3).append('\"').toString());
            }
        }
        return false;
    }

    static StartTag getNext(Source source, int n, String string2, Pattern pattern) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (source.wasFullSequentialParseCalled()) {
            StartTag startTag2 = source.getNextStartTag(n);
            while (true) {
                if (startTag2 == null) {
                    return null;
                }
                if (startTag2.hasAttribute(string2, pattern)) {
                    return startTag2;
                }
                startTag2 = startTag2.getNextStartTag();
            }
        }
        String string3 = string2;
        ParseText parseText = source.getParseText();
        int n2 = n;
        while (n2 < source.end) {
            StartTag startTag3;
            n2 = parseText.indexOf(string3.toLowerCase(), n2);
            if (n2 == -1) {
                return null;
            }
            Tag tag = source.getEnclosingTag(n2);
            if (tag == null || !(tag instanceof StartTag)) {
                ++n2;
                continue;
            }
            if (tag.begin >= n && (startTag3 = (StartTag)tag).hasAttribute(string2, pattern)) {
                return startTag3;
            }
            n2 = tag.end;
        }
        return null;
    }

    boolean hasAttribute(String string2, Pattern pattern) {
        if (this.attributes == null) {
            return false;
        }
        Attribute attribute = this.attributes.get(string2);
        if (attribute == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        String string3 = attribute.getValue();
        return string3 != null && pattern.matcher(string3).matches();
    }

    private Segment[] getEndTag(EndTag endTag2, boolean bl, boolean bl2) {
        assert (endTag2 != null);
        StartTag startTag2 = StartTag.getNext(this.source, this.end, this.name, this.startTagType, bl2);
        if (bl) {
            while (startTag2 != null && startTag2.isSyntacticalEmptyElementTag()) {
                startTag2 = StartTag.getNext(this.source, startTag2.end, this.name, this.startTagType, bl2);
            }
        }
        return this.getEndTag(this.end, startTag2, endTag2, bl, bl2);
    }

    private Segment[] getEndTag(int n, StartTag startTag2, EndTag endTag2, boolean bl, boolean bl2) {
        if (endTag2 == null) {
            return null;
        }
        Segment[] segmentArray = new Segment[]{endTag2, startTag2};
        if (startTag2 == null || startTag2.begin > endTag2.begin) {
            return segmentArray;
        }
        Segment[] segmentArray2 = startTag2.getEndTag(endTag2, bl, bl2);
        if (segmentArray2 == null) {
            return null;
        }
        EndTag endTag3 = (EndTag)segmentArray2[0];
        EndTag endTag4 = EndTag.getNext(this.source, endTag3.end, endTag2.getName(), endTag2.getEndTagType());
        return this.getEndTag(endTag3.end, (StartTag)segmentArray2[1], endTag4, bl, bl2);
    }
}

