/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.NodeIterator;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.RowColumnVector;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;
import net.htmlparser.jericho.TextExtractor;
import net.htmlparser.jericho.URIAttributes;

public class Segment
implements Comparable<Segment>,
CharSequence {
    final int begin;
    final int end;
    final Source source;
    private static final char[] WHITESPACE = new char[]{' ', '\n', '\r', '\t', '\f', '\u200b'};

    public Segment(Source source, int n, int n2) {
        if (n == -1 || n2 == -1 || n > n2) {
            throw new IllegalArgumentException();
        }
        this.begin = n;
        this.end = n2;
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.source = source;
    }

    Segment(int n) {
        this.begin = 0;
        this.end = n;
        this.source = (Source)this;
    }

    Segment() {
        this(0, 0);
    }

    Segment(int n, int n2) {
        this.begin = n;
        this.end = n2;
        this.source = null;
    }

    public final Source getSource() {
        if (this.source.isStreamed()) {
            throw new UnsupportedOperationException("Source object is not available when using StreamedSource");
        }
        return this.source;
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getEnd() {
        return this.end;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Segment)) {
            return false;
        }
        Segment segment = (Segment)object;
        return segment.begin == this.begin && segment.end == this.end && segment.source == this.source;
    }

    public int hashCode() {
        return this.begin + this.end;
    }

    @Override
    public int length() {
        return this.end - this.begin;
    }

    public final boolean encloses(Segment segment) {
        return this.begin <= segment.begin && this.end >= segment.end;
    }

    public final boolean encloses(int n) {
        return this.begin <= n && n < this.end;
    }

    @Override
    public String toString() {
        return this.source.subSequence(this.begin, this.end).toString();
    }

    public Renderer getRenderer() {
        return new Renderer(this);
    }

    public TextExtractor getTextExtractor() {
        return new TextExtractor(this);
    }

    public Iterator<Segment> getNodeIterator() {
        return new NodeIterator(this);
    }

    public List<Tag> getAllTags() {
        return this.getAllTags(null);
    }

    public List<Tag> getAllTags(TagType tagType) {
        Tag tag = this.checkTagEnclosure(Tag.getNextTag(this.source, this.begin, tagType));
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        do {
            arrayList.add(tag);
        } while ((tag = this.checkTagEnclosure(tag.getNextTag(tagType))) != null);
        return arrayList;
    }

    public List<StartTag> getAllStartTags() {
        StartTag startTag2 = this.checkEnclosure(StartTag.getNext(this.source, this.begin));
        if (startTag2 == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        do {
            arrayList.add(startTag2);
        } while ((startTag2 = this.checkEnclosure(startTag2.getNextStartTag())) != null);
        return arrayList;
    }

    public List<StartTag> getAllStartTags(StartTagType startTagType) {
        if (startTagType == null) {
            return this.getAllStartTags();
        }
        StartTag startTag2 = (StartTag)this.checkTagEnclosure(Tag.getNextTag(this.source, this.begin, startTagType));
        if (startTag2 == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        do {
            arrayList.add(startTag2);
        } while ((startTag2 = (StartTag)this.checkTagEnclosure(startTag2.getNextTag(startTagType))) != null);
        return arrayList;
    }

    public List<StartTag> getAllStartTags(String string2) {
        if (string2 == null) {
            return this.getAllStartTags();
        }
        boolean bl = Tag.isXMLName(string2);
        StartTag startTag2 = this.checkEnclosure(StartTag.getNext(this.source, this.begin, string2 = string2.toLowerCase(), StartTagType.NORMAL, bl));
        if (startTag2 == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        if (this.source.wasFullSequentialParseCalled() && bl) {
            arrayList.add(startTag2);
            while ((startTag2 = this.checkEnclosure((StartTag)startTag2.getNextTag(StartTagType.NORMAL))) != null) {
                if (!startTag2.name.equals(string2) && (!startTag2.name.startsWith(string2) || !startTag2.isPartialNameSearchMatch(string2))) continue;
                arrayList.add(startTag2);
            }
        } else {
            do {
                arrayList.add(startTag2);
            } while ((startTag2 = this.checkEnclosure(StartTag.getNext(this.source, startTag2.begin + 1, string2, StartTagType.NORMAL, bl))) != null);
        }
        return arrayList;
    }

    public List<StartTag> getAllStartTags(String string2, String string3, boolean bl) {
        StartTag startTag2 = this.checkEnclosure(this.source.getNextStartTag(this.begin, string2, string3, bl));
        if (startTag2 == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        if (this.source.wasFullSequentialParseCalled()) {
            arrayList.add(startTag2);
            while ((startTag2 = this.checkEnclosure(startTag2.getNextStartTag())) != null) {
                if (!startTag2.hasAttribute(string2, string3, bl)) continue;
                arrayList.add(startTag2);
            }
        } else {
            do {
                arrayList.add(startTag2);
            } while ((startTag2 = this.checkEnclosure(this.source.getNextStartTag(startTag2.begin + 1, string2, string3, bl))) != null);
        }
        return arrayList;
    }

    public List<StartTag> getAllStartTags(String string2, Pattern pattern) {
        StartTag startTag2 = this.checkEnclosure(this.source.getNextStartTag(this.begin, string2, pattern));
        if (startTag2 == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        if (this.source.wasFullSequentialParseCalled()) {
            arrayList.add(startTag2);
            while ((startTag2 = this.checkEnclosure(startTag2.getNextStartTag())) != null) {
                if (!startTag2.hasAttribute(string2, pattern)) continue;
                arrayList.add(startTag2);
            }
        } else {
            do {
                arrayList.add(startTag2);
            } while ((startTag2 = this.checkEnclosure(this.source.getNextStartTag(startTag2.begin + 1, string2, pattern))) != null);
        }
        return arrayList;
    }

    public List<StartTag> getAllStartTagsByClass(String string2) {
        return this.getAllStartTags("class", Segment.getClassPattern(string2));
    }

    public List<Element> getChildElements() {
        StartTag startTag2;
        if (this.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = this.begin;
        while ((startTag2 = this.source.getNextStartTag(n)) != null && startTag2.begin < this.end) {
            if (startTag2.getTagType().isServerTag()) {
                n = startTag2.end;
                continue;
            }
            Element element = startTag2.getElement();
            arrayList.add(element);
            element.getChildElements();
            n = element.end;
        }
        return arrayList;
    }

    public List<Element> getAllElements() {
        return this.getAllElements(this.getAllStartTags());
    }

    public List<Element> getAllElements(String string2) {
        return this.getAllElements(this.getAllStartTags(string2));
    }

    public List<Element> getAllElements(StartTagType startTagType) {
        if (startTagType == null) {
            throw new IllegalArgumentException("startTagType argument must not be null");
        }
        return this.getAllElements(this.getAllStartTags(startTagType));
    }

    public List<Element> getAllElements(String string2, String string3, boolean bl) {
        return this.getAllElements(this.getAllStartTags(string2, string3, bl));
    }

    public List<Element> getAllElements(String string2, Pattern pattern) {
        return this.getAllElements(this.getAllStartTags(string2, pattern));
    }

    public List<Element> getAllElementsByClass(String string2) {
        return this.getAllElements(this.getAllStartTagsByClass(string2));
    }

    public List<CharacterReference> getAllCharacterReferences() {
        CharacterReference characterReference = this.getNextCharacterReference(this.begin);
        if (characterReference == null) {
            return Collections.emptyList();
        }
        ArrayList<CharacterReference> arrayList = new ArrayList<CharacterReference>();
        do {
            arrayList.add(characterReference);
        } while ((characterReference = this.getNextCharacterReference(characterReference.end)) != null);
        return arrayList;
    }

    public List<Attribute> getURIAttributes() {
        return URIAttributes.getList(this);
    }

    public List<Segment> getStyleURISegments() {
        return URIAttributes.getStyleURISegments(this);
    }

    public final StartTag getFirstStartTag() {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin));
    }

    public final StartTag getFirstStartTag(StartTagType startTagType) {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin, startTagType));
    }

    public final StartTag getFirstStartTag(String string2) {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin, string2));
    }

    public final StartTag getFirstStartTag(String string2, String string3, boolean bl) {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin, string2, string3, bl));
    }

    public final StartTag getFirstStartTag(String string2, Pattern pattern) {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin, string2, pattern));
    }

    public final StartTag getFirstStartTagByClass(String string2) {
        return this.checkEnclosure(this.source.getNextStartTagByClass(this.begin, string2));
    }

    public final Element getFirstElement() {
        StartTag startTag2 = this.checkEnclosure(StartTag.getNext(this.source, this.begin));
        while (startTag2 != null) {
            Element element = startTag2.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag2 = this.checkEnclosure(startTag2.getNextStartTag());
        }
        return null;
    }

    public final Element getFirstElement(String string2) {
        if (string2 == null) {
            return this.getFirstElement();
        }
        boolean bl = Tag.isXMLName(string2);
        string2 = string2.toLowerCase();
        StartTag startTag2 = this.checkEnclosure(StartTag.getNext(this.source, this.begin, string2, StartTagType.NORMAL, bl));
        while (startTag2 != null) {
            Element element = startTag2.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag2 = this.checkEnclosure(StartTag.getNext(this.source, startTag2.begin + 1, string2, StartTagType.NORMAL, bl));
        }
        return null;
    }

    public final Element getFirstElement(String string2, String string3, boolean bl) {
        StartTag startTag2 = this.checkEnclosure(this.source.getNextStartTag(this.begin, string2, string3, bl));
        while (startTag2 != null) {
            Element element = startTag2.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag2 = this.checkEnclosure(this.source.getNextStartTag(startTag2.begin + 1, string2, string3, bl));
        }
        return null;
    }

    public final Element getFirstElement(String string2, Pattern pattern) {
        StartTag startTag2 = this.checkEnclosure(this.source.getNextStartTag(this.begin, string2, pattern));
        while (startTag2 != null) {
            Element element = startTag2.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag2 = this.checkEnclosure(this.source.getNextStartTag(startTag2.begin + 1, string2, pattern));
        }
        return null;
    }

    public final Element getFirstElementByClass(String string2) {
        StartTag startTag2 = this.checkEnclosure(this.source.getNextStartTagByClass(this.begin, string2));
        while (startTag2 != null) {
            Element element = startTag2.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag2 = this.checkEnclosure(this.source.getNextStartTagByClass(startTag2.begin + 1, string2));
        }
        return null;
    }

    public List<FormControl> getFormControls() {
        return FormControl.getAll(this);
    }

    public FormFields getFormFields() {
        return new FormFields(this.getFormControls());
    }

    public Attributes parseAttributes() {
        return this.source.parseAttributes(this.begin, this.end);
    }

    public void ignoreWhenParsing() {
        this.source.ignoreWhenParsing(this.begin, this.end);
    }

    @Override
    public int compareTo(Segment segment) {
        if (this == segment) {
            return 0;
        }
        if (this.begin < segment.begin) {
            return -1;
        }
        if (this.begin > segment.begin) {
            return 1;
        }
        if (this.end < segment.end) {
            return -1;
        }
        if (this.end > segment.end) {
            return 1;
        }
        return 0;
    }

    public final boolean isWhiteSpace() {
        for (int i = this.begin; i < this.end; ++i) {
            if (Segment.isWhiteSpace(this.source.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int getMaxDepthIndicator() {
        int n = 0;
        int n2 = 0;
        for (Tag tag : this.getAllTags()) {
            if (tag instanceof StartTag) {
                StartTag startTag2 = (StartTag)tag;
                if (startTag2.getStartTagType().getCorrespondingEndTagType() == null || HTMLElements.getEndTagForbiddenElementNames().contains(startTag2.getName()) || startTag2.isEmptyElementTag() || ++n2 <= n) continue;
                ++n;
                continue;
            }
            --n2;
        }
        return n;
    }

    public static final boolean isWhiteSpace(char c) {
        for (char c2 : WHITESPACE) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    public RowColumnVector getRowColumnVector() {
        return this.source.getRowColumnVector(this.begin);
    }

    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append('(');
        this.source.getRowColumnVector(this.begin).appendTo(stringBuilder);
        stringBuilder.append('-');
        this.source.getRowColumnVector(this.end).appendTo(stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public char charAt(int n) {
        return this.source.charAt(this.begin + n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.source.subSequence(this.begin + n, this.begin + n2);
    }

    static final StringBuilder appendCollapseWhiteSpace(StringBuilder stringBuilder, CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        boolean bl = false;
        while (true) {
            if (n2 >= n) {
                return stringBuilder;
            }
            if (!Segment.isWhiteSpace(charSequence.charAt(n2))) break;
            ++n2;
        }
        do {
            char c;
            if (Segment.isWhiteSpace(c = charSequence.charAt(n2++))) {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(' ');
                bl = false;
            }
            stringBuilder.append(c);
        } while (n2 < n);
        return stringBuilder;
    }

    static final Pattern getClassPattern(String string2) {
        return Pattern.compile(".*(\\s|^)" + string2 + "(\\s|$).*", 32);
    }

    private List<Element> getAllElements(List<StartTag> list2) {
        if (list2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(list2.size());
        for (StartTag startTag2 : list2) {
            Element element = startTag2.getElement();
            if (element.end > this.end) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    private StartTag checkEnclosure(StartTag startTag2) {
        if (startTag2 == null || startTag2.end > this.end) {
            return null;
        }
        return startTag2;
    }

    private Tag checkTagEnclosure(Tag tag) {
        if (tag == null || tag.end > this.end) {
            return null;
        }
        return tag;
    }

    private CharacterReference getNextCharacterReference(int n) {
        CharacterReference characterReference = this.source.getNextCharacterReference(n);
        if (characterReference == null || characterReference.end > this.end) {
            return null;
        }
        return characterReference;
    }
}

