/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.HashMap;
import java.util.Map;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;

final class RendererCSS {
    private static Map<String, Float> UNIT_FACTOR = new HashMap<String, Float>();

    RendererCSS() {
    }

    public static int getTopMargin(Element element, int n) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.top, n);
    }

    public static int getBottomMargin(Element element, int n) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.bottom, n);
    }

    public static int getLeftMargin(Element element, int n) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.left, n);
    }

    public static int getRightMargin(Element element, int n) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.right, n);
    }

    private static String get(Element element) {
        return element.getAttributeValue("style");
    }

    private static int getMargin(String string2, Side side, int n) {
        int n2;
        if (string2 == null) {
            return n;
        }
        String[] stringArray = string2.split(";");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = stringArray[n2].toLowerCase().trim();
        }
        n2 = RendererCSS.getStyleValue(stringArray, side, "margin");
        int n3 = RendererCSS.getStyleValue(stringArray, side, "padding");
        if (n2 == -1) {
            return n3 != -1 ? n3 : n;
        }
        return n3 != -1 ? n2 + n3 : n2;
    }

    private static int getStyleValue(String[] stringArray, Side side, String string2) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            int n2;
            String string4 = stringArray[i];
            if (string4.length() <= string2.length() + 1 || !string4.startsWith(string2) || (n2 = string4.indexOf(58)) == -1 || (string3 = string4.substring(n2 + 1).trim()).length() == 0) continue;
            boolean bl = false;
            int n3 = string2.length();
            if (string4.charAt(string2.length()) == '-' && string4.startsWith(side.name(), string2.length() + 1)) {
                bl = true;
                n3 = string2.length() + 1 + side.name().length();
                if (string4.length() <= n3 + 1) continue;
            }
            if (n3 != n2 && !Segment.isWhiteSpace(string4.charAt(n3))) continue;
            if (!bl) {
                String[] stringArray2 = string3.split("\\s+");
                int n4 = side.ordinal();
                int n5 = stringArray2.length;
                if (n5 == 0) continue;
                if (n5 == 1) {
                    n4 = 0;
                } else if (n5 == 2) {
                    n4 = side.ordinal() % 2;
                } else if (n5 == 3 && side == Side.left) {
                    n4 = 1;
                }
                string3 = stringArray2[n4].trim();
            }
            int n6 = 0;
            if (string3.length() == 0 || string3.charAt(string3.length() - 1) == '%' || string3.equals("auto") || string3.equals("inherit")) continue;
            if (string3.length() < 3) {
                if (!string3.equals("0")) {
                    continue;
                }
            } else {
                float f;
                Float f2 = UNIT_FACTOR.get(string3.substring(string3.length() - 2));
                if (f2 == null) continue;
                try {
                    f = Float.parseFloat(string3.substring(0, string3.length() - 2));
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                n6 = Math.round(f * f2.floatValue());
            }
            if (bl) {
                return n6;
            }
            n = n6;
        }
        return n;
    }

    static {
        UNIT_FACTOR.put("em", Float.valueOf(1.0f));
        UNIT_FACTOR.put("ex", Float.valueOf(1.0f));
        UNIT_FACTOR.put("px", Float.valueOf(0.125f));
        UNIT_FACTOR.put("in", Float.valueOf(8.0f));
        UNIT_FACTOR.put("cm", Float.valueOf(3.0f));
        UNIT_FACTOR.put("mm", Float.valueOf(0.3f));
        UNIT_FACTOR.put("pt", Float.valueOf(0.1f));
        UNIT_FACTOR.put("pc", Float.valueOf(1.2f));
    }

    private static enum Side {
        top,
        right,
        bottom,
        left;

    }
}

