/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Source;

public class NumericCharacterReference
extends CharacterReference {
    private boolean hex;

    private NumericCharacterReference(Source source, int n, int n2, int n3, boolean bl) {
        super(source, n, n2, n3);
        this.hex = bl;
    }

    public boolean isDecimal() {
        return !this.hex;
    }

    public boolean isHexadecimal() {
        return this.hex;
    }

    public static String encode(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() * 2);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (Config.CurrentCharacterReferenceEncodingBehaviour.isEncoded(c, true)) {
                try {
                    NumericCharacterReference.appendDecimalCharacterReferenceString(stringBuilder, c);
                    continue;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String encodeDecimal(CharSequence charSequence) {
        return NumericCharacterReference.encode(charSequence);
    }

    public static String encodeHexadecimal(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() * 2);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (Config.CurrentCharacterReferenceEncodingBehaviour.isEncoded(c, true)) {
                try {
                    NumericCharacterReference.appendHexadecimalCharacterReferenceString(stringBuilder, c);
                    continue;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getCharacterReferenceString() {
        return this.hex ? NumericCharacterReference.getHexadecimalCharacterReferenceString(this.codePoint) : NumericCharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getCharacterReferenceString(int n) {
        return NumericCharacterReference.getDecimalCharacterReferenceString(n);
    }

    static CharacterReference construct(Source source, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        int n2;
        int n3;
        boolean bl;
        block13: {
            String string2;
            int n4;
            ParseText parseText = source.getParseText();
            bl = parseText.charAt(n4 = n + 2) == 'x';
            if (bl) {
                ++n4;
            }
            int n5 = bl ? unterminatedCharacterReferenceSettings.hexadecimalCharacterReferenceMaxCodePoint : unterminatedCharacterReferenceSettings.decimalCharacterReferenceMaxCodePoint;
            int n6 = source.end - 1;
            int n7 = n4;
            boolean bl2 = false;
            while (true) {
                if ((n3 = parseText.charAt(n7)) == 59) {
                    n2 = n7 + 1;
                    string2 = source.substring(n4, n7);
                    break;
                }
                if (n3 >= 48 && n3 <= 57 || bl && (n3 >= 97 && n3 <= 102 || n3 >= 65 && n3 <= 70)) {
                    if (n7 == n6) {
                        bl2 = true;
                        ++n7;
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    if (n5 == -1) {
                        return null;
                    }
                    n2 = n7;
                    string2 = source.substring(n4, n7);
                    break;
                }
                ++n7;
            }
            if (string2.length() == 0) {
                return null;
            }
            n3 = -1;
            try {
                n3 = Integer.parseInt(string2, bl ? 16 : 10);
                if (bl2 && n3 > n5) {
                    return null;
                }
                if (n3 > 0x10FFFF) {
                    n3 = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!bl2) break block13;
                return null;
            }
        }
        return new NumericCharacterReference(source, n, n2, n3, bl);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        try {
            if (this.hex) {
                NumericCharacterReference.appendHexadecimalCharacterReferenceString(stringBuilder, this.codePoint);
            } else {
                NumericCharacterReference.appendDecimalCharacterReferenceString(stringBuilder, this.codePoint);
            }
            stringBuilder.append("\" ");
            NumericCharacterReference.appendUnicodeText(stringBuilder, this.codePoint);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        stringBuilder.append(' ').append(super.getDebugInfo());
        return stringBuilder.toString();
    }
}

