/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.LoggerProvider;
import org.apache.commons.logging.LogFactory;

final class LoggerFactory {
    private static LoggerProvider defaultLoggerProvider = null;

    LoggerFactory() {
    }

    public static Logger getLogger(String string2) {
        return LoggerFactory.getLoggerProvider().getLogger(string2);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static LoggerProvider getLoggerProvider() {
        return Config.LoggerProvider != null ? Config.LoggerProvider : LoggerFactory.getDefaultLoggerProvider();
    }

    private static LoggerProvider getDefaultLoggerProvider() {
        if (defaultLoggerProvider == null) {
            defaultLoggerProvider = LoggerFactory.determineDefaultLoggerProvider();
        }
        return defaultLoggerProvider;
    }

    private static LoggerProvider determineDefaultLoggerProvider() {
        if (LoggerFactory.isClassAvailable("org.slf4j.impl.StaticLoggerBinder")) {
            if (LoggerFactory.isClassAvailable("org.slf4j.impl.JDK14LoggerFactory")) {
                return LoggerProvider.JAVA;
            }
            if (LoggerFactory.isClassAvailable("org.slf4j.impl.Log4jLoggerFactory")) {
                return LoggerProvider.LOG4J;
            }
            if (!LoggerFactory.isClassAvailable("org.slf4j.impl.JCLLoggerFactory")) {
                return LoggerProvider.SLF4J;
            }
        }
        if (LoggerFactory.isClassAvailable("org.apache.commons.logging.Log")) {
            String string2 = LogFactory.getLog((String)"test").getClass().getName();
            if (string2.equals("org.apache.commons.logging.impl.Jdk14Logger")) {
                return LoggerProvider.JAVA;
            }
            if (string2.equals("org.apache.commons.logging.impl.Log4JLogger")) {
                return LoggerProvider.LOG4J;
            }
            return LoggerProvider.JCL;
        }
        if (LoggerFactory.isClassAvailable("org.apache.log4j.Logger")) {
            return LoggerProvider.LOG4J;
        }
        return LoggerProvider.JAVA;
    }

    private static boolean isClassAvailable(String string2) {
        try {
            Class.forName(string2);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

