/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

public final class EndTag
extends Tag {
    private final EndTagType endTagType;

    EndTag(Source source, int n, int n2, EndTagType endTagType, String string2) {
        super(source, n, n2, string2);
        this.endTagType = endTagType;
    }

    @Override
    public Element getElement() {
        StartTag startTag2;
        if (this.element != Element.NOT_CACHED) {
            return this.element;
        }
        int n = this.begin;
        while (n != 0 && (startTag2 = this.source.getPreviousStartTag(n - 1)) != null) {
            Element element = startTag2.getElement();
            if (element.getEndTag() == this) {
                return element;
            }
            n = startTag2.begin;
        }
        this.element = null;
        return null;
    }

    public EndTagType getEndTagType() {
        return this.endTagType;
    }

    @Override
    public TagType getTagType() {
        return this.endTagType;
    }

    @Override
    public boolean isUnregistered() {
        return this.endTagType == EndTagType.UNREGISTERED;
    }

    @Override
    public String tidy() {
        int n;
        String string2 = this.toString();
        if (this.endTagType != EndTagType.NORMAL) {
            return string2;
        }
        if (!CharacterReference.isWhiteSpace(string2.charAt(string2.length() - 2))) {
            return string2;
        }
        for (n = string2.length() - 3; n > 0 && CharacterReference.isWhiteSpace(string2.charAt(n)); --n) {
        }
        return string2.substring(0, n + 1) + '>';
    }

    public static String generateHTML(String string2) {
        return EndTagType.NORMAL.generateHTML(string2);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this).append(' ');
        if (this.endTagType != EndTagType.NORMAL) {
            stringBuilder.append('(').append(this.endTagType.getDescription()).append(") ");
        }
        stringBuilder.append(super.getDebugInfo());
        return stringBuilder.toString();
    }

    static EndTag getPrevious(Source source, int n, String string2, EndTagType endTagType) {
        if (string2 == null) {
            return (EndTag)Tag.getPreviousTag(source, n, endTagType);
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("name argument must not be zero length");
        }
        if (source.wasFullSequentialParseCalled()) {
            EndTag endTag2 = (EndTag)Tag.getPreviousTag(source, n, endTagType);
            while (true) {
                if (endTag2 == null) {
                    return null;
                }
                if (endTag2.name.equals(string2)) {
                    return endTag2;
                }
                endTag2 = (EndTag)endTag2.getPreviousTag(endTagType);
            }
        }
        String string3 = "</" + string2;
        ParseText parseText = source.getParseText();
        int n2 = n;
        do {
            if ((n2 = parseText.lastIndexOf(string3, n2)) == -1) {
                return null;
            }
            EndTag endTag3 = (EndTag)source.getTagAt(n2);
            if (endTag3 == null || endTag3.getEndTagType() != endTagType || !string2.equals(endTag3.getName())) continue;
            return endTag3;
        } while (--n2 >= 0);
        return null;
    }

    static EndTag getNext(Source source, int n, String string2, EndTagType endTagType) {
        if (string2 == null) {
            return (EndTag)Tag.getNextTag(source, n, endTagType);
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("name argument must not be zero length");
        }
        if (source.wasFullSequentialParseCalled()) {
            EndTag endTag2 = (EndTag)Tag.getNextTag(source, n, endTagType);
            while (true) {
                if (endTag2 == null) {
                    return null;
                }
                if (endTag2.name.equals(string2)) {
                    return endTag2;
                }
                endTag2 = (EndTag)endTag2.getNextTag(endTagType);
            }
        }
        String string3 = "</" + string2;
        try {
            ParseText parseText = source.getParseText();
            int n2 = n;
            do {
                if ((n2 = parseText.indexOf(string3, n2)) == -1) {
                    return null;
                }
                EndTag endTag3 = (EndTag)source.getTagAt(n2);
                if (endTag3 == null || endTag3.getEndTagType() != endTagType || !string2.equals(endTag3.getName())) continue;
                return endTag3;
            } while (++n2 < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static EndTag getPrevious(Source source, int n) {
        Tag tag = Tag.getPreviousTag(source, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof EndTag) {
            return (EndTag)tag;
        }
        return tag.getPreviousEndTag();
    }

    static EndTag getNext(Source source, int n) {
        Tag tag = Tag.getNextTag(source, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof EndTag) {
            return (EndTag)tag;
        }
        return tag.getNextEndTag();
    }
}

