/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.ParseText;

class CharSequenceParseText
implements ParseText {
    private final CharSequence charSequence;

    CharSequenceParseText(CharSequence charSequence) {
        this.charSequence = charSequence;
    }

    @Override
    public final char charAt(int n) {
        char c = this.internalCharAt(n);
        if (c == '\uffff' && this.atEndOfStream()) {
            throw new IndexOutOfBoundsException();
        }
        return c;
    }

    private char internalCharAt(int n) {
        char c = this.charSequence.charAt(n);
        return c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c;
    }

    @Override
    public final boolean containsAt(String string2, int n) {
        for (int i = 0; i < string2.length(); ++i) {
            char c = this.internalCharAt(n + i);
            if (c == '\uffff' && this.atEndOfStream()) {
                return false;
            }
            if (string2.charAt(i) == c) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(char c, int n) {
        return this.indexOf(c, n, -1);
    }

    @Override
    public final int indexOf(char c, int n, int n2) {
        int n3;
        int n4 = n2 == -1 || n2 > this.getEnd() ? this.getEnd() : n2;
        int n5 = n3 = n < 0 ? 0 : n;
        while (n3 < n4) {
            char c2 = this.internalCharAt(n3);
            if (c2 == c) {
                return n3;
            }
            if (c2 == '\uffff' && this.atEndOfStream()) break;
            ++n3;
        }
        return -1;
    }

    protected boolean atEndOfStream() {
        return false;
    }

    @Override
    public final int indexOf(String string2, int n) {
        return this.indexOf(string2, n, -1);
    }

    @Override
    public final int indexOf(String string2, int n, int n2) {
        char c;
        int n3;
        if (string2.length() == 1) {
            return this.indexOf(string2.charAt(0), n, n2);
        }
        if (string2.length() == 0) {
            return n;
        }
        char c2 = string2.charAt(0);
        int n4 = this.getEnd() - string2.length() + 1;
        int n5 = n2 == -1 || n2 > n4 ? n4 : n2;
        int n6 = n3 = n < 0 ? 0 : n;
        while (!(n3 >= n5 || (c = this.internalCharAt(n3)) == '\uffff' && this.atEndOfStream())) {
            block6: {
                if (c == c2) {
                    for (int i = 1; i < string2.length(); ++i) {
                        char c3 = this.internalCharAt(i + n3);
                        if (!(c == '\uffff' && this.atEndOfStream() || string2.charAt(i) != c3)) {
                            continue;
                        }
                        break block6;
                    }
                    return n3;
                }
            }
            ++n3;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(char c, int n) {
        return this.lastIndexOf(c, n, -1);
    }

    @Override
    public final int lastIndexOf(char c, int n, int n2) {
        int n3;
        int n4 = n3 = n > this.getEnd() ? this.getEnd() : n;
        while (n3 > n2) {
            if (this.internalCharAt(n3) == c) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(String string2, int n) {
        return this.lastIndexOf(string2, n, -1);
    }

    @Override
    public final int lastIndexOf(String string2, int n, int n2) {
        if (string2.length() == 1) {
            return this.lastIndexOf(string2.charAt(0), n, n2);
        }
        if (string2.length() == 0) {
            return n;
        }
        int n3 = this.getEnd() - string2.length();
        if (n2 > n3) {
            return -1;
        }
        if (n > n3) {
            n = n3;
        }
        int n4 = string2.length() - 1;
        char c = string2.charAt(n4);
        int n5 = n2 + n4;
        block0: for (int i = n + n4; i > n5; --i) {
            if (this.internalCharAt(i) != c) continue;
            int n6 = i - n4;
            for (int j = n4 - 1; j >= 0; --j) {
                if (string2.charAt(j) != this.internalCharAt(j + n6)) continue block0;
            }
            return n6;
        }
        return -1;
    }

    @Override
    public final int length() {
        return this.charSequence.length();
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    @Override
    public final String toString() {
        return this.charSequence.toString();
    }

    protected int getEnd() {
        return this.charSequence.length();
    }

    protected String substring(int n, int n2) {
        return this.charSequence.subSequence(n, n2).toString().toLowerCase();
    }
}

