/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.util;

import com.ibm.icu.text.Transliterator;
import java.util.regex.Pattern;

public final class StringNormalizer {
    private static final Pattern CLEAN_SURPLUS_SPACES = Pattern.compile("\\s+");
    private static final Pattern CLEAN_PUNCTUATION_PATTERN = Pattern.compile("[\\p{Punct}\\u2013]+");
    private static final Transliterator TRANSLITERATOR = Transliterator.getInstance("Greek-Latin/UNGEGN; Cyrillic-Latin; nfd; [:Nonspacing Mark:] remove; nfc; Lower");

    private StringNormalizer() {
    }

    public static String normalize(String input2) {
        String result2 = CLEAN_PUNCTUATION_PATTERN.matcher(input2).replaceAll(" ");
        result2 = TRANSLITERATOR.transliterate(result2);
        result2 = CLEAN_SURPLUS_SPACES.matcher(result2).replaceAll(" ");
        return result2.trim();
    }
}

