/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.settings;

import eu.europeana.normalization.languages.LanguagesVocabulary;
import eu.europeana.normalization.settings.AmbiguityHandling;
import eu.europeana.normalization.settings.CleanMarkupTagsMode;
import eu.europeana.normalization.settings.LanguageElement;
import eu.europeana.normalization.util.NormalizationConfigurationException;
import java.util.Arrays;

public class NormalizerSettings {
    protected static final float DEFAULT_MINIMUM_CONFIDENCE = 0.95f;
    protected static final LanguagesVocabulary DEFAULT_VOCABULARY = LanguagesVocabulary.ISO_639_3;
    protected static final LanguageElement[] DEFAULT_LANGUAGE_ELEMENTS = new LanguageElement[]{LanguageElement.DC_LANGUAGE};
    protected static final int DEFAULT_MIN_LANGUAGE_LABEL_LENGTH = 4;
    protected static final AmbiguityHandling DEFAULT_LANGUAGE_AMBIGUITY_HANDLING = AmbiguityHandling.NO_MATCH;
    protected static final CleanMarkupTagsMode DEFAULT_CLEAN_MARKUP_TAGS_MODE = CleanMarkupTagsMode.ALL_MARKUP;
    private float minimumConfidence = 0.95f;
    private LanguagesVocabulary targetLanguageVocabulary = DEFAULT_VOCABULARY;
    private LanguageElement[] elementsToNormalize = DEFAULT_LANGUAGE_ELEMENTS;
    private int minLanguageLabelLength = 4;
    private AmbiguityHandling languageAmbiguityHandling = DEFAULT_LANGUAGE_AMBIGUITY_HANDLING;
    private CleanMarkupTagsMode cleanMarkupTagsMode = DEFAULT_CLEAN_MARKUP_TAGS_MODE;

    public NormalizerSettings setMinimumConfidence(float minimumConfidence) throws NormalizationConfigurationException {
        if (minimumConfidence < 0.0f || minimumConfidence > 1.0f) {
            throw new NormalizationConfigurationException("Minimum confidence must be a number between 0 and 1 (inclusive).", null);
        }
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public float getMinimumConfidence() {
        return this.minimumConfidence;
    }

    public NormalizerSettings setLanguageElementsToNormalize(LanguageElement ... elementsToNormalize) throws NormalizationConfigurationException {
        if (elementsToNormalize == null) {
            throw new NormalizationConfigurationException("Provided setting is null", null);
        }
        this.elementsToNormalize = Arrays.copyOf(elementsToNormalize, elementsToNormalize.length);
        return this;
    }

    public LanguageElement[] getLanguageElementsToNormalize() {
        return Arrays.copyOf(this.elementsToNormalize, this.elementsToNormalize.length);
    }

    public NormalizerSettings setTargetLanguageVocabulary(LanguagesVocabulary targetLanguageVocabulary) throws NormalizationConfigurationException {
        if (targetLanguageVocabulary == null) {
            throw new NormalizationConfigurationException("Provided vocabulary is null", null);
        }
        this.targetLanguageVocabulary = targetLanguageVocabulary;
        return this;
    }

    public LanguagesVocabulary getTargetLanguageVocabulary() {
        return this.targetLanguageVocabulary;
    }

    public NormalizerSettings setMinLanguageLabelLength(int minLanguageLabelLength) {
        this.minLanguageLabelLength = Math.max(minLanguageLabelLength, 0);
        return this;
    }

    public int getMinLanguageLabelLength() {
        return this.minLanguageLabelLength;
    }

    public NormalizerSettings setLanguageAmbiguityHandling(AmbiguityHandling languageAmbiguityHandling) throws NormalizationConfigurationException {
        if (languageAmbiguityHandling == null) {
            throw new NormalizationConfigurationException("Provided ambiguity strategy is null", null);
        }
        this.languageAmbiguityHandling = languageAmbiguityHandling;
        return this;
    }

    public AmbiguityHandling getLanguageAmbiguityHandling() {
        return this.languageAmbiguityHandling;
    }

    public NormalizerSettings setCleanMarkupTagsMode(CleanMarkupTagsMode cleanMarkupTagsMode) throws NormalizationConfigurationException {
        if (cleanMarkupTagsMode == null) {
            throw new NormalizationConfigurationException("Provided mode is null", null);
        }
        this.cleanMarkupTagsMode = cleanMarkupTagsMode;
        return this;
    }

    public CleanMarkupTagsMode getCleanMarkupTagsMode() {
        return this.cleanMarkupTagsMode;
    }
}

