/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.normalizers;

import eu.europeana.normalization.model.ConfidenceLevel;
import eu.europeana.normalization.model.NormalizationReport;
import eu.europeana.normalization.normalizers.InternalNormalizationReport;
import eu.europeana.normalization.normalizers.NormalizedValueWithConfidence;
import eu.europeana.normalization.normalizers.RecordNormalizeAction;
import eu.europeana.normalization.normalizers.ValueNormalizeAction;
import eu.europeana.normalization.util.Namespace;
import eu.europeana.normalization.util.NormalizationException;
import eu.europeana.normalization.util.XmlUtil;
import eu.europeana.normalization.util.XpathQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValueNormalizeActionWrapper
implements RecordNormalizeAction {
    private final List<XpathQuery> targetElements = new ArrayList<XpathQuery>();
    private final ValueNormalizeAction normalization;

    ValueNormalizeActionWrapper(ValueNormalizeAction normalization, XpathQuery ... targetElements) {
        this.normalization = normalization;
        Collections.addAll(this.targetElements, targetElements);
    }

    private void normalizeAttribute(Attr attribute, InternalNormalizationReport report) {
        String value2 = attribute.getValue();
        List<NormalizedValueWithConfidence> normalizedValue = this.normalization.normalizeValue(value2);
        if (normalizedValue.isEmpty() || normalizedValue.size() > 1) {
            attribute.getParentNode().getAttributes().removeNamedItemNS(attribute.getNamespaceURI(), attribute.getLocalName());
            report.increment(this.normalization.getClass().getSimpleName(), ConfidenceLevel.CERTAIN);
        } else {
            boolean valueChanged;
            boolean bl = valueChanged = !normalizedValue.get(0).getNormalizedValue().equals(value2);
            if (valueChanged) {
                attribute.setValue(normalizedValue.get(0).getNormalizedValue());
                report.increment(this.normalization.getClass().getSimpleName(), normalizedValue.get(0).getConfidenceClass());
            }
        }
    }

    private void normalizeElement(Element element, InternalNormalizationReport report) {
        String value2 = XmlUtil.getElementText(element);
        List<NormalizedValueWithConfidence> normalizedValues = this.normalization.normalizeValue(value2);
        if (normalizedValues.isEmpty()) {
            this.removeElement(element);
            report.increment(this.normalization.getClass().getSimpleName(), ConfidenceLevel.CERTAIN);
        } else {
            boolean valueChanged;
            boolean bl = valueChanged = normalizedValues.size() > 1 || !normalizedValues.get(0).getNormalizedValue().equals(value2);
            if (valueChanged) {
                this.updateElement(element, normalizedValues, report);
            }
        }
    }

    private void removeElement(Element element) {
        if (element.getAttributes().getLength() == 0 || element.getAttributes().getLength() == 1 && !StringUtils.isEmpty(element.getAttributeNS(Namespace.XML.getUri(), "lang"))) {
            element.getParentNode().removeChild(element);
        } else {
            NodeList childNodes = element.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node childNode = childNodes.item(j);
                if (childNode.getNodeType() != 3) continue;
                element.removeChild(childNode);
            }
        }
    }

    private void updateElement(Element element, List<NormalizedValueWithConfidence> normalizedValues, InternalNormalizationReport report) {
        NodeList childNodes = element.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() != 3) continue;
            element.removeChild(childNode);
        }
        element.appendChild(element.getOwnerDocument().createTextNode(normalizedValues.get(0).getNormalizedValue()));
        report.increment(this.normalization.getClass().getSimpleName(), normalizedValues.get(0).getConfidenceClass());
        if (normalizedValues.size() > 1) {
            for (NormalizedValueWithConfidence normalizedValue : normalizedValues) {
                Node newEl = element.cloneNode(false);
                report.increment(this.normalization.getClass().getSimpleName(), normalizedValue.getConfidenceClass());
                newEl.appendChild(element.getOwnerDocument().createTextNode(normalizedValue.getNormalizedValue()));
                element.getParentNode().insertBefore(newEl, element.getNextSibling());
            }
        }
    }

    @Override
    public NormalizationReport normalize(Document edm) throws NormalizationException {
        InternalNormalizationReport report = new InternalNormalizationReport();
        for (XpathQuery query : this.targetElements) {
            NodeList queryResult;
            try {
                queryResult = query.execute(edm);
            }
            catch (XPathExpressionException e) {
                throw new NormalizationException("Xpath query issue: " + e.getMessage(), e);
            }
            for (int i = 0; i < queryResult.getLength(); ++i) {
                Node node = queryResult.item(i);
                if (node instanceof Attr) {
                    this.normalizeAttribute((Attr)node, report);
                    continue;
                }
                if (!(node instanceof Element)) continue;
                this.normalizeElement((Element)node, report);
            }
        }
        return report;
    }
}

