/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.normalizers;

import eu.europeana.normalization.model.NormalizationReport;
import eu.europeana.normalization.normalizers.RecordNormalizeAction;
import eu.europeana.normalization.util.NormalizationException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public class ChainedNormalizer
implements RecordNormalizeAction {
    private final List<RecordNormalizeAction> normalizations;

    public ChainedNormalizer(RecordNormalizeAction ... normalizations) {
        this.normalizations = Arrays.stream(normalizations).collect(Collectors.toList());
    }

    @Override
    public NormalizationReport normalize(Document edm) throws NormalizationException {
        NormalizationReport report = new NormalizationReport();
        for (RecordNormalizeAction normOp : this.normalizations) {
            report.mergeWith(normOp.normalize(edm));
        }
        return report;
    }
}

